/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class PoolRetirement
implements Certificate {
    private final CertificateType type = CertificateType.POOL_RETIREMENT;
    private byte[] poolKeyHash;
    private long epoch;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(4L));
        array.add((DataItem)new ByteString(this.poolKeyHash));
        array.add((DataItem)new UnsignedInteger(this.epoch));
        return array;
    }

    public static PoolRetirement deserialize(@NonNull Array poolRetirementArray) throws CborDeserializationException {
        if (poolRetirementArray == null) {
            throw new NullPointerException("poolRetirementArray is marked non-null but is null");
        }
        List dataItemList = poolRetirementArray.getDataItems();
        if (dataItemList == null || dataItemList.size() != 3) {
            throw new CborDeserializationException("PoolRetirement deserialization failed. Invalid number of DataItem(s) : " + (dataItemList != null ? String.valueOf(dataItemList.size()) : null));
        }
        UnsignedInteger type = (UnsignedInteger)dataItemList.get(0);
        if (type == null || type.getValue().intValue() != 4) {
            throw new CborDeserializationException("PoolRetirement deserialization failed. Invalid type : " + String.valueOf(type) != null ? String.valueOf(type.getValue().intValue()) : null);
        }
        byte[] poolKeyHash = CborSerializationUtil.toBytes((DataItem)((DataItem)dataItemList.get(1)));
        long epoch = CborSerializationUtil.toLong((DataItem)((DataItem)dataItemList.get(2)));
        return new PoolRetirement(poolKeyHash, epoch);
    }

    public static PoolRetirementBuilder builder() {
        return new PoolRetirementBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public byte[] getPoolKeyHash() {
        return this.poolKeyHash;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public PoolRetirement() {
    }

    public PoolRetirement(byte[] poolKeyHash, long epoch) {
        this.poolKeyHash = poolKeyHash;
        this.epoch = epoch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolRetirement)) {
            return false;
        }
        PoolRetirement other = (PoolRetirement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return Arrays.equals(this.getPoolKeyHash(), other.getPoolKeyHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoolRetirement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch >>> 32 ^ $epoch);
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPoolKeyHash());
        return result;
    }

    public String toString() {
        return "PoolRetirement(type=" + String.valueOf((Object)this.getType()) + ", poolKeyHash=" + Arrays.toString(this.getPoolKeyHash()) + ", epoch=" + this.getEpoch() + ")";
    }

    public static class PoolRetirementBuilder {
        private byte[] poolKeyHash;
        private long epoch;

        PoolRetirementBuilder() {
        }

        public PoolRetirementBuilder poolKeyHash(byte[] poolKeyHash) {
            this.poolKeyHash = poolKeyHash;
            return this;
        }

        public PoolRetirementBuilder epoch(long epoch) {
            this.epoch = epoch;
            return this;
        }

        public PoolRetirement build() {
            return new PoolRetirement(this.poolKeyHash, this.epoch);
        }

        public String toString() {
            return "PoolRetirement.PoolRetirementBuilder(poolKeyHash=" + Arrays.toString(this.poolKeyHash) + ", epoch=" + this.epoch + ")";
        }
    }
}

