/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.util.CredentialSerializer;
import java.util.List;
import java.util.Objects;

public class ResignCommitteeColdCert
implements Certificate {
    private final CertificateType type = CertificateType.RESIGN_COMMITTEE_COLD_CERT;
    private Credential committeeColdCredential;
    private Anchor anchor;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.committeeColdCredential);
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        array.add((DataItem)CredentialSerializer.serialize(this.committeeColdCredential));
        if (this.anchor != null) {
            array.add(this.anchor.serialize());
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        return array;
    }

    public static ResignCommitteeColdCert deserialize(DataItem di) {
        Array certArray = (Array)di;
        List dataItemList = certArray.getDataItems();
        Credential committeeColdCred = CredentialSerializer.deserialize((Array)dataItemList.get(1));
        DataItem anchorDI = (DataItem)dataItemList.get(2);
        Anchor anchor = null;
        if (anchorDI != SimpleValue.NULL) {
            anchor = Anchor.deserialize((Array)anchorDI);
        }
        return new ResignCommitteeColdCert(committeeColdCred, anchor);
    }

    public static ResignCommitteeColdCertBuilder builder() {
        return new ResignCommitteeColdCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public Credential getCommitteeColdCredential() {
        return this.committeeColdCredential;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setCommitteeColdCredential(Credential committeeColdCredential) {
        this.committeeColdCredential = committeeColdCredential;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResignCommitteeColdCert)) {
            return false;
        }
        ResignCommitteeColdCert other = (ResignCommitteeColdCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Credential this$committeeColdCredential = this.getCommitteeColdCredential();
        Credential other$committeeColdCredential = other.getCommitteeColdCredential();
        if (this$committeeColdCredential == null ? other$committeeColdCredential != null : !this$committeeColdCredential.equals(other$committeeColdCredential)) {
            return false;
        }
        Anchor this$anchor = this.getAnchor();
        Anchor other$anchor = other.getAnchor();
        return !(this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResignCommitteeColdCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Credential $committeeColdCredential = this.getCommitteeColdCredential();
        result = result * 59 + ($committeeColdCredential == null ? 43 : $committeeColdCredential.hashCode());
        Anchor $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        return result;
    }

    public String toString() {
        return "ResignCommitteeColdCert(type=" + String.valueOf((Object)this.getType()) + ", committeeColdCredential=" + String.valueOf(this.getCommitteeColdCredential()) + ", anchor=" + String.valueOf(this.getAnchor()) + ")";
    }

    public ResignCommitteeColdCert(Credential committeeColdCredential, Anchor anchor) {
        this.committeeColdCredential = committeeColdCredential;
        this.anchor = anchor;
    }

    public ResignCommitteeColdCert() {
    }

    public static class ResignCommitteeColdCertBuilder {
        private Credential committeeColdCredential;
        private Anchor anchor;

        ResignCommitteeColdCertBuilder() {
        }

        public ResignCommitteeColdCertBuilder committeeColdCredential(Credential committeeColdCredential) {
            this.committeeColdCredential = committeeColdCredential;
            return this;
        }

        public ResignCommitteeColdCertBuilder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public ResignCommitteeColdCert build() {
            return new ResignCommitteeColdCert(this.committeeColdCredential, this.anchor);
        }

        public String toString() {
            return "ResignCommitteeColdCert.ResignCommitteeColdCertBuilder(committeeColdCredential=" + String.valueOf(this.committeeColdCredential) + ", anchor=" + String.valueOf(this.anchor) + ")";
        }
    }
}

