/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class StakeRegDelegCert
implements Certificate {
    private final CertificateType type = CertificateType.STAKE_REG_DELEG_CERT;
    private StakeCredential stakeCredential;
    private String poolKeyHash;
    private BigInteger coin;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.stakeCredential);
        Objects.requireNonNull(this.poolKeyHash);
        Objects.requireNonNull(this.coin);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)this.stakeCredential.serialize());
        certArray.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.poolKeyHash)));
        certArray.add((DataItem)new UnsignedInteger(this.coin));
        return certArray;
    }

    public static StakeRegDelegCert deserialize(Array certArray) {
        List dataItemList = certArray.getDataItems();
        StakeCredential stakeCredential = StakeCredential.deserialize((Array)dataItemList.get(1));
        String poolKeyHash = CborSerializationUtil.toHex((DataItem)((DataItem)dataItemList.get(2)));
        BigInteger coin = CborSerializationUtil.getBigInteger((DataItem)((DataItem)dataItemList.get(3)));
        return new StakeRegDelegCert(stakeCredential, poolKeyHash, coin);
    }

    public static StakeRegDelegCertBuilder builder() {
        return new StakeRegDelegCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public StakeCredential getStakeCredential() {
        return this.stakeCredential;
    }

    public String getPoolKeyHash() {
        return this.poolKeyHash;
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public void setStakeCredential(StakeCredential stakeCredential) {
        this.stakeCredential = stakeCredential;
    }

    public void setPoolKeyHash(String poolKeyHash) {
        this.poolKeyHash = poolKeyHash;
    }

    public void setCoin(BigInteger coin) {
        this.coin = coin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StakeRegDelegCert)) {
            return false;
        }
        StakeRegDelegCert other = (StakeRegDelegCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        StakeCredential this$stakeCredential = this.getStakeCredential();
        StakeCredential other$stakeCredential = other.getStakeCredential();
        if (this$stakeCredential == null ? other$stakeCredential != null : !((Object)this$stakeCredential).equals(other$stakeCredential)) {
            return false;
        }
        String this$poolKeyHash = this.getPoolKeyHash();
        String other$poolKeyHash = other.getPoolKeyHash();
        if (this$poolKeyHash == null ? other$poolKeyHash != null : !this$poolKeyHash.equals(other$poolKeyHash)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        return !(this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StakeRegDelegCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        StakeCredential $stakeCredential = this.getStakeCredential();
        result = result * 59 + ($stakeCredential == null ? 43 : ((Object)$stakeCredential).hashCode());
        String $poolKeyHash = this.getPoolKeyHash();
        result = result * 59 + ($poolKeyHash == null ? 43 : $poolKeyHash.hashCode());
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        return result;
    }

    public String toString() {
        return "StakeRegDelegCert(type=" + String.valueOf((Object)this.getType()) + ", stakeCredential=" + String.valueOf(this.getStakeCredential()) + ", poolKeyHash=" + this.getPoolKeyHash() + ", coin=" + String.valueOf(this.getCoin()) + ")";
    }

    public StakeRegDelegCert(StakeCredential stakeCredential, String poolKeyHash, BigInteger coin) {
        this.stakeCredential = stakeCredential;
        this.poolKeyHash = poolKeyHash;
        this.coin = coin;
    }

    public StakeRegDelegCert() {
    }

    public static class StakeRegDelegCertBuilder {
        private StakeCredential stakeCredential;
        private String poolKeyHash;
        private BigInteger coin;

        StakeRegDelegCertBuilder() {
        }

        public StakeRegDelegCertBuilder stakeCredential(StakeCredential stakeCredential) {
            this.stakeCredential = stakeCredential;
            return this;
        }

        public StakeRegDelegCertBuilder poolKeyHash(String poolKeyHash) {
            this.poolKeyHash = poolKeyHash;
            return this;
        }

        public StakeRegDelegCertBuilder coin(BigInteger coin) {
            this.coin = coin;
            return this;
        }

        public StakeRegDelegCert build() {
            return new StakeRegDelegCert(this.stakeCredential, this.poolKeyHash, this.coin);
        }

        public String toString() {
            return "StakeRegDelegCert.StakeRegDelegCertBuilder(stakeCredential=" + String.valueOf(this.stakeCredential) + ", poolKeyHash=" + this.poolKeyHash + ", coin=" + String.valueOf(this.coin) + ")";
        }
    }
}

