/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;
import java.util.Objects;

public class StakeVoteDelegCert
implements Certificate {
    private final CertificateType type = CertificateType.STAKE_VOTE_DELEG_CERT;
    private StakeCredential stakeCredential;
    private String poolKeyHash;
    private DRep drep;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.stakeCredential);
        Objects.requireNonNull(this.poolKeyHash);
        Objects.requireNonNull(this.drep);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)this.stakeCredential.serialize());
        certArray.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.poolKeyHash)));
        certArray.add(this.drep.serialize());
        return certArray;
    }

    public static StakeVoteDelegCert deserialize(DataItem di) {
        Array certArray = (Array)di;
        List dataItemList = certArray.getDataItems();
        StakeCredential stakeCredential = StakeCredential.deserialize((Array)dataItemList.get(1));
        String poolKeyHash = CborSerializationUtil.toHex((DataItem)((DataItem)dataItemList.get(2)));
        DRep drep = DRep.deserialize((DataItem)dataItemList.get(3));
        return new StakeVoteDelegCert(stakeCredential, poolKeyHash, drep);
    }

    public static StakeVoteDelegCertBuilder builder() {
        return new StakeVoteDelegCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public StakeCredential getStakeCredential() {
        return this.stakeCredential;
    }

    public String getPoolKeyHash() {
        return this.poolKeyHash;
    }

    public DRep getDrep() {
        return this.drep;
    }

    public void setStakeCredential(StakeCredential stakeCredential) {
        this.stakeCredential = stakeCredential;
    }

    public void setPoolKeyHash(String poolKeyHash) {
        this.poolKeyHash = poolKeyHash;
    }

    public void setDrep(DRep drep) {
        this.drep = drep;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StakeVoteDelegCert)) {
            return false;
        }
        StakeVoteDelegCert other = (StakeVoteDelegCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        StakeCredential this$stakeCredential = this.getStakeCredential();
        StakeCredential other$stakeCredential = other.getStakeCredential();
        if (this$stakeCredential == null ? other$stakeCredential != null : !((Object)this$stakeCredential).equals(other$stakeCredential)) {
            return false;
        }
        String this$poolKeyHash = this.getPoolKeyHash();
        String other$poolKeyHash = other.getPoolKeyHash();
        if (this$poolKeyHash == null ? other$poolKeyHash != null : !this$poolKeyHash.equals(other$poolKeyHash)) {
            return false;
        }
        DRep this$drep = this.getDrep();
        DRep other$drep = other.getDrep();
        return !(this$drep == null ? other$drep != null : !((Object)this$drep).equals(other$drep));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StakeVoteDelegCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        StakeCredential $stakeCredential = this.getStakeCredential();
        result = result * 59 + ($stakeCredential == null ? 43 : ((Object)$stakeCredential).hashCode());
        String $poolKeyHash = this.getPoolKeyHash();
        result = result * 59 + ($poolKeyHash == null ? 43 : $poolKeyHash.hashCode());
        DRep $drep = this.getDrep();
        result = result * 59 + ($drep == null ? 43 : ((Object)$drep).hashCode());
        return result;
    }

    public String toString() {
        return "StakeVoteDelegCert(type=" + String.valueOf((Object)this.getType()) + ", stakeCredential=" + String.valueOf(this.getStakeCredential()) + ", poolKeyHash=" + this.getPoolKeyHash() + ", drep=" + String.valueOf(this.getDrep()) + ")";
    }

    public StakeVoteDelegCert(StakeCredential stakeCredential, String poolKeyHash, DRep drep) {
        this.stakeCredential = stakeCredential;
        this.poolKeyHash = poolKeyHash;
        this.drep = drep;
    }

    public StakeVoteDelegCert() {
    }

    public static class StakeVoteDelegCertBuilder {
        private StakeCredential stakeCredential;
        private String poolKeyHash;
        private DRep drep;

        StakeVoteDelegCertBuilder() {
        }

        public StakeVoteDelegCertBuilder stakeCredential(StakeCredential stakeCredential) {
            this.stakeCredential = stakeCredential;
            return this;
        }

        public StakeVoteDelegCertBuilder poolKeyHash(String poolKeyHash) {
            this.poolKeyHash = poolKeyHash;
            return this;
        }

        public StakeVoteDelegCertBuilder drep(DRep drep) {
            this.drep = drep;
            return this;
        }

        public StakeVoteDelegCert build() {
            return new StakeVoteDelegCert(this.stakeCredential, this.poolKeyHash, this.drep);
        }

        public String toString() {
            return "StakeVoteDelegCert.StakeVoteDelegCertBuilder(stakeCredential=" + String.valueOf(this.stakeCredential) + ", poolKeyHash=" + this.poolKeyHash + ", drep=" + String.valueOf(this.drep) + ")";
        }
    }
}

