/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class UnregCert
implements Certificate {
    private final CertificateType type = CertificateType.UNREG_CERT;
    private StakeCredential stakeCredential;
    private BigInteger coin;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.stakeCredential);
        Objects.requireNonNull(this.coin);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)this.stakeCredential.serialize());
        certArray.add((DataItem)new UnsignedInteger(this.coin));
        return certArray;
    }

    public static UnregCert deserialize(Array certArray) {
        List dataItemList = certArray.getDataItems();
        StakeCredential stakeCredential = StakeCredential.deserialize((Array)dataItemList.get(1));
        BigInteger coin = CborSerializationUtil.getBigInteger((DataItem)((DataItem)dataItemList.get(2)));
        return new UnregCert(stakeCredential, coin);
    }

    public static UnregCertBuilder builder() {
        return new UnregCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public StakeCredential getStakeCredential() {
        return this.stakeCredential;
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public void setStakeCredential(StakeCredential stakeCredential) {
        this.stakeCredential = stakeCredential;
    }

    public void setCoin(BigInteger coin) {
        this.coin = coin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnregCert)) {
            return false;
        }
        UnregCert other = (UnregCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        StakeCredential this$stakeCredential = this.getStakeCredential();
        StakeCredential other$stakeCredential = other.getStakeCredential();
        if (this$stakeCredential == null ? other$stakeCredential != null : !((Object)this$stakeCredential).equals(other$stakeCredential)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        return !(this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnregCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        StakeCredential $stakeCredential = this.getStakeCredential();
        result = result * 59 + ($stakeCredential == null ? 43 : ((Object)$stakeCredential).hashCode());
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        return result;
    }

    public String toString() {
        return "UnregCert(type=" + String.valueOf((Object)this.getType()) + ", stakeCredential=" + String.valueOf(this.getStakeCredential()) + ", coin=" + String.valueOf(this.getCoin()) + ")";
    }

    public UnregCert(StakeCredential stakeCredential, BigInteger coin) {
        this.stakeCredential = stakeCredential;
        this.coin = coin;
    }

    public UnregCert() {
    }

    public static class UnregCertBuilder {
        private StakeCredential stakeCredential;
        private BigInteger coin;

        UnregCertBuilder() {
        }

        public UnregCertBuilder stakeCredential(StakeCredential stakeCredential) {
            this.stakeCredential = stakeCredential;
            return this;
        }

        public UnregCertBuilder coin(BigInteger coin) {
            this.coin = coin;
            return this;
        }

        public UnregCert build() {
            return new UnregCert(this.stakeCredential, this.coin);
        }

        public String toString() {
            return "UnregCert.UnregCertBuilder(stakeCredential=" + String.valueOf(this.stakeCredential) + ", coin=" + String.valueOf(this.coin) + ")";
        }
    }
}

