/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class VoteRegDelegCert
implements Certificate {
    private final CertificateType type = CertificateType.VOTE_REG_DELEG_CERT;
    private StakeCredential stakeCredential;
    private DRep drep;
    private BigInteger coin;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.stakeCredential);
        Objects.requireNonNull(this.drep);
        Objects.requireNonNull(this.coin);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)this.stakeCredential.serialize());
        certArray.add(this.drep.serialize());
        certArray.add((DataItem)new UnsignedInteger(this.coin));
        return certArray;
    }

    public static VoteRegDelegCert deserialize(Array certArray) {
        List dataItemList = certArray.getDataItems();
        StakeCredential stakeCredential = StakeCredential.deserialize((Array)dataItemList.get(1));
        DRep drep = DRep.deserialize((DataItem)dataItemList.get(2));
        BigInteger coin = CborSerializationUtil.getBigInteger((DataItem)((DataItem)dataItemList.get(3)));
        return new VoteRegDelegCert(stakeCredential, drep, coin);
    }

    public static VoteRegDelegCertBuilder builder() {
        return new VoteRegDelegCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public StakeCredential getStakeCredential() {
        return this.stakeCredential;
    }

    public DRep getDrep() {
        return this.drep;
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public void setStakeCredential(StakeCredential stakeCredential) {
        this.stakeCredential = stakeCredential;
    }

    public void setDrep(DRep drep) {
        this.drep = drep;
    }

    public void setCoin(BigInteger coin) {
        this.coin = coin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoteRegDelegCert)) {
            return false;
        }
        VoteRegDelegCert other = (VoteRegDelegCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        StakeCredential this$stakeCredential = this.getStakeCredential();
        StakeCredential other$stakeCredential = other.getStakeCredential();
        if (this$stakeCredential == null ? other$stakeCredential != null : !((Object)this$stakeCredential).equals(other$stakeCredential)) {
            return false;
        }
        DRep this$drep = this.getDrep();
        DRep other$drep = other.getDrep();
        if (this$drep == null ? other$drep != null : !((Object)this$drep).equals(other$drep)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        return !(this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VoteRegDelegCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        StakeCredential $stakeCredential = this.getStakeCredential();
        result = result * 59 + ($stakeCredential == null ? 43 : ((Object)$stakeCredential).hashCode());
        DRep $drep = this.getDrep();
        result = result * 59 + ($drep == null ? 43 : ((Object)$drep).hashCode());
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        return result;
    }

    public String toString() {
        return "VoteRegDelegCert(type=" + String.valueOf((Object)this.getType()) + ", stakeCredential=" + String.valueOf(this.getStakeCredential()) + ", drep=" + String.valueOf(this.getDrep()) + ", coin=" + String.valueOf(this.getCoin()) + ")";
    }

    public VoteRegDelegCert(StakeCredential stakeCredential, DRep drep, BigInteger coin) {
        this.stakeCredential = stakeCredential;
        this.drep = drep;
        this.coin = coin;
    }

    public VoteRegDelegCert() {
    }

    public static class VoteRegDelegCertBuilder {
        private StakeCredential stakeCredential;
        private DRep drep;
        private BigInteger coin;

        VoteRegDelegCertBuilder() {
        }

        public VoteRegDelegCertBuilder stakeCredential(StakeCredential stakeCredential) {
            this.stakeCredential = stakeCredential;
            return this;
        }

        public VoteRegDelegCertBuilder drep(DRep drep) {
            this.drep = drep;
            return this;
        }

        public VoteRegDelegCertBuilder coin(BigInteger coin) {
            this.coin = coin;
            return this;
        }

        public VoteRegDelegCert build() {
            return new VoteRegDelegCert(this.stakeCredential, this.drep, this.coin);
        }

        public String toString() {
            return "VoteRegDelegCert.VoteRegDelegCertBuilder(stakeCredential=" + String.valueOf(this.stakeCredential) + ", drep=" + String.valueOf(this.drep) + ", coin=" + String.valueOf(this.coin) + ")";
        }
    }
}

