/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;
import java.util.Objects;

public class Constitution {
    private Anchor anchor;
    private String scripthash;

    public Array serialize() {
        Objects.requireNonNull(this.anchor);
        Array array = new Array();
        array.add(this.anchor.serialize());
        if (this.scripthash != null) {
            array.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.scripthash)));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        return array;
    }

    public static Constitution deserialize(Array array) {
        List constitutionDIList = array.getDataItems();
        if (constitutionDIList.size() != 2) {
            throw new IllegalArgumentException("Invalid constitution array. Expected 2 items. Found : " + constitutionDIList.size());
        }
        Anchor anchor = Anchor.deserialize((Array)constitutionDIList.get(0));
        DataItem scriptHashDI = (DataItem)constitutionDIList.get(1);
        String scriptHash = scriptHashDI == SimpleValue.NULL ? null : CborSerializationUtil.toHex((DataItem)scriptHashDI);
        return new Constitution(anchor, scriptHash);
    }

    public static ConstitutionBuilder builder() {
        return new ConstitutionBuilder();
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public String getScripthash() {
        return this.scripthash;
    }

    public Constitution(Anchor anchor, String scripthash) {
        this.anchor = anchor;
        this.scripthash = scripthash;
    }

    public Constitution() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Constitution)) {
            return false;
        }
        Constitution other = (Constitution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Anchor this$anchor = this.getAnchor();
        Anchor other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor)) {
            return false;
        }
        String this$scripthash = this.getScripthash();
        String other$scripthash = other.getScripthash();
        return !(this$scripthash == null ? other$scripthash != null : !this$scripthash.equals(other$scripthash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Constitution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Anchor $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        String $scripthash = this.getScripthash();
        result = result * 59 + ($scripthash == null ? 43 : $scripthash.hashCode());
        return result;
    }

    public String toString() {
        return "Constitution(anchor=" + String.valueOf(this.getAnchor()) + ", scripthash=" + this.getScripthash() + ")";
    }

    public static class ConstitutionBuilder {
        private Anchor anchor;
        private String scripthash;

        ConstitutionBuilder() {
        }

        public ConstitutionBuilder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public ConstitutionBuilder scripthash(String scripthash) {
            this.scripthash = scripthash;
            return this;
        }

        public Constitution build() {
            return new Constitution(this.anchor, this.scripthash);
        }

        public String toString() {
            return "Constitution.ConstitutionBuilder(anchor=" + String.valueOf(this.anchor) + ", scripthash=" + this.scripthash + ")";
        }
    }
}

