/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.transaction.spec.governance.VoterType;
import java.util.List;
import java.util.Objects;

public class Voter {
    private VoterType type;
    private Credential credential;

    public DataItem serialize() {
        int key;
        Objects.requireNonNull(this.type);
        Objects.requireNonNull(this.credential);
        Array array = new Array();
        switch (this.type) {
            case CONSTITUTIONAL_COMMITTEE_HOT_KEY_HASH: {
                key = 0;
                break;
            }
            case CONSTITUTIONAL_COMMITTEE_HOT_SCRIPT_HASH: {
                key = 1;
                break;
            }
            case DREP_KEY_HASH: {
                key = 2;
                break;
            }
            case DREP_SCRIPT_HASH: {
                key = 3;
                break;
            }
            case STAKING_POOL_KEY_HASH: {
                key = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid voter type : " + String.valueOf((Object)this.type));
            }
        }
        array.add((DataItem)new UnsignedInteger((long)key));
        array.add((DataItem)new ByteString(this.credential.getBytes()));
        return array;
    }

    public static Voter deserialize(Array voterArray) {
        if (voterArray != null && voterArray.getDataItems().size() != 2) {
            throw new IllegalArgumentException("Invalid voter array. Expected 2 items. Found : " + voterArray.getDataItems().size());
        }
        List diList = voterArray.getDataItems();
        int key = ((UnsignedInteger)diList.get(0)).getValue().intValue();
        byte[] hash = ((ByteString)diList.get(1)).getBytes();
        switch (key) {
            case 0: {
                return new Voter(VoterType.CONSTITUTIONAL_COMMITTEE_HOT_KEY_HASH, Credential.fromKey((byte[])hash));
            }
            case 1: {
                return new Voter(VoterType.CONSTITUTIONAL_COMMITTEE_HOT_SCRIPT_HASH, Credential.fromScript((byte[])hash));
            }
            case 2: {
                return new Voter(VoterType.DREP_KEY_HASH, Credential.fromKey((byte[])hash));
            }
            case 3: {
                return new Voter(VoterType.DREP_SCRIPT_HASH, Credential.fromScript((byte[])hash));
            }
            case 4: {
                return new Voter(VoterType.STAKING_POOL_KEY_HASH, Credential.fromKey((byte[])hash));
            }
        }
        throw new IllegalArgumentException("Invalid voter key. Expected 0,1,2,3,4. Found : " + key);
    }

    public static VoterBuilder builder() {
        return new VoterBuilder();
    }

    public VoterType getType() {
        return this.type;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setType(VoterType type) {
        this.type = type;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Voter)) {
            return false;
        }
        Voter other = (Voter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        VoterType this$type = this.getType();
        VoterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Credential this$credential = this.getCredential();
        Credential other$credential = other.getCredential();
        return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Voter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        VoterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Credential $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
        return result;
    }

    public String toString() {
        return "Voter(type=" + String.valueOf((Object)this.getType()) + ", credential=" + String.valueOf(this.getCredential()) + ")";
    }

    public Voter(VoterType type, Credential credential) {
        this.type = type;
        this.credential = credential;
    }

    public Voter() {
    }

    public static class VoterBuilder {
        private VoterType type;
        private Credential credential;

        VoterBuilder() {
        }

        public VoterBuilder type(VoterType type) {
            this.type = type;
            return this;
        }

        public VoterBuilder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Voter build() {
            return new Voter(this.type, this.credential);
        }

        public String toString() {
            return "Voter.VoterBuilder(type=" + String.valueOf((Object)this.type) + ", credential=" + String.valueOf(this.credential) + ")";
        }
    }
}

