/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance.actions;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;
import java.util.Objects;

public class GovActionId {
    private String transactionId;
    private int govActionIndex;

    public DataItem serialize() {
        Objects.requireNonNull(this.transactionId);
        Array array = new Array();
        array.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.transactionId)));
        array.add((DataItem)new UnsignedInteger((long)this.govActionIndex));
        return array;
    }

    public static GovActionId deserialize(DataItem di) {
        Array actionIdArray = (Array)di;
        if (actionIdArray != null && actionIdArray.getDataItems().size() != 2) {
            throw new IllegalArgumentException("Invalid gov_action_id array. Expected 2 items. Found : " + actionIdArray.getDataItems().size());
        }
        List diList = actionIdArray.getDataItems();
        String txId = HexUtil.encodeHexString((byte[])((ByteString)diList.get(0)).getBytes());
        int govActionIndex = ((UnsignedInteger)diList.get(1)).getValue().intValue();
        return new GovActionId(txId, govActionIndex);
    }

    public static GovActionIdBuilder builder() {
        return new GovActionIdBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int getGovActionIndex() {
        return this.govActionIndex;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setGovActionIndex(int govActionIndex) {
        this.govActionIndex = govActionIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GovActionId)) {
            return false;
        }
        GovActionId other = (GovActionId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGovActionIndex() != other.getGovActionIndex()) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GovActionId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGovActionIndex();
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
    }

    public String toString() {
        return "GovActionId(transactionId=" + this.getTransactionId() + ", govActionIndex=" + this.getGovActionIndex() + ")";
    }

    public GovActionId(String transactionId, int govActionIndex) {
        this.transactionId = transactionId;
        this.govActionIndex = govActionIndex;
    }

    public GovActionId() {
    }

    public static class GovActionIdBuilder {
        private String transactionId;
        private int govActionIndex;

        GovActionIdBuilder() {
        }

        public GovActionIdBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public GovActionIdBuilder govActionIndex(int govActionIndex) {
            this.govActionIndex = govActionIndex;
            return this;
        }

        public GovActionId build() {
            return new GovActionId(this.transactionId, this.govActionIndex);
        }

        public String toString() {
            return "GovActionId.GovActionIdBuilder(transactionId=" + this.transactionId + ", govActionIndex=" + this.govActionIndex + ")";
        }
    }
}

