/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptType;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;

public class RequireTimeBefore
implements NativeScript {
    private final ScriptType type = ScriptType.before;
    private BigInteger slot;

    public RequireTimeBefore(long slot) {
        this.slot = BigInteger.valueOf(slot);
    }

    public RequireTimeBefore(BigInteger slot) {
        this.slot = slot;
    }

    public DataItem serializeAsDataItem() {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(5L));
        array.add((DataItem)new UnsignedInteger(this.slot));
        return array;
    }

    public static RequireTimeBefore deserialize(Array array) throws CborDeserializationException {
        long slot = ((UnsignedInteger)array.getDataItems().get(1)).getValue().longValue();
        return new RequireTimeBefore(slot);
    }

    public static RequireTimeBefore deserialize(JsonNode jsonNode) throws CborDeserializationException {
        long slot = jsonNode.get("slot").asLong();
        return new RequireTimeBefore(slot);
    }

    public ScriptType getType() {
        return this.type;
    }

    public BigInteger getSlot() {
        return this.slot;
    }

    public void setSlot(BigInteger slot) {
        this.slot = slot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequireTimeBefore)) {
            return false;
        }
        RequireTimeBefore other = (RequireTimeBefore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScriptType this$type = this.getType();
        ScriptType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        BigInteger this$slot = this.getSlot();
        BigInteger other$slot = other.getSlot();
        return !(this$slot == null ? other$slot != null : !((Object)this$slot).equals(other$slot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequireTimeBefore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScriptType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        BigInteger $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : ((Object)$slot).hashCode());
        return result;
    }

    public String toString() {
        return "RequireTimeBefore(type=" + String.valueOf((Object)this.getType()) + ", slot=" + String.valueOf(this.getSlot()) + ")";
    }

    public RequireTimeBefore() {
    }
}

