/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;

public class ScriptAll
implements NativeScript {
    private final ScriptType type = ScriptType.all;
    private final List<NativeScript> scripts = new ArrayList<NativeScript>();

    public ScriptAll addScript(NativeScript script) {
        this.scripts.add(script);
        return this;
    }

    public DataItem serializeAsDataItem() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(1L));
        Array scriptsArray = new Array();
        for (NativeScript script : this.scripts) {
            scriptsArray.add(script.serializeAsDataItem());
        }
        array.add((DataItem)scriptsArray);
        return array;
    }

    public static ScriptAll deserialize(Array array) throws CborDeserializationException {
        ScriptAll scriptAll = new ScriptAll();
        Array scriptsDIArray = (Array)array.getDataItems().get(1);
        for (DataItem scriptDI : scriptsDIArray.getDataItems()) {
            Array scriptArray;
            NativeScript nativeScript;
            if (scriptDI == SimpleValue.BREAK || (nativeScript = NativeScript.deserialize(scriptArray = (Array)scriptDI)) == null) continue;
            scriptAll.addScript(nativeScript);
        }
        return scriptAll;
    }

    public static ScriptAll deserialize(JsonNode jsonNode) throws CborDeserializationException {
        ScriptAll scriptAll = new ScriptAll();
        ArrayNode scriptsNode = (ArrayNode)jsonNode.get("scripts");
        for (JsonNode scriptNode : scriptsNode) {
            NativeScript nativeScript = NativeScript.deserialize(scriptNode);
            scriptAll.addScript(nativeScript);
        }
        return scriptAll;
    }

    public ScriptType getType() {
        return this.type;
    }

    public List<NativeScript> getScripts() {
        return this.scripts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptAll)) {
            return false;
        }
        ScriptAll other = (ScriptAll)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScriptType this$type = this.getType();
        ScriptType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<NativeScript> this$scripts = this.getScripts();
        List<NativeScript> other$scripts = other.getScripts();
        return !(this$scripts == null ? other$scripts != null : !((Object)this$scripts).equals(other$scripts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScriptAll;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScriptType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<NativeScript> $scripts = this.getScripts();
        result = result * 59 + ($scripts == null ? 43 : ((Object)$scripts).hashCode());
        return result;
    }

    public String toString() {
        return "ScriptAll(type=" + String.valueOf((Object)this.getType()) + ", scripts=" + String.valueOf(this.getScripts()) + ")";
    }
}

