/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;

public class ScriptAny
implements NativeScript {
    private final ScriptType type = ScriptType.any;
    private final List<NativeScript> scripts = new ArrayList<NativeScript>();

    public ScriptAny addScript(NativeScript script) {
        this.scripts.add(script);
        return this;
    }

    public DataItem serializeAsDataItem() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(2L));
        Array scriptsArray = new Array();
        for (NativeScript script : this.scripts) {
            scriptsArray.add(script.serializeAsDataItem());
        }
        array.add((DataItem)scriptsArray);
        return array;
    }

    public static ScriptAny deserialize(Array array) throws CborDeserializationException {
        ScriptAny scriptAny = new ScriptAny();
        Array scriptsDIArray = (Array)array.getDataItems().get(1);
        for (DataItem scriptDI : scriptsDIArray.getDataItems()) {
            Array scriptArray;
            NativeScript nativeScript;
            if (scriptDI == SimpleValue.BREAK || (nativeScript = NativeScript.deserialize(scriptArray = (Array)scriptDI)) == null) continue;
            scriptAny.addScript(nativeScript);
        }
        return scriptAny;
    }

    public static ScriptAny deserialize(JsonNode jsonNode) throws CborDeserializationException {
        ScriptAny scriptAny = new ScriptAny();
        ArrayNode scriptsNode = (ArrayNode)jsonNode.get("scripts");
        for (JsonNode scriptNode : scriptsNode) {
            NativeScript nativeScript = NativeScript.deserialize(scriptNode);
            scriptAny.addScript(nativeScript);
        }
        return scriptAny;
    }

    public ScriptType getType() {
        return this.type;
    }

    public List<NativeScript> getScripts() {
        return this.scripts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptAny)) {
            return false;
        }
        ScriptAny other = (ScriptAny)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScriptType this$type = this.getType();
        ScriptType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<NativeScript> this$scripts = this.getScripts();
        List<NativeScript> other$scripts = other.getScripts();
        return !(this$scripts == null ? other$scripts != null : !((Object)this$scripts).equals(other$scripts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScriptAny;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScriptType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<NativeScript> $scripts = this.getScripts();
        result = result * 59 + ($scripts == null ? 43 : ((Object)$scripts).hashCode());
        return result;
    }

    public String toString() {
        return "ScriptAny(type=" + String.valueOf((Object)this.getType()) + ", scripts=" + String.valueOf(this.getScripts()) + ")";
    }
}

