/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ScriptAtLeast
implements NativeScript {
    private final ScriptType type = ScriptType.atLeast;
    private BigInteger required;
    private final List<NativeScript> scripts = new ArrayList<NativeScript>();

    public ScriptAtLeast(int required) {
        this.required = BigInteger.valueOf(required);
    }

    public ScriptAtLeast(long required) {
        this.required = BigInteger.valueOf(required);
    }

    public ScriptAtLeast(BigInteger required) {
        this.required = required;
    }

    public ScriptAtLeast addScript(NativeScript script) {
        this.scripts.add(script);
        return this;
    }

    public DataItem serializeAsDataItem() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(3L));
        if (this.required == null) {
            this.required = BigInteger.ZERO;
        }
        if (this.required.signum() >= 0) {
            array.add((DataItem)new UnsignedInteger(this.required));
        } else {
            array.add((DataItem)new NegativeInteger(this.required));
        }
        Array scriptsArray = new Array();
        for (NativeScript script : this.scripts) {
            scriptsArray.add(script.serializeAsDataItem());
        }
        array.add((DataItem)scriptsArray);
        return array;
    }

    public static ScriptAtLeast deserialize(Array array) throws CborDeserializationException {
        BigInteger required = ((Number)array.getDataItems().get(1)).getValue();
        ScriptAtLeast scriptAtLeast = new ScriptAtLeast(required);
        Array scriptsDIArray = (Array)array.getDataItems().get(2);
        for (DataItem scriptDI : scriptsDIArray.getDataItems()) {
            Array scriptArray;
            NativeScript nativeScript;
            if (scriptDI == SimpleValue.BREAK || (nativeScript = NativeScript.deserialize(scriptArray = (Array)scriptDI)) == null) continue;
            scriptAtLeast.addScript(nativeScript);
        }
        return scriptAtLeast;
    }

    public static ScriptAtLeast deserialize(JsonNode jsonNode) throws CborDeserializationException {
        String required = jsonNode.get("required").asText();
        ScriptAtLeast scriptAtLeast = new ScriptAtLeast(new BigInteger(required));
        ArrayNode scriptsNode = (ArrayNode)jsonNode.get("scripts");
        for (JsonNode scriptNode : scriptsNode) {
            NativeScript nativeScript = NativeScript.deserialize(scriptNode);
            scriptAtLeast.addScript(nativeScript);
        }
        return scriptAtLeast;
    }

    public ScriptType getType() {
        return this.type;
    }

    public BigInteger getRequired() {
        return this.required;
    }

    public List<NativeScript> getScripts() {
        return this.scripts;
    }

    public void setRequired(BigInteger required) {
        this.required = required;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptAtLeast)) {
            return false;
        }
        ScriptAtLeast other = (ScriptAtLeast)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScriptType this$type = this.getType();
        ScriptType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        BigInteger this$required = this.getRequired();
        BigInteger other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        List<NativeScript> this$scripts = this.getScripts();
        List<NativeScript> other$scripts = other.getScripts();
        return !(this$scripts == null ? other$scripts != null : !((Object)this$scripts).equals(other$scripts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScriptAtLeast;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScriptType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        BigInteger $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        List<NativeScript> $scripts = this.getScripts();
        result = result * 59 + ($scripts == null ? 43 : ((Object)$scripts).hashCode());
        return result;
    }

    public String toString() {
        return "ScriptAtLeast(type=" + String.valueOf((Object)this.getType()) + ", required=" + String.valueOf(this.getRequired()) + ", scripts=" + String.valueOf(this.getScripts()) + ")";
    }

    public ScriptAtLeast() {
    }
}

