/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.util;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.address.CredentialType;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import java.math.BigInteger;
import java.util.List;

public class CredentialSerializer {
    public static Credential deserialize(Array stakeCredArray) {
        List dataItemList = stakeCredArray.getDataItems();
        if (dataItemList == null || dataItemList.size() != 2) {
            throw new CborRuntimeException("Credential deserialization failed. Invalid number of DataItem(s) : " + (dataItemList != null ? String.valueOf(dataItemList.size()) : null));
        }
        UnsignedInteger typeDI = (UnsignedInteger)dataItemList.get(0);
        ByteString hashDI = (ByteString)dataItemList.get(1);
        BigInteger typeBI = typeDI.getValue();
        if (typeBI.intValue() == 0) {
            return Credential.fromKey((byte[])hashDI.getBytes());
        }
        if (typeBI.intValue() == 1) {
            return Credential.fromScript((byte[])hashDI.getBytes());
        }
        throw new CborRuntimeException("Credential deserialization failed. Invalid CredType : " + typeBI.intValue());
    }

    public static Array serialize(Credential credential) {
        Array array = new Array();
        if (credential.getType() == CredentialType.Key) {
            array.add((DataItem)new UnsignedInteger(0L));
        } else if (credential.getType() == CredentialType.Script) {
            array.add((DataItem)new UnsignedInteger(1L));
        } else {
            throw new CborRuntimeException("Invalid credential type : " + String.valueOf(credential.getType()));
        }
        array.add((DataItem)new ByteString(credential.getBytes()));
        return array;
    }
}

