/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.test;

import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.TransactionProcessor;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.backend.KupmiosBackendService;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.api.DefaultProtocolParamsSupplier;
import com.bloxbean.cardano.client.backend.api.DefaultTransactionProcessor;
import com.bloxbean.cardano.client.backend.api.DefaultUtxoSupplier;
import com.bloxbean.cardano.client.backend.api.EpochService;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBackendService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFEpochService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFTransactionService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFUtxoService;
import com.bloxbean.cardano.client.backend.kupo.KupoUtxoService;
import com.bloxbean.cardano.client.backend.ogmios.http.OgmiosEpochService;
import com.bloxbean.cardano.yaci.test.ApiMode;
import com.bloxbean.cardano.yaci.test.Funding;
import com.bloxbean.cardano.yaci.test.api.helper.YaciTestHelper;
import com.bloxbean.cardano.yaci.test.backend.ogmios.TestOgmiosTransactionService;
import java.time.Duration;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class YaciCardanoContainer
extends GenericContainer<YaciCardanoContainer> {
    private static final Logger log = LoggerFactory.getLogger(YaciCardanoContainer.class);
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"bloxbean/yaci-cli");
    private static final String DEFAULT_TAG = "0.10.0-preview2";
    public static final int STORE_PORT = 8080;
    public static final int CLUSTER_HTTP_PORT = 10000;
    public static final int SUBMIT_API_PORT = 8090;
    public static final int NODE_PORT = 3001;
    public static final int OGMIOS_PORT = 1337;
    public static final int KUPO_PORT = 1442;
    private static float DEFAULT_SLOT_LENGTH = 1.0f;
    private static float DEFAULT_BLOCK_TIME = 1.0f;
    private static long DEFAULT_WAIT_TIMEOUT = 120L;
    private static long waitTimeout;
    private ApiMode apiMode = ApiMode.YACI_STORE;
    private YaciTestHelper testHelper;

    public YaciCardanoContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public YaciCardanoContainer(String tag) {
        this(DEFAULT_IMAGE_NAME.withTag(tag));
    }

    public YaciCardanoContainer(DockerImageName dockerImageName) {
        this(dockerImageName, DEFAULT_BLOCK_TIME, DEFAULT_WAIT_TIMEOUT);
    }

    public YaciCardanoContainer(DockerImageName dockerImageName, float blockTime) {
        this(dockerImageName, blockTime, DEFAULT_WAIT_TIMEOUT);
    }

    public YaciCardanoContainer(DockerImageName dockerImageName, float blockTime, long waitTimeout) {
        super(dockerImageName);
        YaciCardanoContainer.waitTimeout = waitTimeout;
        if (!(blockTime >= 1.0f) || !(blockTime <= 20.0f)) {
            throw new IllegalArgumentException("Invalid blockTime. Value should be between 1 to 20");
        }
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8080, 10000, 8090, 3001, 1337, 1442});
        this.withCommand(new String[]{"create-node", "-o", "--slot-length", String.valueOf(DEFAULT_SLOT_LENGTH), "--block-time", String.valueOf(blockTime), "--start"});
    }

    public void start() {
        this.init();
        super.start();
    }

    private void init() {
        this.addEnv("yaci_cli_mode", "native");
        this.addEnv("yaci_store_mode", "native");
        this.addEnv("conwayHardForkAtEpoch", "1");
        this.addEnv("shiftStartTimeBehind", "true");
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"/app/yaci-cli"}));
        if (this.apiMode == ApiMode.YACI_STORE) {
            this.addEnv("yaci_store_enabled", "true");
            this.addEnv("ogmios_enabled", "true");
            this.waitingFor(Wait.forHttp((String)"/api/v1/epochs/parameters").forPort(8080).forStatusCode(200).forResponsePredicate(resp -> resp.contains("cost_models") && resp.contains("pool_deposit")).withStartupTimeout(Duration.ofSeconds(waitTimeout)));
            this.withStartupTimeout(Duration.ofSeconds(waitTimeout));
        } else if (this.apiMode == ApiMode.OGMIOS) {
            this.addEnv("ogmios_enabled", "true");
            this.addEnv("kupo_enabled", "true");
            this.waitingFor(Wait.forHttp((String)"/").forPort(1337).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(waitTimeout)));
            this.withStartupTimeout(Duration.ofSeconds(waitTimeout));
        } else {
            throw new IllegalArgumentException("Invalid ApiMode : " + this.apiMode);
        }
    }

    public YaciCardanoContainer withApiMode(ApiMode apiMode) {
        this.apiMode = apiMode;
        return this;
    }

    public YaciCardanoContainer withInitialFunding(Funding ... fundings) {
        if (fundings == null || fundings.length == 0) {
            return this;
        }
        String topupAddresses = Arrays.stream(fundings).map(funding -> funding.getAddress() + ":" + funding.getAdaValue()).collect(Collectors.joining(","));
        if (this.apiMode == ApiMode.YACI_STORE) {
            WaitAllStrategy waitStrategy = new WaitAllStrategy().withStrategy(Wait.forHttp((String)"/api/v1/epochs/parameters").forPort(8080).forStatusCode(200).forResponsePredicate(resp -> resp.contains("cost_models") && resp.contains("pool_deposit")).withStartupTimeout(Duration.ofSeconds(waitTimeout))).withStrategy(Wait.forHttp((String)("/api/v1/addresses/" + fundings[0].getAddress() + "/utxos")).forPort(8080).forResponsePredicate(s -> s.contains(fundings[0].getAddress())).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(waitTimeout)));
            this.waitingFor((WaitStrategy)waitStrategy);
        }
        this.addEnv("topup_addresses", topupAddresses);
        return this;
    }

    public int getYaciStorePort() {
        return this.getMappedPort(8080);
    }

    public int getOgmiosPort() {
        return this.getMappedPort(1337);
    }

    public int getKupoPort() {
        return this.getMappedPort(1442);
    }

    public int getLocalClusterPort() {
        return this.getMappedPort(10000);
    }

    public int getSubmitApiPort() {
        return this.getMappedPort(8090);
    }

    public int getCardanoNodePort() {
        return this.getMappedPort(3001);
    }

    public String getYaciStoreApiUrl() {
        int port = this.getYaciStorePort();
        return "http://localhost:" + port + "/api/v1/";
    }

    public String getLocalClusterApiUrl() {
        int port = this.getLocalClusterPort();
        return "http://localhost:" + port + "/local-cluster/api/";
    }

    public String getOgmiosHttpUrl() {
        int port = this.getOgmiosPort();
        return "http://localhost:" + port + "/";
    }

    public String getOgmiosWsUrl() {
        int port = this.getOgmiosPort();
        return "ws://localhost:" + port + "/";
    }

    public String getKupoUrl() {
        int port = this.getKupoPort();
        return "http://localhost:" + port + "/";
    }

    public UtxoSupplier getUtxoSupplier() {
        return new DefaultUtxoSupplier(this.getUtxoService());
    }

    public ProtocolParamsSupplier getProtocolParamsSupplier() {
        return new DefaultProtocolParamsSupplier(this.getEpochService());
    }

    public TransactionProcessor getTransactionProcessor() {
        TransactionService transactionService = this.getTransactionService();
        return new DefaultTransactionProcessor(transactionService);
    }

    @NotNull
    public EpochService getEpochService() {
        switch (this.apiMode) {
            case YACI_STORE: {
                return new BFEpochService(this.getYaciStoreApiUrl(), "dummy key");
            }
            case OGMIOS: {
                return new OgmiosEpochService(this.getOgmiosHttpUrl());
            }
        }
        throw new IllegalArgumentException("Invalid ApiMode : " + this.apiMode);
    }

    @NotNull
    public UtxoService getUtxoService() {
        switch (this.apiMode) {
            case YACI_STORE: {
                return new BFUtxoService(this.getYaciStoreApiUrl(), "dummy key");
            }
            case OGMIOS: {
                return new KupoUtxoService(this.getKupoUrl());
            }
        }
        throw new IllegalArgumentException("Invalid ApiMode : " + this.apiMode);
    }

    @NotNull
    public TransactionService getTransactionService() {
        switch (this.apiMode) {
            case YACI_STORE: {
                return new BFTransactionService(this.getYaciStoreApiUrl(), "dummy key");
            }
            case OGMIOS: {
                return new TestOgmiosTransactionService(this.getOgmiosHttpUrl(), this.getKupoUrl());
            }
        }
        throw new IllegalArgumentException("Invalid ApiMode : " + this.apiMode);
    }

    @NotNull
    public BackendService getBackendService() {
        switch (this.apiMode) {
            case YACI_STORE: {
                return new BFBackendService(this.getYaciStoreApiUrl(), "dummy key");
            }
            case OGMIOS: {
                return new KupmiosBackendService(this.getOgmiosHttpUrl(), this.getKupoUrl());
            }
        }
        throw new IllegalArgumentException("Invalid ApiMode : " + this.apiMode);
    }

    public YaciTestHelper getTestHelper() {
        if (this.testHelper == null) {
            this.testHelper = new YaciTestHelper(this);
        }
        return this.testHelper;
    }

    public void stop() {
        super.stop();
    }
}

