/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.test.api;

import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.yaci.test.YaciCardanoContainer;
import com.bloxbean.cardano.yaci.test.api.UtxoListAssert;
import com.bloxbean.cardano.yaci.test.api.helper.YaciTestHelper;
import java.math.BigInteger;
import java.util.List;
import lombok.NonNull;
import org.assertj.core.api.AbstractAssert;
import org.jetbrains.annotations.NotNull;

public class CardanoContainerAssert
extends AbstractAssert<CardanoContainerAssert, YaciCardanoContainer> {
    private YaciTestHelper testHelper;

    protected CardanoContainerAssert(YaciCardanoContainer yaciCardanoContainer) {
        super((Object)yaciCardanoContainer, CardanoContainerAssert.class);
        this.testHelper = ((YaciCardanoContainer)((Object)this.actual)).getTestHelper();
    }

    public CardanoContainerAssert hasLovelaceBalance(@NonNull String address, @NotNull long expectedBalance) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return this.hasLovelaceBalance(address, BigInteger.valueOf(expectedBalance));
    }

    public CardanoContainerAssert hasLovelaceBalance(@NonNull String address, @NotNull BigInteger expectedBalance) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.isNotNull();
        BigInteger actualBalance = this.testHelper.lovelaceBalance(address).orElse(BigInteger.ZERO);
        if (!expectedBalance.equals(actualBalance)) {
            this.failWithMessage("Expected lovelace balance to be <%s> but was <%s>", new Object[]{expectedBalance, actualBalance});
        }
        return this;
    }

    public CardanoContainerAssert hasAssetBalance(@NonNull String address, @NonNull String policy, @NotNull String asssetName, @NotNull long expectedBalance) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return this.hasAssetBalance(address, policy, asssetName, BigInteger.valueOf(expectedBalance));
    }

    public CardanoContainerAssert hasAssetBalance(@NonNull String address, @NonNull String policy, @NotNull String asssetName, @NotNull BigInteger expectedBalance) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        this.isNotNull();
        BigInteger actualBalance = this.testHelper.assetBalance(address, AssetUtil.getUnit((String)policy, (Asset)new Asset(asssetName, BigInteger.ZERO))).orElse(BigInteger.ZERO);
        if (!expectedBalance.equals(actualBalance)) {
            this.failWithMessage("Expected asset balance to be <%s> but was <%s>", new Object[]{expectedBalance, actualBalance});
        }
        return this;
    }

    public UtxoListAssert utxos(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.isNotNull();
        List<Utxo> utxoList = this.testHelper.utxos(address);
        return new UtxoListAssert(utxoList);
    }
}

