/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.test.api;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.impl.DefaultPlutusObjectConverter;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.test.api.helper.YaciTestHelper;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.assertj.core.api.ListAssert;
import org.jetbrains.annotations.NotNull;

public class UtxoListAssert
extends ListAssert<Utxo> {
    protected UtxoListAssert(List<Utxo> utxos) {
        super(utxos);
    }

    public static UtxoListAssert of(List<Utxo> utxos) {
        return new UtxoListAssert(utxos);
    }

    public static UtxoListAssert of(Utxo utxo) {
        return new UtxoListAssert(Collections.singletonList(utxo));
    }

    public UtxoListAssert containsMultiAsset(@NonNull String policyId, @NonNull String assetName) {
        if (policyId == null) {
            throw new NullPointerException("policyId is marked non-null but is null");
        }
        if (assetName == null) {
            throw new NullPointerException("assetName is marked non-null but is null");
        }
        List<Object> amounts = YaciTestHelper.amounts((List)this.actual);
        if (amounts == null) {
            amounts = Collections.emptyList();
        }
        String unit = AssetUtil.getUnit((String)policyId, (Asset)new Asset(assetName, BigInteger.ZERO));
        String units = amounts.stream().map(amount -> amount.getUnit()).collect(Collectors.joining("\n,"));
        if (amounts.size() == 0 || !amounts.stream().anyMatch(amount -> amount.getUnit().equals(unit))) {
            this.failWithMessage("Expected asset with policy : policy: <%s>, asset: <%s>. \nBut not found. \nunits: <%s>", new Object[]{policyId, assetName, units});
        }
        return this;
    }

    public UtxoListAssert hasAssetBalance(@NonNull String policyId, @NonNull String assetName, @NonNull BigInteger expectedBalance) {
        if (policyId == null) {
            throw new NullPointerException("policyId is marked non-null but is null");
        }
        if (assetName == null) {
            throw new NullPointerException("assetName is marked non-null but is null");
        }
        if (expectedBalance == null) {
            throw new NullPointerException("expectedBalance is marked non-null but is null");
        }
        this.isNotNull();
        List<Amount> amounts = YaciTestHelper.amounts((List)this.actual);
        String unit = AssetUtil.getUnit((String)policyId, (Asset)new Asset(assetName, BigInteger.ZERO));
        BigInteger actual = UtxoListAssert.getAssetBalance(amounts, unit);
        if (!expectedBalance.equals(actual)) {
            this.failWithMessage("Expected asset balance to be <%s> but was <%s>", new Object[]{expectedBalance, actual});
        }
        return this;
    }

    public UtxoListAssert hasAssetBalance(@NonNull String policyId, @NonNull String assetName, @NonNull Predicate<BigInteger> predicate) {
        if (policyId == null) {
            throw new NullPointerException("policyId is marked non-null but is null");
        }
        if (assetName == null) {
            throw new NullPointerException("assetName is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        this.isNotNull();
        List<Amount> amounts = YaciTestHelper.amounts((List)this.actual);
        String unit = AssetUtil.getUnit((String)policyId, (Asset)new Asset(assetName, BigInteger.ZERO));
        BigInteger actualBalance = UtxoListAssert.getAssetBalance(amounts, unit);
        if (!predicate.test(actualBalance)) {
            this.failWithMessage("Failed predicate. Actual balance <%s>", new Object[]{actualBalance});
        }
        return this;
    }

    public UtxoListAssert hasLovelaceBalance(@NonNull BigInteger expectedBalance) {
        if (expectedBalance == null) {
            throw new NullPointerException("expectedBalance is marked non-null but is null");
        }
        List<Amount> amounts = YaciTestHelper.amounts((List)this.actual);
        BigInteger actualBalance = UtxoListAssert.getAssetBalance(amounts, "lovelace");
        if (!expectedBalance.equals(actualBalance)) {
            this.failWithMessage("Expected lovelace balance to be <%s> but was <%s>", new Object[]{expectedBalance, actualBalance});
        }
        return this;
    }

    public UtxoListAssert hasLovelaceBalance(@NonNull Predicate<BigInteger> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        List<Amount> amounts = YaciTestHelper.amounts((List)this.actual);
        BigInteger actualBalance = UtxoListAssert.getAssetBalance(amounts, "lovelace");
        if (!predicate.test(actualBalance)) {
            this.failWithMessage("Failed predicate. Actual balance <%s>", new Object[]{actualBalance});
        }
        return this;
    }

    @NotNull
    private static BigInteger getAssetBalance(List<Amount> amounts, String unit) {
        BigInteger actual = amounts.stream().filter(amount -> amount.getUnit().equals(unit)).findFirst().map(amount -> amount.getQuantity()).orElse(BigInteger.ZERO);
        return actual;
    }

    public UtxoListAssert containsInlineDatum(@NonNull Object datumObj) {
        if (datumObj == null) {
            throw new NullPointerException("datumObj is marked non-null but is null");
        }
        this.isNotNull();
        String datumCborHex = new DefaultPlutusObjectConverter().toPlutusData(datumObj).serializeToHex();
        boolean found = ((List)this.actual).stream().anyMatch(utxo -> datumCborHex.equals(utxo.getInlineDatum()));
        if (!found) {
            this.failWithMessage("Expected but not found.\n InlineDatum : <%s>", new Object[]{datumCborHex});
        }
        return this;
    }

    public UtxoListAssert containsDatumHash(@NonNull String datumHash) {
        if (datumHash == null) {
            throw new NullPointerException("datumHash is marked non-null but is null");
        }
        this.isNotNull();
        boolean found = ((List)this.actual).stream().anyMatch(utxo -> datumHash.equals(utxo.getDataHash()));
        if (!found) {
            this.failWithMessage("Expected but not found.\n Datum Hash : <%s>", new Object[]{datumHash});
        }
        return this;
    }

    public UtxoListAssert containsReferenceScript(@NonNull PlutusScript plutusScript) {
        if (plutusScript == null) {
            throw new NullPointerException("plutusScript is marked non-null but is null");
        }
        this.isNotNull();
        try {
            String scriptRefHex = HexUtil.encodeHexString((byte[])plutusScript.getScriptHash());
            boolean found = ((List)this.actual).stream().anyMatch(utxo -> scriptRefHex.equals(utxo.getReferenceScriptHash()));
            if (!found) {
                this.failWithMessage("Expected but not found.\n ReferenceScript : <%s>", new Object[]{scriptRefHex});
            }
            return this;
        }
        catch (CborSerializationException e) {
            throw new RuntimeException(e);
        }
    }
}

