/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.test.api.helper;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressProvider;
import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.api.util.PolicyUtil;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.common.ADAConversionUtil;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.crypto.VerificationKey;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.function.Output;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.helper.BalanceTxBuilders;
import com.bloxbean.cardano.client.function.helper.InputBuilders;
import com.bloxbean.cardano.client.function.helper.MintCreators;
import com.bloxbean.cardano.client.function.helper.OutputBuilders;
import com.bloxbean.cardano.client.function.helper.SignerProviders;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Policy;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.bloxbean.cardano.yaci.test.YaciCardanoContainer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionHelper {
    private static final Logger log = LoggerFactory.getLogger(TransactionHelper.class);
    private final YaciCardanoContainer yaciCardanoContainer;
    private String sk = "58208b7dae4189261f1c8b4fcf2fd54f9e11bda7f8e00bc85cb864094409ace43daf";
    private SecretKey faucetSecretKey;
    private String faucetAddress;

    public TransactionHelper(YaciCardanoContainer yaciCardanoContainer) {
        this.yaciCardanoContainer = yaciCardanoContainer;
        this.faucetSecretKey = new SecretKey(this.sk);
        this.faucetAddress = this.getAddress(this.faucetSecretKey);
    }

    public String getFaucetAddress() {
        return this.faucetAddress;
    }

    public Optional<String> transferAda(String address, double ada) {
        return this.transferAda(address, BigDecimal.valueOf(ada));
    }

    public Optional<String> transferAda(String address, BigDecimal ada) {
        Output output = Output.builder().address(address).assetName("lovelace").qty(ADAConversionUtil.adaToLovelace((BigDecimal)ada)).build();
        TxBuilder txBuilder = output.outputBuilder().buildInputs(InputBuilders.createFromSender((String)this.faucetAddress, (String)this.faucetAddress)).andThen(BalanceTxBuilders.balanceTx((String)this.faucetAddress));
        Transaction transaction = TxBuilderContext.init((UtxoSupplier)this.yaciCardanoContainer.getUtxoSupplier(), (ProtocolParamsSupplier)this.yaciCardanoContainer.getProtocolParamsSupplier()).buildAndSign(txBuilder, SignerProviders.signerFrom((SecretKey[])new SecretKey[]{this.faucetSecretKey}));
        return this.submitTx(transaction);
    }

    public Optional<Policy> mintToken(String tokenName, long amount) {
        return this.mintToken(this.getFaucetAddress(), tokenName, BigInteger.valueOf(amount));
    }

    public Optional<Policy> mintToken(String receiver, String tokenName, long amount) {
        return this.mintToken(receiver, tokenName, BigInteger.valueOf(amount));
    }

    public Optional<Policy> mintToken(String receiver, String tokenName, BigInteger amount) {
        try {
            Policy policy = PolicyUtil.createMultiSigScriptAllPolicy((String)"TestPolicy", (int)1);
            MultiAsset multiAsset = MultiAsset.builder().policyId(policy.getPolicyId()).assets(Arrays.asList(new Asset(tokenName, amount))).build();
            Output output = Output.builder().address(receiver).policyId(policy.getPolicyId()).assetName(tokenName).qty(amount).build();
            TxBuilder txBuilder = output.mintOutputBuilder().buildInputs(InputBuilders.createFromSender((String)this.faucetAddress, (String)this.faucetAddress)).andThen(MintCreators.mintCreator((Script)policy.getPolicyScript(), (MultiAsset)multiAsset)).andThen(BalanceTxBuilders.balanceTxWithAdditionalSigners((String)this.faucetAddress, (int)1));
            Transaction transaction = TxBuilderContext.init((UtxoSupplier)this.yaciCardanoContainer.getUtxoSupplier(), (ProtocolParamsSupplier)this.yaciCardanoContainer.getProtocolParamsSupplier()).buildAndSign(txBuilder, SignerProviders.signerFrom((SecretKey[])new SecretKey[]{this.faucetSecretKey}).andThen(SignerProviders.signerFrom((SecretKey[])new SecretKey[]{(SecretKey)policy.getPolicyKeys().get(0)})));
            this.submitTx(transaction);
            return Optional.of(policy);
        }
        catch (Exception e) {
            log.error("Error while minting token", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<String> lockFund(@NonNull Account senderAccount, @NonNull PlutusScript receiverScript, @NonNull Value value, PlutusData inlineDatum) {
        if (senderAccount == null) {
            throw new NullPointerException("senderAccount is marked non-null but is null");
        }
        if (receiverScript == null) {
            throw new NullPointerException("receiverScript is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String scriptAddress = AddressProvider.getEntAddress((Script)receiverScript, (Network)Networks.testnet()).toBech32();
        return this.lockFund(senderAccount, scriptAddress, value, inlineDatum);
    }

    public Optional<String> lockFund(@NonNull Account senderAccount, @NonNull PlutusScript receiverScript, @NonNull List<Amount> amounts, PlutusData inlineDatum) {
        if (senderAccount == null) {
            throw new NullPointerException("senderAccount is marked non-null but is null");
        }
        if (receiverScript == null) {
            throw new NullPointerException("receiverScript is marked non-null but is null");
        }
        if (amounts == null) {
            throw new NullPointerException("amounts is marked non-null but is null");
        }
        String scriptAddress = AddressProvider.getEntAddress((Script)receiverScript, (Network)Networks.testnet()).toBech32();
        return this.lockFund(senderAccount, scriptAddress, amounts, inlineDatum);
    }

    public Optional<String> lockFund(@NonNull Account senderAccount, @NonNull String receiverScriptAddress, @NonNull List<Amount> amounts, PlutusData inlineDatum) {
        if (senderAccount == null) {
            throw new NullPointerException("senderAccount is marked non-null but is null");
        }
        if (receiverScriptAddress == null) {
            throw new NullPointerException("receiverScriptAddress is marked non-null but is null");
        }
        if (amounts == null) {
            throw new NullPointerException("amounts is marked non-null but is null");
        }
        Value value = TransactionHelper.getValue(amounts);
        return this.lockFund(senderAccount, receiverScriptAddress, value, inlineDatum);
    }

    public Optional<String> lockFund(@NonNull Account senderAccount, @NonNull String receiverScript, @NonNull Value value, PlutusData inlineDatum) {
        if (senderAccount == null) {
            throw new NullPointerException("senderAccount is marked non-null but is null");
        }
        if (receiverScript == null) {
            throw new NullPointerException("receiverScript is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String senderAddress = senderAccount.baseAddress();
        TransactionOutput txOutput = TransactionOutput.builder().address(receiverScript).value(value).inlineDatum(inlineDatum).build();
        TxBuilder txBuilder = OutputBuilders.createFromOutput((TransactionOutput)txOutput).buildInputs(InputBuilders.createFromSender((String)senderAddress, (String)senderAddress)).andThen(BalanceTxBuilders.balanceTx((String)senderAddress, (int)1));
        Transaction transaction = TxBuilderContext.init((UtxoSupplier)this.yaciCardanoContainer.getUtxoSupplier(), (ProtocolParamsSupplier)this.yaciCardanoContainer.getProtocolParamsSupplier()).buildAndSign(txBuilder, SignerProviders.signerFrom((Account[])new Account[]{senderAccount}));
        return this.submitTx(transaction);
    }

    public Optional<String> lockFund(@NonNull PlutusScript receiverScript, @NonNull Value value, PlutusData inlineDatum) {
        if (receiverScript == null) {
            throw new NullPointerException("receiverScript is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String scriptAddress = AddressProvider.getEntAddress((Script)receiverScript, (Network)Networks.testnet()).toBech32();
        return this.lockFund(scriptAddress, value, inlineDatum);
    }

    public Optional<String> lockFund(@NonNull PlutusScript receiverScript, @NonNull List<Amount> amounts, PlutusData inlineDatum) {
        if (receiverScript == null) {
            throw new NullPointerException("receiverScript is marked non-null but is null");
        }
        if (amounts == null) {
            throw new NullPointerException("amounts is marked non-null but is null");
        }
        String scriptAddress = AddressProvider.getEntAddress((Script)receiverScript, (Network)Networks.testnet()).toBech32();
        return this.lockFund(scriptAddress, amounts, inlineDatum);
    }

    public Optional<String> lockFund(@NonNull String receiverScriptAddress, @NonNull List<Amount> amounts, PlutusData inlineDatum) {
        if (receiverScriptAddress == null) {
            throw new NullPointerException("receiverScriptAddress is marked non-null but is null");
        }
        if (amounts == null) {
            throw new NullPointerException("amounts is marked non-null but is null");
        }
        Value value = TransactionHelper.getValue(amounts);
        return this.lockFund(receiverScriptAddress, value, inlineDatum);
    }

    public Optional<String> lockFund(@NonNull String receiverScript, @NonNull Value value, PlutusData inlineDatum) {
        if (receiverScript == null) {
            throw new NullPointerException("receiverScript is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        TransactionOutput txOutput = TransactionOutput.builder().address(receiverScript).value(value).inlineDatum(inlineDatum).build();
        TxBuilder txBuilder = OutputBuilders.createFromOutput((TransactionOutput)txOutput).buildInputs(InputBuilders.createFromSender((String)this.faucetAddress, (String)this.faucetAddress)).andThen(BalanceTxBuilders.balanceTx((String)this.faucetAddress, (int)1));
        Transaction transaction = TxBuilderContext.init((UtxoSupplier)this.yaciCardanoContainer.getUtxoSupplier(), (ProtocolParamsSupplier)this.yaciCardanoContainer.getProtocolParamsSupplier()).buildAndSign(txBuilder, SignerProviders.signerFrom((SecretKey[])new SecretKey[]{this.faucetSecretKey}));
        return this.submitTx(transaction);
    }

    public Optional<Utxo> createReferenceScriptTx(PlutusScript referenceScript, double ada) {
        Account account = new Account(Networks.testnet());
        String receiverAddress = account.baseAddress();
        Output output = Output.builder().address(receiverAddress).assetName("lovelace").qty(ADAConversionUtil.adaToLovelace((double)ada)).scriptRef((Script)referenceScript).build();
        TxBuilder txBuilder = output.outputBuilder().buildInputs(InputBuilders.createFromSender((String)this.faucetAddress, (String)this.faucetAddress)).andThen(BalanceTxBuilders.balanceTx((String)this.faucetAddress));
        Transaction transaction = TxBuilderContext.init((UtxoSupplier)this.yaciCardanoContainer.getUtxoSupplier(), (ProtocolParamsSupplier)this.yaciCardanoContainer.getProtocolParamsSupplier()).buildAndSign(txBuilder, SignerProviders.signerFrom((SecretKey[])new SecretKey[]{this.faucetSecretKey}));
        Optional<String> txHash = this.submitTx(transaction);
        if (txHash.isPresent()) {
            return this.yaciCardanoContainer.getUtxoSupplier().getAll(receiverAddress).stream().filter(utxo -> utxo.getTxHash().equals(txHash.get()) && utxo.getOutputIndex() == 0).findFirst();
        }
        return Optional.empty();
    }

    @NotNull
    private static Value getValue(@NotNull List<Amount> amounts) {
        Value value = new Value();
        List multiAssets = new ArrayList();
        for (Amount amount : amounts) {
            if ("lovelace".equals(amount.getUnit())) {
                value.setCoin(amount.getQuantity());
                continue;
            }
            MultiAsset multiAsset = AssetUtil.getMultiAssetFromUnitAndAmount((String)amount.getUnit(), (BigInteger)amount.getQuantity());
            multiAssets = MultiAsset.mergeMultiAssetLists(multiAssets, Arrays.asList(multiAsset));
        }
        value.setMultiAssets(multiAssets);
        return value;
    }

    @NotNull
    public Optional<String> submitTx(Transaction transaction) {
        Result result;
        try {
            result = this.yaciCardanoContainer.getTransactionService().submitTransaction(transaction.serialize());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (result.isSuccessful()) {
            log.info("Transaction submitted successfully");
            this.waitForTransactionHash((Result<String>)result);
            log.info("Transaction hash: " + (String)result.getValue());
            return Optional.of((String)result.getValue());
        }
        log.info("Transaction submission failed");
        return Optional.empty();
    }

    public void waitForTransactionHash(Result<String> result) {
        block4: {
            try {
                if (!result.isSuccessful()) break block4;
                for (int count = 0; count < 5; ++count) {
                    Result txnResult = this.yaciCardanoContainer.getTransactionService().getTransaction((String)result.getValue());
                    if (txnResult.isSuccessful()) {
                        System.out.println(JsonUtil.getPrettyJson((String)((TransactionContent)txnResult.getValue()).getHash()));
                        break;
                    }
                    System.out.println("Waiting for transaction to be processed ....");
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getAddress(SecretKey secretKey) {
        try {
            VerificationKey vk = KeyGenUtil.getPublicKeyFromPrivateKey((SecretKey)secretKey);
            HdPublicKey hdPublicKey = new HdPublicKey();
            hdPublicKey.setKeyData(vk.getBytes());
            Address address = AddressProvider.getEntAddress((HdPublicKey)hdPublicKey, (Network)Networks.testnet());
            return address.toBech32();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while getting address from secret key", e);
        }
    }
}

