/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.test.api.helper;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.test.YaciCardanoContainer;
import com.bloxbean.cardano.yaci.test.api.helper.TransactionHelper;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class YaciTestHelper
extends TransactionHelper {
    private YaciCardanoContainer container;

    public YaciTestHelper(YaciCardanoContainer yaciCardanoContainer) {
        super(yaciCardanoContainer);
        this.container = yaciCardanoContainer;
    }

    public List<Utxo> utxos(String address) {
        UtxoSupplier utxoSupplier = this.container.getUtxoSupplier();
        List utxoList = utxoSupplier.getAll(address);
        if (utxoList == null) {
            return Collections.EMPTY_LIST;
        }
        return utxoList;
    }

    public List<Amount> amounts(String address) {
        return YaciTestHelper.amounts(this.utxos(address));
    }

    public Optional<BigInteger> lovelaceBalance(String address) {
        return this.assetBalance(address, "lovelace");
    }

    public Optional<BigInteger> assetBalance(String address, String unit) {
        List<Amount> amounts = this.amounts(address);
        return YaciTestHelper.assetBalance(unit, amounts);
    }

    public List<PlutusData> inlineDatums(String address) {
        return YaciTestHelper.inlineDatums(this.utxos(address));
    }

    public List<String> referenceScriptHashes(String address) {
        return YaciTestHelper.referenceScriptHashes(this.utxos(address));
    }

    public static List<Amount> amounts(@NonNull List<Utxo> utxoList) {
        if (utxoList == null) {
            throw new NullPointerException("utxoList is marked non-null but is null");
        }
        Map<String, List<Amount>> amountMap = utxoList.stream().flatMap(utxo -> utxo.getAmount().stream()).collect(Collectors.groupingBy(Amount::getUnit));
        return amountMap.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(amount -> amount.getQuantity()).collect(Collectors.reducing((b1, b2) -> b1.add((BigInteger)b2))).map(quantity -> new Amount((String)entry.getKey(), quantity))).map(amountOptional -> amountOptional.orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Optional<BigInteger> assetBalance(String unit, List<Amount> amounts) {
        return amounts.stream().filter(amount -> unit.equals(amount.getUnit())).findFirst().map(amount -> amount.getQuantity());
    }

    public static List<PlutusData> inlineDatums(@NonNull List<Utxo> utxos) {
        if (utxos == null) {
            throw new NullPointerException("utxos is marked non-null but is null");
        }
        return utxos.stream().filter(utxo -> utxo.getInlineDatum() != null).map(utxo -> utxo.getInlineDatum()).map(datum -> {
            try {
                return PlutusData.deserialize((byte[])HexUtil.decodeHexString((String)datum));
            }
            catch (CborDeserializationException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<String> datumHashes(String address) {
        return YaciTestHelper.datumHashes(this.utxos(address));
    }

    public static List<String> datumHashes(@NonNull List<Utxo> utxos) {
        if (utxos == null) {
            throw new NullPointerException("utxos is marked non-null but is null");
        }
        return utxos.stream().filter(utxo -> utxo.getDataHash() != null).map(utxo -> utxo.getDataHash()).collect(Collectors.toList());
    }

    public static List<String> referenceScriptHashes(@NonNull List<Utxo> utxos) {
        if (utxos == null) {
            throw new NullPointerException("utxos is marked non-null but is null");
        }
        return utxos.stream().filter(utxo -> utxo.getReferenceScriptHash() != null).map(utxo -> utxo.getReferenceScriptHash()).collect(Collectors.toList());
    }
}

