/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.test.backend.ogmios;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.backend.ogmios.http.OgmiosTransactionService;
import com.bloxbean.cardano.yaci.test.backend.ogmios.KupoTxn;
import com.bloxbean.cardano.yaci.test.backend.ogmios.http.MatchesApi;
import feign.Feign;
import feign.codec.Decoder;
import feign.jackson.JacksonDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOgmiosTransactionService
extends OgmiosTransactionService {
    private static final Logger log = LoggerFactory.getLogger(TestOgmiosTransactionService.class);
    private MatchesApi kupoMatchApi;

    public TestOgmiosTransactionService(String ogmiosUrl, String kupoUrl) {
        super(ogmiosUrl);
        this.kupoMatchApi = (MatchesApi)this.getFeign().target(MatchesApi.class, kupoUrl);
    }

    public Result<TransactionContent> getTransaction(String txnHash) throws ApiException {
        log.debug("Getting transaction from Kupo : " + txnHash);
        List<KupoTxn> kupoTxnList = this.kupoMatchApi.getTransaction(txnHash);
        log.trace("Kupo Txn : " + kupoTxnList);
        if (kupoTxnList == null || kupoTxnList.isEmpty()) {
            return Result.error((String)"Transaction not found in Kupo");
        }
        TransactionContent transactionContent = TransactionContent.builder().index(Integer.valueOf(kupoTxnList.get(0).getTransactionIndex())).hash(kupoTxnList.get(0).getTransactionId()).build();
        return Result.success((String)"Transaction found in Kupo").withValue((Object)transactionContent).code(200);
    }

    protected Feign.Builder getFeign() {
        return Feign.builder().decoder((Decoder)new JacksonDecoder());
    }
}

