/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.network.NodeClient;
import com.bloxbean.cardano.yaci.core.network.UnixSocketNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Tip;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2c.LocalChainSyncAgent;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2c.LocalChainSyncAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.Reason;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.handshake.util.N2CVersionTableConstant;
import com.bloxbean.cardano.yaci.helper.api.ReactiveFetcher;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class LocalTipFinder
extends ReactiveFetcher<Tip> {
    private static final Logger log = LoggerFactory.getLogger(LocalTipFinder.class);
    private String nodeSocketFile;
    private final Point wellKnownPoint;
    private HandshakeAgent handshakeAgent;
    private LocalChainSyncAgent chainSyncAgent;
    private NodeClient nodeClient;
    private VersionTable versionTable;
    private String tipRequest = "TIP_REQUEST";

    public LocalTipFinder(String nodeSocketFile, Point wellKnownPoint, long protocolMagic) {
        this(nodeSocketFile, wellKnownPoint, N2CVersionTableConstant.v1AndAbove((long)protocolMagic));
    }

    public LocalTipFinder(String nodeSocketFile, Point wellKnownPoint, VersionTable versionTable) {
        this.nodeSocketFile = nodeSocketFile;
        this.wellKnownPoint = wellKnownPoint;
        this.versionTable = versionTable;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.chainSyncAgent = new LocalChainSyncAgent(new Point[]{this.wellKnownPoint});
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                if (log.isDebugEnabled()) {
                    log.debug("Handshake ok");
                }
                LocalTipFinder.this.chainSyncAgent.sendNextMessage();
            }

            public void handshakeError(Reason reason) {
                log.error("Handshake Error : {}", (Object)reason);
            }
        });
        this.nodeClient = new UnixSocketNodeClient(this.nodeSocketFile, this.handshakeAgent, new Agent[]{this.chainSyncAgent});
    }

    @Override
    public void start(final Consumer<Tip> consumer) {
        this.chainSyncAgent.addListener((AgentListener)new LocalChainSyncAgentListener(){

            public void intersactFound(Tip tip, Point point) {
                if (consumer != null) {
                    consumer.accept(tip);
                }
            }
        });
        if (this.nodeClient != null) {
            this.nodeClient.start();
        }
    }

    public void next() {
        this.chainSyncAgent.reset(this.wellKnownPoint);
        this.chainSyncAgent.sendNextMessage();
    }

    public Mono<Tip> find() {
        this.chainSyncAgent.addListener((AgentListener)new LocalChainSyncAgentListener(){

            public void intersactFound(Tip tip, Point point) {
                LocalTipFinder.this.applyMonoSuccess(LocalTipFinder.this.tipRequest, tip);
            }
        });
        return Mono.create(tipMonoSink -> {
            if (log.isDebugEnabled()) {
                log.debug("Try to find tip");
            }
            this.storeMonoSinkReference(this.tipRequest, (MonoSink)tipMonoSink);
            if (!this.nodeClient.isRunning()) {
                this.nodeClient.start();
            } else {
                this.next();
            }
        });
    }

    @Override
    public void shutdown() {
        if (this.nodeClient != null) {
            this.nodeClient.shutdown();
        }
    }

    @Override
    public boolean isRunning() {
        return this.nodeClient.isRunning();
    }
}

