/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.network.TCPNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.txsubmission.TxSubmissionAgent;
import com.bloxbean.cardano.yaci.helper.api.Fetcher;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxSubmissionClient
implements Fetcher {
    private static final Logger log = LoggerFactory.getLogger(TxSubmissionClient.class);
    private String host;
    private int port;
    private VersionTable versionTable;
    private HandshakeAgent handshakeAgent;
    private TxSubmissionAgent txSubmissionAgent;
    private TCPNodeClient n2nClient;

    public TxSubmissionClient(String host, int port, VersionTable versionTable) {
        this.host = host;
        this.port = port;
        this.versionTable = versionTable;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.txSubmissionAgent = new TxSubmissionAgent();
        this.n2nClient = new TCPNodeClient(this.host, this.port, this.handshakeAgent, new Agent[]{this.txSubmissionAgent});
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                TxSubmissionClient.this.txSubmissionAgent.sendNextMessage();
            }
        });
    }

    public void start(Consumer consumer) {
        this.n2nClient.start();
        this.txSubmissionAgent.sendNextMessage();
    }

    @Override
    public void shutdown() {
        this.n2nClient.shutdown();
    }

    @Override
    public boolean isRunning() {
        return this.n2nClient.isRunning();
    }
}

