/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.helper.BlockFetcher;
import com.bloxbean.cardano.yaci.helper.listener.BlockChainDataListener;
import com.bloxbean.cardano.yaci.helper.listener.BlockFetchAgentListenerAdapter;

public class BlockRangeSync {
    private String host;
    private int port;
    private long protocolMagic;
    private BlockFetcher blockFetcher;

    public BlockRangeSync(String host, int port, long protocolMagic) {
        this.host = host;
        this.port = port;
        this.protocolMagic = protocolMagic;
    }

    public void start(BlockChainDataListener blockChainDataListener) {
        this.blockFetcher = new BlockFetcher(this.host, this.port, this.protocolMagic);
        BlockFetchAgentListenerAdapter blockfetchAgentListener = new BlockFetchAgentListenerAdapter(blockChainDataListener);
        this.blockFetcher.addBlockFetchListener(blockfetchAgentListener);
        this.blockFetcher.start();
    }

    public void restart(BlockChainDataListener blockChainDataListener) {
        if (this.blockFetcher != null && this.blockFetcher.isRunning()) {
            this.blockFetcher.shutdown();
        }
        this.start(blockChainDataListener);
    }

    public void fetch(Point from, Point to) {
        if (this.blockFetcher == null) {
            throw new IllegalStateException("Please call start before fetch");
        }
        this.blockFetcher.fetch(from, to);
    }

    public void stop() {
        this.blockFetcher.shutdown();
    }
}

