/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.helper.N2NChainSyncFetcher;
import com.bloxbean.cardano.yaci.helper.listener.BlockChainDataListener;
import com.bloxbean.cardano.yaci.helper.listener.BlockFetchAgentListenerAdapter;
import com.bloxbean.cardano.yaci.helper.listener.ChainSyncListenerAdapter;

public class BlockSync {
    private String host;
    private int port;
    private long protocolMagic;
    private Point wellKnownPoint;
    private N2NChainSyncFetcher n2NChainSyncFetcher;

    public BlockSync(String host, int port, long protocolMagic, Point wellKnownPoint) {
        this.host = host;
        this.port = port;
        this.protocolMagic = protocolMagic;
        this.wellKnownPoint = wellKnownPoint;
    }

    public void startSync(Point point, BlockChainDataListener blockChainDataListener) {
        if (this.n2NChainSyncFetcher != null && this.n2NChainSyncFetcher.isRunning()) {
            this.n2NChainSyncFetcher.shutdown();
        }
        this.initializeAgentAndStart(point, blockChainDataListener, false);
    }

    private void initializeAgentAndStart(Point point, BlockChainDataListener blockChainDataListener, boolean syncFromTip) {
        this.n2NChainSyncFetcher = new N2NChainSyncFetcher(this.host, this.port, point, this.protocolMagic, syncFromTip);
        BlockFetchAgentListenerAdapter blockfetchAgentListener = new BlockFetchAgentListenerAdapter(blockChainDataListener);
        ChainSyncListenerAdapter chainSyncAgentListener = new ChainSyncListenerAdapter(blockChainDataListener);
        this.n2NChainSyncFetcher.addChainSyncListener(chainSyncAgentListener);
        this.n2NChainSyncFetcher.addBlockFetchListener(blockfetchAgentListener);
        this.n2NChainSyncFetcher.start();
    }

    public void startSyncFromTip(BlockChainDataListener blockChainDataListener) {
        if (this.n2NChainSyncFetcher != null && this.n2NChainSyncFetcher.isRunning()) {
            this.n2NChainSyncFetcher.shutdown();
        }
        this.initializeAgentAndStart(this.wellKnownPoint, blockChainDataListener, true);
    }

    public void stop() {
        this.n2NChainSyncFetcher.shutdown();
    }
}

