/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.core.protocol.localstate.LocalStateQueryAgent;
import com.bloxbean.cardano.yaci.core.protocol.localstate.LocalStateQueryListener;
import com.bloxbean.cardano.yaci.core.protocol.localstate.LocalStateQueryState;
import com.bloxbean.cardano.yaci.core.protocol.localstate.api.Query;
import com.bloxbean.cardano.yaci.core.protocol.localstate.api.QueryResult;
import com.bloxbean.cardano.yaci.core.protocol.localstate.messages.MsgAcquire;
import com.bloxbean.cardano.yaci.core.protocol.localstate.messages.MsgFailure;
import com.bloxbean.cardano.yaci.core.protocol.localstate.messages.MsgReAcquire;
import com.bloxbean.cardano.yaci.core.protocol.localstate.messages.MsgRelease;
import com.bloxbean.cardano.yaci.helper.api.QueryClient;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class LocalStateQueryClient
extends QueryClient {
    private static final Logger log = LoggerFactory.getLogger(LocalStateQueryClient.class);
    private LocalStateQueryAgent localStateQueryAgent;

    public LocalStateQueryClient(LocalStateQueryAgent localStateQueryAgent) {
        this.localStateQueryAgent = localStateQueryAgent;
        this.init();
    }

    private void init() {
        this.localStateQueryAgent.addListener((AgentListener)new LocalStateQueryListener(){

            public void resultReceived(Query query, QueryResult result) {
                LocalStateQueryClient.this.applyMonoSuccess(query, result);
            }

            public void acquired(Point point) {
                MsgReAcquire key = new MsgReAcquire(point);
                if (LocalStateQueryClient.this.hasMonoSink(key)) {
                    LocalStateQueryClient.this.applyMonoSuccess(key, Optional.ofNullable(point));
                } else {
                    LocalStateQueryClient.this.applyMonoSuccess(new MsgAcquire(point), Optional.ofNullable(point));
                }
            }

            public void acquireFailed(MsgFailure.Reason reason) {
                if (log.isDebugEnabled()) {
                    log.error(String.valueOf(reason));
                }
                LocalStateQueryClient.this.applyError(reason);
            }

            public void released() {
                if (log.isDebugEnabled()) {
                    log.debug("Released >>>");
                }
                LocalStateQueryClient.this.applyMonoSuccess(new MsgRelease(), null);
            }

            public void onDisconnect() {
                LocalStateQueryClient.this.applyError("Connection Error !!!");
            }
        });
    }

    public Mono<Void> release() {
        return Mono.create(monoSink -> {
            if (log.isDebugEnabled()) {
                log.debug("Release()");
            }
            MsgRelease msgRelease = this.localStateQueryAgent.release();
            this.localStateQueryAgent.sendNextMessage();
            monoSink.success(null);
        });
    }

    public Mono<Optional<Point>> acquire() {
        return this.acquire(null);
    }

    public Mono<Optional<Point>> acquire(Point point) {
        if (this.localStateQueryAgent.getCurrentState() == LocalStateQueryState.Acquired) {
            log.info("Already in acquired state. Ignoring the acquire call");
            return Mono.just(Optional.empty());
        }
        return Mono.create(monoSink -> {
            if (log.isDebugEnabled()) {
                log.debug("Try to acquire again");
            }
            MsgAcquire msgAcquire = this.localStateQueryAgent.acquire(point);
            this.storeMonoSinkReference(msgAcquire, (MonoSink)monoSink);
            this.localStateQueryAgent.sendNextMessage();
        });
    }

    public Mono<Optional<Point>> reAcquire() {
        return this.reAcquire(null);
    }

    public Mono<Optional<Point>> reAcquire(Point point) {
        return Mono.create(monoSink -> {
            if (log.isDebugEnabled()) {
                log.debug("Try to reAcquire at point : {}", (Object)point);
            }
            MsgReAcquire msgReAcquire = this.localStateQueryAgent.reAcquire(point);
            this.storeMonoSinkReference(msgReAcquire, (MonoSink)monoSink);
            this.localStateQueryAgent.sendNextMessage();
        });
    }

    public <T extends QueryResult> Mono<T> executeQuery(Query query) {
        if (this.localStateQueryAgent.getCurrentState() == LocalStateQueryState.Idle) {
            return Mono.create(monoSink -> this.acquire().doOnNext(point -> {
                this.localStateQueryAgent.query(query);
                this.storeMonoSinkReference(query, (MonoSink)monoSink);
                this.localStateQueryAgent.sendNextMessage();
            }).doOnError(throwable -> monoSink.error(throwable)).subscribe());
        }
        return Mono.create(monoSink -> {
            this.localStateQueryAgent.query(query);
            this.storeMonoSinkReference(query, (MonoSink)monoSink);
            this.localStateQueryAgent.sendNextMessage();
        });
    }
}

