/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.model.Block;
import com.bloxbean.cardano.yaci.core.model.byron.ByronEbBlock;
import com.bloxbean.cardano.yaci.core.model.byron.ByronMainBlock;
import com.bloxbean.cardano.yaci.core.network.NodeClient;
import com.bloxbean.cardano.yaci.core.network.TCPNodeClient;
import com.bloxbean.cardano.yaci.core.network.UnixSocketNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Tip;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2c.LocalChainSyncAgent;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2c.LocalChainSyncAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.handshake.util.N2CVersionTableConstant;
import com.bloxbean.cardano.yaci.helper.api.Fetcher;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class N2CChainSyncFetcher
implements Fetcher<Block> {
    private static final Logger log = LoggerFactory.getLogger(N2CChainSyncFetcher.class);
    private String nodeSocketFile;
    private VersionTable versionTable;
    private Point wellKnownPoint;
    private boolean syncFromLatest;
    private boolean tipFound = false;
    private HandshakeAgent handshakeAgent;
    private LocalChainSyncAgent chainSyncAgent;
    private NodeClient n2CClient;
    private String host;
    private int port;

    public N2CChainSyncFetcher(String nodeSocketFile, Point wellKnownPoint, long protocolMagic) {
        this(nodeSocketFile, wellKnownPoint, N2CVersionTableConstant.v1AndAbove((long)protocolMagic));
    }

    public N2CChainSyncFetcher(String nodeSocketFile, Point wellKnownPoint, long protocolMagic, boolean syncFromLatest) {
        this(nodeSocketFile, wellKnownPoint, N2CVersionTableConstant.v1AndAbove((long)protocolMagic), syncFromLatest);
    }

    public N2CChainSyncFetcher(String nodeSocketFile, Point wellKnownPoint, VersionTable versionTable) {
        this(nodeSocketFile, wellKnownPoint, versionTable, true);
    }

    public N2CChainSyncFetcher(String nodeSocketFile, Point wellKnownPoint, VersionTable versionTable, boolean syncFromLatest) {
        this.nodeSocketFile = nodeSocketFile;
        this.versionTable = versionTable;
        this.wellKnownPoint = wellKnownPoint;
        this.syncFromLatest = syncFromLatest;
        this.init();
    }

    public N2CChainSyncFetcher(String host, int port, Point wellKnownPoint, long protocolMagic) {
        this(host, port, wellKnownPoint, protocolMagic, true);
    }

    public N2CChainSyncFetcher(String host, int port, Point wellKnownPoint, long protocolMagic, boolean syncFromLatest) {
        this(host, port, wellKnownPoint, N2CVersionTableConstant.v1AndAbove((long)protocolMagic), syncFromLatest);
    }

    public N2CChainSyncFetcher(String host, int port, Point wellKnownPoint, VersionTable versionTable) {
        this(host, port, wellKnownPoint, versionTable, true);
    }

    public N2CChainSyncFetcher(String host, int port, Point wellKnownPoint, VersionTable versionTable, boolean syncFromLatest) {
        this.host = host;
        this.port = port;
        this.wellKnownPoint = wellKnownPoint;
        this.versionTable = versionTable;
        this.syncFromLatest = syncFromLatest;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.chainSyncAgent = new LocalChainSyncAgent(new Point[]{this.wellKnownPoint});
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                N2CChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }
        });
        this.chainSyncAgent.addListener((AgentListener)new LocalChainSyncAgentListener(){

            public void intersactFound(Tip tip, Point point) {
                if (log.isDebugEnabled()) {
                    log.debug("Intersect found : Point : {},  Tip: {}", (Object)point, (Object)tip);
                    log.debug("Tip Found: {}", (Object)N2CChainSyncFetcher.this.tipFound);
                }
                if (N2CChainSyncFetcher.this.syncFromLatest) {
                    if (!tip.getPoint().equals((Object)point) && !N2CChainSyncFetcher.this.tipFound) {
                        N2CChainSyncFetcher.this.chainSyncAgent.reset(tip.getPoint());
                        N2CChainSyncFetcher.this.tipFound = true;
                    }
                } else if (!N2CChainSyncFetcher.this.tipFound) {
                    N2CChainSyncFetcher.this.chainSyncAgent.reset(point);
                    N2CChainSyncFetcher.this.tipFound = true;
                }
                N2CChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }

            public void intersactNotFound(Tip tip) {
                log.error("IntersactNotFound: {}", (Object)tip);
            }

            public void rollforward(Tip tip, Block block) {
                long slot = block.getHeader().getHeaderBody().getSlot();
                String hash = block.getHeader().getHeaderBody().getBlockHash();
                if (log.isDebugEnabled()) {
                    log.debug("Rolled to slot: {}, block: {}", (Object)slot, (Object)block.getHeader().getHeaderBody().getBlockNumber());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Trying to fetch block for {}", (Object)new Point(slot, hash));
                }
                N2CChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }

            public void rollforwardByronEra(Tip tip, ByronMainBlock byronMainBlock) {
                if (log.isDebugEnabled()) {
                    log.debug("ByronEraBlock : {}", (Object)byronMainBlock.getHeader().getConsensusData());
                }
                N2CChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }

            public void rollforwardByronEra(Tip tip, ByronEbBlock byronEbBlock) {
                if (log.isDebugEnabled()) {
                    log.debug("ByronEbBlock : {}", (Object)byronEbBlock.getHeader().getConsensusData());
                }
                N2CChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }

            public void rollbackward(Tip tip, Point toPoint) {
                N2CChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }
        });
        if (this.nodeSocketFile != null && !this.nodeSocketFile.isEmpty()) {
            this.n2CClient = new UnixSocketNodeClient(this.nodeSocketFile, this.handshakeAgent, new Agent[]{this.chainSyncAgent});
        } else if (this.host != null && !this.host.isEmpty()) {
            this.n2CClient = new TCPNodeClient(this.host, this.port, this.handshakeAgent, new Agent[]{this.chainSyncAgent});
        }
    }

    @Override
    public void start(final Consumer<Block> consumer) {
        this.chainSyncAgent.addListener((AgentListener)new LocalChainSyncAgentListener(){

            public void rollforward(Tip tip, Block block) {
                if (consumer != null) {
                    consumer.accept(block);
                }
            }
        });
        this.n2CClient.start();
    }

    public void addChainSyncListener(LocalChainSyncAgentListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (listener != null) {
            this.chainSyncAgent.addListener((AgentListener)listener);
        }
    }

    @Override
    public boolean isRunning() {
        return this.n2CClient.isRunning();
    }

    @Override
    public void shutdown() {
        this.n2CClient.shutdown();
    }
}

