/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper.model;

import com.bloxbean.cardano.yaci.core.model.AuxData;
import com.bloxbean.cardano.yaci.core.model.TransactionBody;
import com.bloxbean.cardano.yaci.core.model.Witnesses;
import com.bloxbean.cardano.yaci.helper.model.Utxo;
import java.util.List;

public class Transaction {
    private long blockNumber;
    private long slot;
    private String txHash;
    private TransactionBody body;
    private List<Utxo> utxos;
    private Utxo collateralReturnUtxo;
    private Witnesses witnesses;
    private AuxData auxData;
    private boolean invalid;

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public long getSlot() {
        return this.slot;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public TransactionBody getBody() {
        return this.body;
    }

    public List<Utxo> getUtxos() {
        return this.utxos;
    }

    public Utxo getCollateralReturnUtxo() {
        return this.collateralReturnUtxo;
    }

    public Witnesses getWitnesses() {
        return this.witnesses;
    }

    public AuxData getAuxData() {
        return this.auxData;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setBlockNumber(long blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void setSlot(long slot) {
        this.slot = slot;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public void setBody(TransactionBody body) {
        this.body = body;
    }

    public void setUtxos(List<Utxo> utxos) {
        this.utxos = utxos;
    }

    public void setCollateralReturnUtxo(Utxo collateralReturnUtxo) {
        this.collateralReturnUtxo = collateralReturnUtxo;
    }

    public void setWitnesses(Witnesses witnesses) {
        this.witnesses = witnesses;
    }

    public void setAuxData(AuxData auxData) {
        this.auxData = auxData;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockNumber() != other.getBlockNumber()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.isInvalid() != other.isInvalid()) {
            return false;
        }
        String this$txHash = this.getTxHash();
        String other$txHash = other.getTxHash();
        if (this$txHash == null ? other$txHash != null : !this$txHash.equals(other$txHash)) {
            return false;
        }
        TransactionBody this$body = this.getBody();
        TransactionBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<Utxo> this$utxos = this.getUtxos();
        List<Utxo> other$utxos = other.getUtxos();
        if (this$utxos == null ? other$utxos != null : !((Object)this$utxos).equals(other$utxos)) {
            return false;
        }
        Utxo this$collateralReturnUtxo = this.getCollateralReturnUtxo();
        Utxo other$collateralReturnUtxo = other.getCollateralReturnUtxo();
        if (this$collateralReturnUtxo == null ? other$collateralReturnUtxo != null : !((Object)this$collateralReturnUtxo).equals(other$collateralReturnUtxo)) {
            return false;
        }
        Witnesses this$witnesses = this.getWitnesses();
        Witnesses other$witnesses = other.getWitnesses();
        if (this$witnesses == null ? other$witnesses != null : !this$witnesses.equals(other$witnesses)) {
            return false;
        }
        AuxData this$auxData = this.getAuxData();
        AuxData other$auxData = other.getAuxData();
        return !(this$auxData == null ? other$auxData != null : !this$auxData.equals(other$auxData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $blockNumber = this.getBlockNumber();
        result = result * 59 + (int)($blockNumber >>> 32 ^ $blockNumber);
        long $slot = this.getSlot();
        result = result * 59 + (int)($slot >>> 32 ^ $slot);
        result = result * 59 + (this.isInvalid() ? 79 : 97);
        String $txHash = this.getTxHash();
        result = result * 59 + ($txHash == null ? 43 : $txHash.hashCode());
        TransactionBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<Utxo> $utxos = this.getUtxos();
        result = result * 59 + ($utxos == null ? 43 : ((Object)$utxos).hashCode());
        Utxo $collateralReturnUtxo = this.getCollateralReturnUtxo();
        result = result * 59 + ($collateralReturnUtxo == null ? 43 : ((Object)$collateralReturnUtxo).hashCode());
        Witnesses $witnesses = this.getWitnesses();
        result = result * 59 + ($witnesses == null ? 43 : $witnesses.hashCode());
        AuxData $auxData = this.getAuxData();
        result = result * 59 + ($auxData == null ? 43 : $auxData.hashCode());
        return result;
    }

    public String toString() {
        return "Transaction(blockNumber=" + this.getBlockNumber() + ", slot=" + this.getSlot() + ", txHash=" + this.getTxHash() + ", body=" + this.getBody() + ", utxos=" + this.getUtxos() + ", collateralReturnUtxo=" + this.getCollateralReturnUtxo() + ", witnesses=" + this.getWitnesses() + ", auxData=" + this.getAuxData() + ", invalid=" + this.isInvalid() + ")";
    }

    public Transaction() {
    }

    public Transaction(long blockNumber, long slot, String txHash, TransactionBody body, List<Utxo> utxos, Utxo collateralReturnUtxo, Witnesses witnesses, AuxData auxData, boolean invalid) {
        this.blockNumber = blockNumber;
        this.slot = slot;
        this.txHash = txHash;
        this.body = body;
        this.utxos = utxos;
        this.collateralReturnUtxo = collateralReturnUtxo;
        this.witnesses = witnesses;
        this.auxData = auxData;
        this.invalid = invalid;
    }

    public static class TransactionBuilder {
        private long blockNumber;
        private long slot;
        private String txHash;
        private TransactionBody body;
        private List<Utxo> utxos;
        private Utxo collateralReturnUtxo;
        private Witnesses witnesses;
        private AuxData auxData;
        private boolean invalid;

        TransactionBuilder() {
        }

        public TransactionBuilder blockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public TransactionBuilder slot(long slot) {
            this.slot = slot;
            return this;
        }

        public TransactionBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public TransactionBuilder body(TransactionBody body) {
            this.body = body;
            return this;
        }

        public TransactionBuilder utxos(List<Utxo> utxos) {
            this.utxos = utxos;
            return this;
        }

        public TransactionBuilder collateralReturnUtxo(Utxo collateralReturnUtxo) {
            this.collateralReturnUtxo = collateralReturnUtxo;
            return this;
        }

        public TransactionBuilder witnesses(Witnesses witnesses) {
            this.witnesses = witnesses;
            return this;
        }

        public TransactionBuilder auxData(AuxData auxData) {
            this.auxData = auxData;
            return this;
        }

        public TransactionBuilder invalid(boolean invalid) {
            this.invalid = invalid;
            return this;
        }

        public Transaction build() {
            return new Transaction(this.blockNumber, this.slot, this.txHash, this.body, this.utxos, this.collateralReturnUtxo, this.witnesses, this.auxData, this.invalid);
        }

        public String toString() {
            return "Transaction.TransactionBuilder(blockNumber=" + this.blockNumber + ", slot=" + this.slot + ", txHash=" + this.txHash + ", body=" + this.body + ", utxos=" + this.utxos + ", collateralReturnUtxo=" + this.collateralReturnUtxo + ", witnesses=" + this.witnesses + ", auxData=" + this.auxData + ", invalid=" + this.invalid + ")";
        }
    }
}

