/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper.listener;

import com.bloxbean.cardano.yaci.core.model.AuxData;
import com.bloxbean.cardano.yaci.core.model.Block;
import com.bloxbean.cardano.yaci.core.model.TransactionBody;
import com.bloxbean.cardano.yaci.core.model.TransactionOutput;
import com.bloxbean.cardano.yaci.core.model.Witnesses;
import com.bloxbean.cardano.yaci.core.model.byron.ByronEbBlock;
import com.bloxbean.cardano.yaci.core.model.byron.ByronMainBlock;
import com.bloxbean.cardano.yaci.core.protocol.blockfetch.BlockfetchAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.helper.listener.BlockChainDataListener;
import com.bloxbean.cardano.yaci.helper.model.Transaction;
import com.bloxbean.cardano.yaci.helper.model.Utxo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class BlockFetchAgentListenerAdapter
implements BlockfetchAgentListener {
    private BlockChainDataListener blockChainDataListener;

    public BlockFetchAgentListenerAdapter(BlockChainDataListener blockChainDataListener) {
        this.blockChainDataListener = blockChainDataListener;
    }

    public void blockFound(Block block) {
        ArrayList<Transaction> transactionEvents = new ArrayList<Transaction>();
        int i = 0;
        for (TransactionBody txBody : block.getTransactionBodies()) {
            Witnesses witnesses = (Witnesses)block.getTransactionWitness().get(i);
            AuxData auxData = (AuxData)block.getAuxiliaryDataMap().get(i);
            boolean invalidTxn = false;
            if (block.getInvalidTransactions() != null && block.getInvalidTransactions().size() > 0 && block.getInvalidTransactions().contains(i)) {
                invalidTxn = true;
            }
            List<Utxo> utxos = !invalidTxn ? this.getUtxosFromOutput(txBody) : Collections.emptyList();
            Optional<Utxo> collateralReturnUtxo = this.getCollateralReturnUtxo(txBody);
            Transaction transactionEvent = Transaction.builder().blockNumber(block.getHeader().getHeaderBody().getBlockNumber()).slot(block.getHeader().getHeaderBody().getSlot()).txHash(txBody.getTxHash()).body(txBody).utxos(utxos).collateralReturnUtxo(collateralReturnUtxo.orElse(null)).witnesses(witnesses).auxData(auxData).invalid(invalidTxn).build();
            transactionEvents.add(transactionEvent);
            ++i;
        }
        this.blockChainDataListener.onBlock(block.getEra(), block, transactionEvents);
    }

    private List<Utxo> getUtxosFromOutput(TransactionBody txBody) {
        ArrayList<Utxo> utxos = new ArrayList<Utxo>();
        for (int index = 0; index < txBody.getOutputs().size(); ++index) {
            TransactionOutput txOutput = (TransactionOutput)txBody.getOutputs().get(index);
            Utxo utxo = Utxo.builder().txHash(txBody.getTxHash()).index(index).address(txOutput.getAddress()).amounts(txOutput.getAmounts()).datumHash(txOutput.getDatumHash()).inlineDatum(txOutput.getInlineDatum()).scriptRef(txOutput.getScriptRef()).build();
            utxos.add(utxo);
        }
        return utxos;
    }

    private Optional<Utxo> getCollateralReturnUtxo(TransactionBody txBody) {
        if (txBody.getCollateralReturn() != null) {
            TransactionOutput txOutput = txBody.getCollateralReturn();
            Utxo utxo = Utxo.builder().txHash(txBody.getTxHash()).index(txBody.getOutputs().size()).address(txOutput.getAddress()).amounts(txOutput.getAmounts()).datumHash(txOutput.getDatumHash()).inlineDatum(txOutput.getInlineDatum()).scriptRef(txOutput.getScriptRef()).build();
            return Optional.of(utxo);
        }
        return Optional.empty();
    }

    public void byronBlockFound(ByronMainBlock byronBlock) {
        this.blockChainDataListener.onByronBlock(byronBlock);
    }

    public void byronEbBlockFound(ByronEbBlock byronEbBlock) {
        this.blockChainDataListener.onByronEbBlock(byronEbBlock);
    }

    public void batchDone() {
        this.blockChainDataListener.batchDone();
    }

    public void noBlockFound(Point from, Point to) {
        this.blockChainDataListener.noBlockFound(from, to);
    }
}

