/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.network.NodeClient;
import com.bloxbean.cardano.yaci.core.network.TCPNodeClient;
import com.bloxbean.cardano.yaci.core.network.UnixSocketNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.handshake.util.N2CVersionTableConstant;
import com.bloxbean.cardano.yaci.core.protocol.localstate.LocalStateQueryAgent;
import com.bloxbean.cardano.yaci.core.protocol.localstate.LocalStateQueryListener;
import com.bloxbean.cardano.yaci.core.protocol.localtx.LocalTxSubmissionAgent;
import com.bloxbean.cardano.yaci.core.protocol.localtx.LocalTxSubmissionListener;
import com.bloxbean.cardano.yaci.core.protocol.localtxmonitor.LocalTxMonitorAgent;
import com.bloxbean.cardano.yaci.core.protocol.localtxmonitor.LocalTxMonitorListener;
import com.bloxbean.cardano.yaci.helper.LocalStateQueryClient;
import com.bloxbean.cardano.yaci.helper.LocalTxMonitorClient;
import com.bloxbean.cardano.yaci.helper.LocalTxSubmissionClient;
import com.bloxbean.cardano.yaci.helper.listener.LocalClientProviderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClientProvider {
    private static final Logger log = LoggerFactory.getLogger(LocalClientProvider.class);
    private String nodeSocketFile;
    private String host;
    private int port;
    private VersionTable versionTable;
    private HandshakeAgent handshakeAgent;
    private LocalStateQueryAgent localStateQueryAgent;
    private LocalTxMonitorAgent localTxMonitorAgent;
    private LocalTxSubmissionAgent localTxSubmissionAgent;
    private NodeClient n2cClient;
    private LocalStateQueryClient localStateQueryClient;
    private LocalTxMonitorClient localTxMonitorClient;
    private LocalTxSubmissionClient localTxSubmissionClient;
    private LocalClientProviderListener localClientProviderListener;

    public LocalClientProvider(String nodeSocketFile, long protocolMagic) {
        this(nodeSocketFile, N2CVersionTableConstant.v1AndAbove((long)protocolMagic));
    }

    public LocalClientProvider(String nodeSocketFile, VersionTable versionTable) {
        this.nodeSocketFile = nodeSocketFile;
        this.versionTable = versionTable;
        this.init();
    }

    public LocalClientProvider(String host, int port, long protocolMagic) {
        this(host, port, N2CVersionTableConstant.v1AndAbove((long)protocolMagic));
    }

    public LocalClientProvider(String host, int port, VersionTable versionTable) {
        this.host = host;
        this.port = port;
        this.versionTable = versionTable;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.localStateQueryAgent = new LocalStateQueryAgent();
        this.localTxMonitorAgent = new LocalTxMonitorAgent();
        this.localTxSubmissionAgent = new LocalTxSubmissionAgent();
        if (this.nodeSocketFile != null && !this.nodeSocketFile.isEmpty()) {
            this.n2cClient = new UnixSocketNodeClient(this.nodeSocketFile, this.handshakeAgent, new Agent[]{this.localStateQueryAgent, this.localTxMonitorAgent, this.localTxSubmissionAgent});
        } else if (this.host != null && !this.host.isEmpty()) {
            this.n2cClient = new TCPNodeClient(this.host, this.port, this.handshakeAgent, new Agent[]{this.localStateQueryAgent, this.localTxMonitorAgent, this.localTxSubmissionAgent});
        }
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                LocalClientProvider.this.localStateQueryAgent.sendNextMessage();
                LocalClientProvider.this.localTxMonitorAgent.awaitAcquire();
                LocalClientProvider.this.localTxMonitorAgent.sendNextMessage();
                LocalClientProvider.this.localTxSubmissionAgent.sendNextMessage();
                if (LocalClientProvider.this.localClientProviderListener != null) {
                    LocalClientProvider.this.localClientProviderListener.onConnectionReady();
                }
            }
        });
        this.localStateQueryClient = new LocalStateQueryClient(this.localStateQueryAgent);
        this.localTxMonitorClient = new LocalTxMonitorClient(this.localTxMonitorAgent);
        this.localTxSubmissionClient = new LocalTxSubmissionClient(this.localTxSubmissionAgent);
    }

    public void start() {
        this.n2cClient.start();
    }

    public void reconnect() {
        this.n2cClient.restartSession();
    }

    public LocalStateQueryClient getLocalStateQueryClient() {
        return this.localStateQueryClient;
    }

    public LocalTxMonitorClient getTxMonitorClient() {
        return this.localTxMonitorClient;
    }

    public LocalTxSubmissionClient getTxSubmissionClient() {
        return this.localTxSubmissionClient;
    }

    public void shutdown() {
        this.n2cClient.shutdown();
    }

    public boolean isRunning() {
        return this.n2cClient.isRunning();
    }

    public void addLocalStateQueryListener(LocalStateQueryListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (listener != null) {
            this.localStateQueryAgent.addListener((AgentListener)listener);
        }
    }

    public void addLocalTxMonitorListener(LocalTxMonitorListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (listener != null) {
            this.localTxMonitorAgent.addListener((AgentListener)listener);
        }
    }

    public void addTxSubmissionListener(LocalTxSubmissionListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (listener != null) {
            this.localTxSubmissionAgent.addListener((AgentListener)listener);
        }
    }

    public void setLocalClientProviderListener(LocalClientProviderListener listener) {
        this.localClientProviderListener = listener;
    }
}

