/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.model.Block;
import com.bloxbean.cardano.yaci.core.network.TCPNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.blockfetch.BlockfetchAgent;
import com.bloxbean.cardano.yaci.core.protocol.blockfetch.BlockfetchAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.handshake.util.N2NVersionTableConstant;
import com.bloxbean.cardano.yaci.core.protocol.keepalive.KeepAliveAgent;
import com.bloxbean.cardano.yaci.core.protocol.keepalive.KeepAliveListener;
import com.bloxbean.cardano.yaci.helper.api.Fetcher;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockFetcher
implements Fetcher<Block> {
    private static final Logger log = LoggerFactory.getLogger(BlockFetcher.class);
    private String host;
    private int port;
    private VersionTable versionTable;
    private HandshakeAgent handshakeAgent;
    private KeepAliveAgent keepAliveAgent;
    private BlockfetchAgent blockfetchAgent;
    private TCPNodeClient n2nClient;
    private int lastKeepAliveResponseCookie = 0;
    private long lastKeepAliveResponseTime = 0L;

    public BlockFetcher(String host, int port, long protocolMagic) {
        this(host, port, N2NVersionTableConstant.v4AndAbove((long)protocolMagic));
    }

    public BlockFetcher(String host, int port, VersionTable versionTable) {
        this.host = host;
        this.port = port;
        this.versionTable = versionTable;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.keepAliveAgent = new KeepAliveAgent();
        this.blockfetchAgent = new BlockfetchAgent();
        this.n2nClient = new TCPNodeClient(this.host, this.port, this.handshakeAgent, new Agent[]{this.keepAliveAgent, this.blockfetchAgent});
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                BlockFetcher.this.blockfetchAgent.sendNextMessage();
                BlockFetcher.this.keepAliveAgent.sendKeepAlive(1234);
            }
        });
        this.keepAliveAgent.addListener((AgentListener)((KeepAliveListener)response -> {
            this.lastKeepAliveResponseCookie = response.getCookie();
            this.lastKeepAliveResponseTime = System.currentTimeMillis();
        }));
    }

    @Override
    public void start(final Consumer<Block> receiver) {
        this.blockfetchAgent.addListener((AgentListener)new BlockfetchAgentListener(){

            public void blockFound(Block block) {
                if (receiver != null) {
                    receiver.accept(block);
                }
            }
        });
        if (!this.n2nClient.isRunning()) {
            this.n2nClient.start();
        }
    }

    public void fetch(Point from, Point to) {
        if (!this.n2nClient.isRunning()) {
            throw new IllegalStateException("fetch() should be called after start()");
        }
        this.blockfetchAgent.resetPoints(from, to);
        if (!this.blockfetchAgent.isDone()) {
            this.blockfetchAgent.sendNextMessage();
        } else {
            log.warn("Agent status is Done. Can't reschedule new points.");
        }
    }

    public void addBlockFetchListener(BlockfetchAgentListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (listener != null) {
            this.blockfetchAgent.addListener((AgentListener)listener);
        }
    }

    @Override
    public boolean isRunning() {
        return this.n2nClient.isRunning();
    }

    @Override
    public void shutdown() {
        this.n2nClient.shutdown();
    }

    public void sendKeepAliveMessage(int cookie) {
        if (this.n2nClient.isRunning()) {
            this.keepAliveAgent.sendKeepAlive(cookie);
        }
    }

    public int getLastKeepAliveResponseCookie() {
        return this.lastKeepAliveResponseCookie;
    }

    public long getLastKeepAliveResponseTime() {
        return this.lastKeepAliveResponseTime;
    }
}

