/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.localtx.LocalTxSubmissionAgent;
import com.bloxbean.cardano.yaci.core.protocol.localtx.LocalTxSubmissionListener;
import com.bloxbean.cardano.yaci.core.protocol.localtx.messages.MsgAcceptTx;
import com.bloxbean.cardano.yaci.core.protocol.localtx.messages.MsgRejectTx;
import com.bloxbean.cardano.yaci.core.protocol.localtx.model.TxSubmissionRequest;
import com.bloxbean.cardano.yaci.helper.api.QueryClient;
import com.bloxbean.cardano.yaci.helper.model.TxResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class LocalTxSubmissionClient
extends QueryClient {
    private static final Logger log = LoggerFactory.getLogger(LocalTxSubmissionClient.class);
    private final LocalTxSubmissionAgent localTxSubmissionAgent;

    public LocalTxSubmissionClient(LocalTxSubmissionAgent localTxSubmissionAgent) {
        this.localTxSubmissionAgent = localTxSubmissionAgent;
        this.init();
    }

    private void init() {
        this.localTxSubmissionAgent.addListener((AgentListener)new LocalTxSubmissionListener(){

            public void txAccepted(TxSubmissionRequest txSubmissionRequest, MsgAcceptTx msgAcceptTx) {
                TxResult txResult = TxResult.builder().txHash(txSubmissionRequest.getTxHash()).accepted(true).build();
                LocalTxSubmissionClient.this.applyMonoSuccess(txSubmissionRequest, txResult);
            }

            public void txRejected(TxSubmissionRequest txSubmissionRequest, MsgRejectTx msgRejectTx) {
                TxResult txResult = TxResult.builder().txHash(txSubmissionRequest.getTxHash()).accepted(false).errorCbor(msgRejectTx.getReasonCbor()).build();
                LocalTxSubmissionClient.this.applyMonoSuccess(txSubmissionRequest, txResult);
            }

            public void onDisconnect() {
                LocalTxSubmissionClient.this.applyError("Connection Error !!!");
            }
        });
    }

    public void submitTxCallback(TxSubmissionRequest txSubmissionRequest) {
        this.localTxSubmissionAgent.submitTx(txSubmissionRequest);
        this.localTxSubmissionAgent.sendNextMessage();
    }

    public Mono<TxResult> submitTx(TxSubmissionRequest txSubmissionRequest) {
        return Mono.create(monoSink -> {
            this.localTxSubmissionAgent.submitTx(txSubmissionRequest);
            this.storeMonoSinkReference(txSubmissionRequest, (MonoSink)monoSink);
            this.localTxSubmissionAgent.sendNextMessage();
        });
    }
}

