/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.common.Constants;
import com.bloxbean.cardano.yaci.core.model.Block;
import com.bloxbean.cardano.yaci.core.model.BlockHeader;
import com.bloxbean.cardano.yaci.core.model.byron.ByronBlockHead;
import com.bloxbean.cardano.yaci.core.model.byron.ByronEbBlock;
import com.bloxbean.cardano.yaci.core.model.byron.ByronEbHead;
import com.bloxbean.cardano.yaci.core.model.byron.ByronMainBlock;
import com.bloxbean.cardano.yaci.core.network.TCPNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.blockfetch.BlockfetchAgent;
import com.bloxbean.cardano.yaci.core.protocol.blockfetch.BlockfetchAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Tip;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2n.ChainSyncAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2n.ChainsyncAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.handshake.util.N2NVersionTableConstant;
import com.bloxbean.cardano.yaci.core.protocol.keepalive.KeepAliveAgent;
import com.bloxbean.cardano.yaci.core.protocol.keepalive.KeepAliveListener;
import com.bloxbean.cardano.yaci.helper.api.Fetcher;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class N2NChainSyncFetcher
implements Fetcher<Block> {
    private static final Logger log = LoggerFactory.getLogger(N2NChainSyncFetcher.class);
    private String host;
    private int port;
    private VersionTable versionTable;
    private Point wellKnownPoint;
    private boolean syncFromLatest;
    private boolean tipFound = false;
    private HandshakeAgent handshakeAgent;
    private KeepAliveAgent keepAliveAgent;
    private ChainsyncAgent chainSyncAgent;
    private BlockfetchAgent blockFetchAgent;
    private TCPNodeClient n2nClient;
    private int lastKeepAliveResponseCookie = 0;
    private long lastKeepAliveResponseTime = 0L;

    public N2NChainSyncFetcher(String host, int port, Point wellKnownPoint, long protocolMagic) {
        this(host, port, wellKnownPoint, N2NVersionTableConstant.v4AndAbove((long)protocolMagic), true);
    }

    public N2NChainSyncFetcher(String host, int port, Point wellKnownPoint, long protocolMagic, boolean syncFromLatest) {
        this(host, port, wellKnownPoint, N2NVersionTableConstant.v4AndAbove((long)protocolMagic), syncFromLatest);
    }

    public N2NChainSyncFetcher(String host, int port, Point wellKnownPoint, VersionTable versionTable) {
        this(host, port, wellKnownPoint, versionTable, true);
    }

    public N2NChainSyncFetcher(String host, int port, Point wellKnownPoint, VersionTable versionTable, boolean syncFromLatest) {
        this.host = host;
        this.port = port;
        this.versionTable = versionTable;
        this.wellKnownPoint = wellKnownPoint;
        this.syncFromLatest = syncFromLatest;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.keepAliveAgent = new KeepAliveAgent();
        this.chainSyncAgent = new ChainsyncAgent(new Point[]{this.wellKnownPoint});
        this.blockFetchAgent = new BlockfetchAgent();
        this.blockFetchAgent.resetPoints(this.wellKnownPoint, this.wellKnownPoint);
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                N2NChainSyncFetcher.this.keepAliveAgent.sendKeepAlive(1234);
                N2NChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }
        });
        this.chainSyncAgent.addListener((AgentListener)new ChainSyncAgentListener(){

            public void intersactFound(Tip tip, Point point) {
                if (log.isDebugEnabled()) {
                    log.debug("Intersect found : Point : {},  Tip: {}", (Object)point, (Object)tip);
                    log.debug("Tip Found: {}", (Object)N2NChainSyncFetcher.this.tipFound);
                }
                if (N2NChainSyncFetcher.this.syncFromLatest) {
                    if (!tip.getPoint().equals((Object)point) && !N2NChainSyncFetcher.this.tipFound) {
                        N2NChainSyncFetcher.this.chainSyncAgent.reset(tip.getPoint());
                        N2NChainSyncFetcher.this.tipFound = true;
                    }
                } else if (!N2NChainSyncFetcher.this.tipFound) {
                    N2NChainSyncFetcher.this.chainSyncAgent.reset(point);
                    N2NChainSyncFetcher.this.tipFound = true;
                }
                N2NChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }

            public void intersactNotFound(Tip tip) {
                log.error("IntersactNotFound: {}", (Object)tip);
            }

            public void rollforward(Tip tip, BlockHeader blockHeader) {
                long slot = blockHeader.getHeaderBody().getSlot();
                String hash = blockHeader.getHeaderBody().getBlockHash();
                N2NChainSyncFetcher.this.resetBlockFetchAgentAndFetchBlock(slot, hash);
            }

            public void rollforwardByronEra(Tip tip, ByronBlockHead byronHead) {
                long absoluteSlot = byronHead.getConsensusData().getAbsoluteSlot();
                String hash = byronHead.getBlockHash();
                N2NChainSyncFetcher.this.resetBlockFetchAgentAndFetchBlock(absoluteSlot, hash);
            }

            public void rollforwardByronEra(Tip tip, ByronEbHead byronEbHead) {
                long epoch = byronEbHead.getConsensusData().getEpoch();
                String hash = byronEbHead.getBlockHash();
                N2NChainSyncFetcher.this.resetBlockFetchAgentAndFetchBlock(byronEbHead.getConsensusData().getAbsoluteSlot(), hash);
            }

            public void rollbackward(Tip tip, Point toPoint) {
                N2NChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }
        });
        this.blockFetchAgent.addListener((AgentListener)new BlockfetchAgentListener(){

            public void blockFound(Block block) {
                if (log.isDebugEnabled()) {
                    log.debug("Block Found >> " + block);
                }
                N2NChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }

            public void byronBlockFound(ByronMainBlock byronBlock) {
                N2NChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }

            public void byronEbBlockFound(ByronEbBlock byronEbBlock) {
                N2NChainSyncFetcher.this.chainSyncAgent.sendNextMessage();
            }
        });
        this.keepAliveAgent.addListener((AgentListener)((KeepAliveListener)response -> {
            this.lastKeepAliveResponseCookie = response.getCookie();
            this.lastKeepAliveResponseTime = System.currentTimeMillis();
        }));
        this.n2nClient = new TCPNodeClient(this.host, this.port, this.handshakeAgent, new Agent[]{this.keepAliveAgent, this.chainSyncAgent, this.blockFetchAgent});
    }

    private void resetBlockFetchAgentAndFetchBlock(long slot, String hash) {
        if (log.isDebugEnabled()) {
            log.debug("Rolled to slot: {}, block: {}", (Object)slot, (Object)hash);
        }
        this.blockFetchAgent.resetPoints(new Point(slot, hash), new Point(slot, hash));
        if (log.isDebugEnabled()) {
            log.debug("Trying to fetch block for {}", (Object)new Point(slot, hash));
        }
        this.blockFetchAgent.sendNextMessage();
    }

    @Override
    public void start(final Consumer<Block> consumer) {
        this.blockFetchAgent.addListener((AgentListener)new BlockfetchAgentListener(){

            public void blockFound(Block block) {
                if (consumer != null) {
                    consumer.accept(block);
                }
            }
        });
        this.n2nClient.start();
    }

    public void addBlockFetchListener(BlockfetchAgentListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (listener != null) {
            this.blockFetchAgent.addListener((AgentListener)listener);
        }
    }

    public void addChainSyncListener(ChainSyncAgentListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (listener != null) {
            this.chainSyncAgent.addListener((AgentListener)listener);
        }
    }

    public void sendKeepAliveMessage(int cookie) {
        if (this.n2nClient.isRunning()) {
            this.keepAliveAgent.sendKeepAlive(cookie);
        }
    }

    public int getLastKeepAliveResponseCookie() {
        return this.lastKeepAliveResponseCookie;
    }

    public long getLastKeepAliveResponseTime() {
        return this.lastKeepAliveResponseTime;
    }

    @Override
    public boolean isRunning() {
        return this.n2nClient.isRunning();
    }

    @Override
    public void shutdown() {
        this.n2nClient.shutdown();
    }

    public static void main(String[] args) throws Exception {
        N2NChainSyncFetcher chainSyncFetcher = new N2NChainSyncFetcher("localhost", 30000, Constants.WELL_KNOWN_PREPROD_POINT, Constants.PREPROD_PROTOCOL_MAGIC);
        chainSyncFetcher.addChainSyncListener(new ChainSyncAgentListener(){

            public void rollforward(Tip tip, BlockHeader blockHeader) {
                log.info("RollForward !!!");
            }
        });
        chainSyncFetcher.start((Block block) -> log.info(">>>> Block >>>> " + block.getHeader().getHeaderBody().getBlockNumber()));
    }
}

