/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.client.transaction.util.TransactionUtil;
import com.bloxbean.cardano.yaci.core.common.TxBodyType;
import com.bloxbean.cardano.yaci.core.network.TCPNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.keepalive.KeepAliveAgent;
import com.bloxbean.cardano.yaci.core.protocol.txsubmission.TxSubmissionAgent;
import com.bloxbean.cardano.yaci.core.protocol.txsubmission.TxSubmissionListener;
import com.bloxbean.cardano.yaci.core.protocol.txsubmission.messges.RequestTxIds;
import com.bloxbean.cardano.yaci.core.protocol.txsubmission.messges.RequestTxs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxSubmissionClient {
    private static final Logger log = LoggerFactory.getLogger(TxSubmissionClient.class);
    private String host;
    private int port;
    private VersionTable versionTable;
    private HandshakeAgent handshakeAgent;
    private TxSubmissionAgent txSubmissionAgent;
    private KeepAliveAgent keepAliveAgent;
    private TCPNodeClient n2nClient;

    public TxSubmissionClient(String host, int port, VersionTable versionTable) {
        this.host = host;
        this.port = port;
        this.versionTable = versionTable;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.txSubmissionAgent = new TxSubmissionAgent();
        this.keepAliveAgent = new KeepAliveAgent();
        this.n2nClient = new TCPNodeClient(this.host, this.port, this.handshakeAgent, new Agent[]{this.txSubmissionAgent, this.keepAliveAgent});
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                log.info("Handshake okay: {}:{}", (Object)TxSubmissionClient.this.host, (Object)TxSubmissionClient.this.port);
                TxSubmissionClient.this.keepAliveAgent.sendKeepAlive(1234);
                TxSubmissionClient.this.txSubmissionAgent.sendNextMessage();
            }
        });
        this.txSubmissionAgent.addListener((AgentListener)new TxSubmissionListener(){

            public void handleRequestTxs(RequestTxs requestTxs) {
                TxSubmissionClient.this.txSubmissionAgent.sendNextMessage();
            }

            public void handleRequestTxIdsNonBlocking(RequestTxIds requestTxIds) {
                this.submit(false);
            }

            public void handleRequestTxIdsBlocking(RequestTxIds requestTxIds) {
                this.submit(true);
            }

            private void submit(boolean isBlocking) {
                if (isBlocking) {
                    if (TxSubmissionClient.this.txSubmissionAgent.hasPendingTx()) {
                        TxSubmissionClient.this.txSubmissionAgent.sendNextMessage();
                    }
                } else {
                    TxSubmissionClient.this.txSubmissionAgent.sendNextMessage();
                }
            }
        });
    }

    public void addListener(TxSubmissionListener txSubmissionListener) {
        if (this.isRunning()) {
            throw new IllegalStateException("Listener can be added only before start() call");
        }
        if (txSubmissionListener != null) {
            this.txSubmissionAgent.addListener((AgentListener)txSubmissionListener);
        }
    }

    public void start() {
        this.n2nClient.start();
    }

    public void shutdown() {
        this.n2nClient.shutdown();
    }

    public boolean isRunning() {
        return this.n2nClient.isRunning();
    }

    public void submitTxBytes(byte[] txBytes) {
        String txHash = TransactionUtil.getTxHash((byte[])txBytes);
        this.submitTxBytes(txHash, txBytes, TxBodyType.BABBAGE);
    }

    public void submitTxBytes(String txHash, byte[] txBytes, TxBodyType txBodyType) {
        this.txSubmissionAgent.enqueueTransaction(txHash, txBytes, txBodyType);
    }

    public void sendKeepAlive() {
        int min = 1;
        int max = 65000;
        int randomNum = (int)(Math.random() * (double)(max - min + 1)) + min;
        this.keepAliveAgent.sendKeepAlive(randomNum);
    }
}

