/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.handshake.util.N2NVersionTableConstant;
import com.bloxbean.cardano.yaci.helper.N2NChainSyncFetcher;
import com.bloxbean.cardano.yaci.helper.listener.BlockChainDataListener;
import com.bloxbean.cardano.yaci.helper.listener.BlockFetchAgentListenerAdapter;
import com.bloxbean.cardano.yaci.helper.listener.ChainSyncListenerAdapter;

public class BlockSync {
    private String host;
    private int port;
    private Point wellKnownPoint;
    private VersionTable versionTable;
    private N2NChainSyncFetcher n2NChainSyncFetcher;

    public BlockSync(String host, int port, long protocolMagic, Point wellKnownPoint) {
        this(host, port, wellKnownPoint, N2NVersionTableConstant.v4AndAbove((long)protocolMagic));
    }

    public BlockSync(String host, int port, Point wellKnownPoint, VersionTable versionTable) {
        this.host = host;
        this.port = port;
        this.wellKnownPoint = wellKnownPoint;
        this.versionTable = versionTable;
    }

    public void startSync(Point point, BlockChainDataListener blockChainDataListener) {
        if (this.n2NChainSyncFetcher != null && this.n2NChainSyncFetcher.isRunning()) {
            this.n2NChainSyncFetcher.shutdown();
        }
        this.initializeAgentAndStart(point, blockChainDataListener, false);
    }

    private void initializeAgentAndStart(Point point, BlockChainDataListener blockChainDataListener, boolean syncFromTip) {
        this.n2NChainSyncFetcher = new N2NChainSyncFetcher(this.host, this.port, point, this.versionTable, syncFromTip);
        BlockFetchAgentListenerAdapter blockfetchAgentListener = new BlockFetchAgentListenerAdapter(blockChainDataListener);
        ChainSyncListenerAdapter chainSyncAgentListener = new ChainSyncListenerAdapter(blockChainDataListener);
        this.n2NChainSyncFetcher.addChainSyncListener(chainSyncAgentListener);
        this.n2NChainSyncFetcher.addBlockFetchListener(blockfetchAgentListener);
        this.n2NChainSyncFetcher.start();
    }

    public void startSyncFromTip(BlockChainDataListener blockChainDataListener) {
        if (this.n2NChainSyncFetcher != null && this.n2NChainSyncFetcher.isRunning()) {
            this.n2NChainSyncFetcher.shutdown();
        }
        this.initializeAgentAndStart(this.wellKnownPoint, blockChainDataListener, true);
    }

    public void sendKeepAliveMessage(int cookie) {
        if (this.n2NChainSyncFetcher.isRunning()) {
            this.n2NChainSyncFetcher.sendKeepAliveMessage(cookie);
        }
    }

    public int getLastKeepAliveResponseCookie() {
        return this.n2NChainSyncFetcher.getLastKeepAliveResponseCookie();
    }

    public long getLastKeepAliveResponseTime() {
        return this.n2NChainSyncFetcher.getLastKeepAliveResponseTime();
    }

    public void stop() {
        this.n2NChainSyncFetcher.shutdown();
    }

    public boolean isRunning() {
        return this.n2NChainSyncFetcher.isRunning();
    }
}

