/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.model.Block;
import com.bloxbean.cardano.yaci.core.model.Era;
import com.bloxbean.cardano.yaci.core.model.byron.ByronEbBlock;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.helper.BlockSync;
import com.bloxbean.cardano.yaci.helper.listener.BlockChainDataListener;
import com.bloxbean.cardano.yaci.helper.model.StartPoint;
import com.bloxbean.cardano.yaci.helper.model.Transaction;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class GenesisBlockFinder {
    private BlockSync blockSync;

    public GenesisBlockFinder(String host, int port, long protocolMagic) {
        this.blockSync = new BlockSync(host, port, protocolMagic, Point.ORIGIN);
    }

    public Optional<StartPoint> getGenesisAndFirstBlock() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final StartPoint startPoint = new StartPoint();
        this.blockSync.startSync(Point.ORIGIN, new BlockChainDataListener(){

            @Override
            public void onByronEbBlock(ByronEbBlock byronEbBlock) {
                startPoint.setFirstBlock(new Point(0L, byronEbBlock.getHeader().getBlockHash()));
                startPoint.setFirstBlockEra(Era.Byron);
                startPoint.setGenesisHash(byronEbBlock.getHeader().getPrevBlock());
                countDownLatch.countDown();
            }

            @Override
            public void onBlock(Era era, Block block, List<Transaction> transactions) {
                if (block.getHeader().getHeaderBody().getBlockNumber() == 0L) {
                    startPoint.setFirstBlock(new Point(block.getHeader().getHeaderBody().getSlot(), block.getHeader().getHeaderBody().getBlockHash()));
                    startPoint.setFirstBlockEra(block.getEra());
                    startPoint.setGenesisHash(block.getHeader().getHeaderBody().getPrevHash());
                    countDownLatch.countDown();
                }
            }
        });
        try {
            countDownLatch.await(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.blockSync.stop();
        if (startPoint.getFirstBlock() == null) {
            return Optional.empty();
        }
        return Optional.of(startPoint);
    }
}

