/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.helper;

import com.bloxbean.cardano.yaci.core.common.Constants;
import com.bloxbean.cardano.yaci.core.network.TCPNodeClient;
import com.bloxbean.cardano.yaci.core.protocol.Agent;
import com.bloxbean.cardano.yaci.core.protocol.AgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Tip;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2n.ChainSyncAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.chainsync.n2n.ChainsyncAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgent;
import com.bloxbean.cardano.yaci.core.protocol.handshake.HandshakeAgentListener;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.Reason;
import com.bloxbean.cardano.yaci.core.protocol.handshake.messages.VersionTable;
import com.bloxbean.cardano.yaci.core.protocol.handshake.util.N2NVersionTableConstant;
import com.bloxbean.cardano.yaci.helper.api.ReactiveFetcher;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class TipFinder
extends ReactiveFetcher<Tip> {
    private static final Logger log = LoggerFactory.getLogger(TipFinder.class);
    private String host;
    private int port;
    private final Point wellKnownPoint;
    private HandshakeAgent handshakeAgent;
    private ChainsyncAgent chainSyncAgent;
    private TCPNodeClient n2NClient;
    private VersionTable versionTable;
    private String tipRequest = "TIP_REQUEST";

    public TipFinder(String host, int port, Point wellKnownPoint, long protocolMagic) {
        this(host, port, wellKnownPoint, N2NVersionTableConstant.v4AndAbove((long)protocolMagic));
    }

    public TipFinder(String host, int port, Point wellKnownPoint, VersionTable versionTable) {
        this.host = host;
        this.port = port;
        this.wellKnownPoint = wellKnownPoint;
        this.versionTable = versionTable;
        this.init();
    }

    private void init() {
        this.handshakeAgent = new HandshakeAgent(this.versionTable);
        this.chainSyncAgent = new ChainsyncAgent(new Point[]{this.wellKnownPoint});
        this.handshakeAgent.addListener((AgentListener)new HandshakeAgentListener(){

            public void handshakeOk() {
                if (log.isDebugEnabled()) {
                    log.debug("Handshake ok");
                }
                TipFinder.this.chainSyncAgent.sendNextMessage();
            }

            public void handshakeError(Reason reason) {
                log.error("Handshake Error : {}", (Object)reason);
            }
        });
        this.n2NClient = new TCPNodeClient(this.host, this.port, this.handshakeAgent, new Agent[]{this.chainSyncAgent});
    }

    @Override
    public void start(final Consumer<Tip> consumer) {
        this.chainSyncAgent.addListener((AgentListener)new ChainSyncAgentListener(){

            public void intersactFound(Tip tip, Point point) {
                if (consumer != null) {
                    consumer.accept(tip);
                }
            }
        });
        if (!this.n2NClient.isRunning()) {
            this.n2NClient.start();
        }
    }

    public void next() {
        this.chainSyncAgent.reset(this.wellKnownPoint);
        this.chainSyncAgent.sendNextMessage();
    }

    public Mono<Tip> find() {
        this.chainSyncAgent.addListener((AgentListener)new ChainSyncAgentListener(){

            public void intersactFound(Tip tip, Point point) {
                TipFinder.this.applyMonoSuccess(TipFinder.this.tipRequest, tip);
            }
        });
        return Mono.create(tipMonoSink -> {
            if (log.isDebugEnabled()) {
                log.debug("Try to find tip");
            }
            this.storeMonoSinkReference(this.tipRequest, (MonoSink)tipMonoSink);
            if (!this.n2NClient.isRunning()) {
                this.n2NClient.start();
            } else {
                this.next();
            }
        });
    }

    @Override
    public void shutdown() {
        if (this.n2NClient != null) {
            this.n2NClient.shutdown();
        }
    }

    @Override
    public boolean isRunning() {
        return this.n2NClient.isRunning();
    }

    public static void main(String[] args) {
        Point point = new Point(16588737L, "4e9bbbb67e3ae262133d94c3da5bffce7b1127fc436e7433b87668dba34c354a");
        TipFinder tipFinder = new TipFinder("192.168.0.228", 6000, point, Constants.MAINNET_PROTOCOL_MAGIC);
        tipFinder.start((Tip tip) -> System.out.println("Tip found >>>> " + String.valueOf(tip)));
        tipFinder.shutdown();
    }
}

