/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.blocks.controller;

import com.bloxbean.cardano.yaci.store.api.blocks.dto.BlockDto;
import com.bloxbean.cardano.yaci.store.api.blocks.dto.BlockDtoMapper;
import com.bloxbean.cardano.yaci.store.api.blocks.service.BlockService;
import com.bloxbean.cardano.yaci.store.blocks.domain.Block;
import com.bloxbean.cardano.yaci.store.blocks.domain.BlocksPage;
import com.bloxbean.cardano.yaci.store.blocks.domain.PoolBlock;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Block Service")
@RequestMapping(value={"${apiPrefix}/blocks"})
@ConditionalOnExpression(value="${store.blocks.endpoints.block.enabled:true}")
public class BlockController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlockController.class);
    private final BlockService blockService;
    private final BlockDtoMapper dtoMapper;

    @GetMapping(value={"{numberOrHash}"})
    @Operation(summary="Block Information by Number or Hash", description="Get block information by number or hash.")
    public ResponseEntity<BlockDto> getBlockByNumber(@PathVariable String numberOrHash) {
        if (NumberUtils.isParsable((String)numberOrHash)) {
            return this.blockService.getBlockByNumber(Long.parseLong(numberOrHash)).map(block -> ResponseEntity.ok((Object)this.dtoMapper.toBlockDto((Block)block))).orElse(ResponseEntity.notFound().build());
        }
        return this.blockService.getBlockByHash(numberOrHash).map(block -> ResponseEntity.ok((Object)this.dtoMapper.toBlockDto((Block)block))).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping
    @Operation(summary="Block List", description="Get blocks by page number and count.")
    public ResponseEntity<BlocksPage> getBlocks(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return ResponseEntity.ok((Object)this.blockService.getBlocks(p, count));
    }

    @GetMapping(value={"pool/{poolId}"})
    @Operation(summary="Slot Leader Block List", description="Get blocks of slot leader in a specific epoch.")
    public ResponseEntity<List<PoolBlock>> getBlocksBySlotLeaderEpoch(@PathVariable String poolId, @RequestParam int epoch) {
        return ResponseEntity.ok(this.blockService.getBlocksBySlotLeaderEpoch(poolId, epoch));
    }

    @GetMapping(value={"latest"})
    @Operation(summary="Latest Block", description="Get the Latest Block Information.")
    public ResponseEntity<BlockDto> getLatestBlock() {
        return this.blockService.getLatestBlock().map(block -> ResponseEntity.ok((Object)this.dtoMapper.toBlockDto((Block)block))).orElse(ResponseEntity.notFound().build());
    }

    @Generated
    public BlockController(BlockService blockService, BlockDtoMapper dtoMapper) {
        this.blockService = blockService;
        this.dtoMapper = dtoMapper;
    }
}

