/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.blocks.dto;

import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.store.api.blocks.dto.BlockDto;
import com.bloxbean.cardano.yaci.store.blocks.domain.Block;
import org.springframework.stereotype.Component;

@Component
public class BlockDtoMapper {
    public BlockDto toBlockDto(Block block) {
        if (block == null) {
            return null;
        }
        String vrfVkey = block.getVrfVkey() != null ? Bech32.encode((byte[])HexUtil.decodeHexString((String)block.getVrfVkey()), (String)"vrf_vk") : null;
        BlockDto blockDto = BlockDto.builder().time(block.getBlockTime()).height(block.getNumber()).number(block.getNumber()).hash(block.getHash()).slot(block.getSlot()).epoch(block.getEpochNumber()).era(block.getEra()).epochSlot(block.getEpochSlot()).slotLeader(block.getSlotLeader()).size(block.getBlockBodySize()).txCount(block.getNoOfTxs()).output(block.getTotalOutput()).fees(block.getTotalFees()).blockVrf(vrfVkey).opCert(block.getOpCertHotVKey()).opCertCounter(block.getOpCertSeqNumber()).opCertKesPeriod(block.getOpcertKesPeriod()).opCertSigma(block.getOpCertSigma()).previousBlock(block.getPrevHash()).issuerVkey(block.getIssuerVkey()).nonceVrf(block.getNonceVrf()).leaderVrf(block.getLeaderVrf()).vrfResult(block.getVrfResult()).blockBodyHash(block.getBlockBodyHash()).protocolVersion(block.getProtocolVersion()).build();
        return blockDto;
    }
}

