/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.blocks.service;

import com.bloxbean.cardano.yaci.store.blocks.domain.Block;
import com.bloxbean.cardano.yaci.store.blocks.domain.BlocksPage;
import com.bloxbean.cardano.yaci.store.blocks.domain.PoolBlock;
import com.bloxbean.cardano.yaci.store.blocks.storage.BlockStorageReader;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class BlockService {
    private final BlockStorageReader blockReader;

    public Optional<Block> getBlockByNumber(long blockNumber) {
        return this.blockReader.findByBlock(blockNumber);
    }

    public Optional<Block> getBlockByHash(String blockHash) {
        return this.blockReader.findByBlockHash(blockHash);
    }

    public BlocksPage getBlocks(int page, int count) {
        return this.blockReader.findBlocks(page, count);
    }

    public List<PoolBlock> getBlocksBySlotLeaderEpoch(String slotLeader, int epoch) {
        return this.blockReader.findBlocksBySlotLeaderAndEpoch(slotLeader, epoch);
    }

    public Optional<Block> getLatestBlock() {
        return this.blockReader.findRecentBlock();
    }

    @Generated
    public BlockService(BlockStorageReader blockReader) {
        this.blockReader = blockReader;
    }
}

