/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.blocks.storage.impl;

import com.bloxbean.cardano.yaci.store.blocks.domain.Block;
import com.bloxbean.cardano.yaci.store.blocks.storage.BlockStorage;
import com.bloxbean.cardano.yaci.store.blocks.storage.impl.mapper.BlockMapper;
import com.bloxbean.cardano.yaci.store.blocks.storage.impl.model.BlockEntity;
import com.bloxbean.cardano.yaci.store.blocks.storage.impl.repository.BlockRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class BlockStorageImpl
implements BlockStorage {
    private final BlockRepository blockRepository;
    private final BlockMapper blockDetailsMapper;

    @Override
    public Optional<Block> findRecentBlock() {
        return this.blockRepository.findTopByOrderByNumberDesc().map(blockEntity -> this.blockDetailsMapper.toBlock((BlockEntity)((Object)blockEntity)));
    }

    @Override
    public List<Block> findBlocksByEpoch(int epochNumber) {
        return this.blockRepository.findByEpochNumber(epochNumber).stream().map(blockEntity -> this.blockDetailsMapper.toBlock((BlockEntity)((Object)blockEntity))).collect(Collectors.toList());
    }

    @Override
    public int deleteBySlotGreaterThan(long slot) {
        return this.blockRepository.deleteBySlotGreaterThan(slot);
    }

    @Override
    public void save(Block block) {
        BlockEntity blockEntity = this.blockDetailsMapper.toBlockEntity(block);
        this.blockRepository.save((Object)blockEntity);
    }

    @Generated
    public BlockStorageImpl(BlockRepository blockRepository, BlockMapper blockDetailsMapper) {
        this.blockRepository = blockRepository;
        this.blockDetailsMapper = blockDetailsMapper;
    }
}

