/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.blocks.storage.impl;

import com.bloxbean.cardano.yaci.store.blocks.domain.Block;
import com.bloxbean.cardano.yaci.store.blocks.domain.BlockSummary;
import com.bloxbean.cardano.yaci.store.blocks.domain.BlocksPage;
import com.bloxbean.cardano.yaci.store.blocks.domain.PoolBlock;
import com.bloxbean.cardano.yaci.store.blocks.storage.BlockStorageReader;
import com.bloxbean.cardano.yaci.store.blocks.storage.impl.mapper.BlockMapper;
import com.bloxbean.cardano.yaci.store.blocks.storage.impl.model.BlockEntity;
import com.bloxbean.cardano.yaci.store.blocks.storage.impl.repository.BlockRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;

public class BlockStorageReaderImpl
implements BlockStorageReader {
    private final BlockRepository blockRepository;
    private final BlockMapper blockDetailsMapper;

    @Override
    public Optional<Block> findRecentBlock() {
        return this.blockRepository.findTopByOrderByNumberDesc().map(blockEntity -> this.blockDetailsMapper.toBlock((BlockEntity)((Object)blockEntity)));
    }

    @Override
    public BlocksPage findBlocks(int page, int count) {
        PageRequest sortedByBlock = PageRequest.of((int)page, (int)count, (Sort)Sort.by((String[])new String[]{"number"}).descending());
        Slice<BlockEntity> blocksEntityPage = this.blockRepository.findAllBlocks((Pageable)sortedByBlock);
        List<BlockSummary> blockSummaryList = blocksEntityPage.stream().map(blockEntity -> this.blockDetailsMapper.toBlockSummary((BlockEntity)((Object)blockEntity))).collect(Collectors.toList());
        return BlocksPage.builder().blocks(blockSummaryList).build();
    }

    @Override
    public List<Block> findBlocksByEpoch(int epochNumber) {
        return this.blockRepository.findByEpochNumber(epochNumber).stream().map(blockEntity -> this.blockDetailsMapper.toBlock((BlockEntity)((Object)blockEntity))).collect(Collectors.toList());
    }

    @Override
    public Optional<Block> findByBlockHash(String blockHash) {
        return this.blockRepository.findByHash(blockHash).map(blockEntity -> this.blockDetailsMapper.toBlock((BlockEntity)((Object)blockEntity)));
    }

    @Override
    public Optional<Block> findByBlock(long block) {
        return this.blockRepository.findByNumber(block).map(blockEntity -> this.blockDetailsMapper.toBlock((BlockEntity)((Object)blockEntity)));
    }

    @Override
    public List<PoolBlock> findBlocksBySlotLeaderAndEpoch(String slotLeader, int epoch) {
        return this.blockRepository.getBlockEntitiesBySlotLeaderAndEpochNumber(slotLeader, epoch).stream().map(blockEntity -> PoolBlock.builder().hash(blockEntity.getHash()).number(blockEntity.getNumber()).epoch(blockEntity.getEpochNumber()).poolId(blockEntity.getSlotLeader()).build()).collect(Collectors.toList());
    }

    @Generated
    public BlockStorageReaderImpl(BlockRepository blockRepository, BlockMapper blockDetailsMapper) {
        this.blockRepository = blockRepository;
        this.blockDetailsMapper = blockDetailsMapper;
    }
}

