/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.client.utxo;

import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClient;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.Utxo;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class UtxoClientImpl
implements UtxoClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoClientImpl.class);
    private final RestTemplate restTemplate;
    @Value(value="${server.port:8080}")
    private int serverPort;
    private String utxoStoreBaseUrl;

    public UtxoClientImpl(RestTemplate restTemplate, String utxoStoreBaseUrl) {
        this.restTemplate = restTemplate;
        this.utxoStoreBaseUrl = utxoStoreBaseUrl;
        log.info("Enabled Remote UtxoClient >>>>>>>> " + utxoStoreBaseUrl);
    }

    @Override
    public List<AddressUtxo> getUtxosByIds(List<UtxoKey> utxoIds) {
        String url = this.getBaseUrl() + "/utxos";
        AddressUtxo[] utxos = (AddressUtxo[])this.restTemplate.postForObject(url, utxoIds, AddressUtxo[].class, new Object[0]);
        return Arrays.asList(utxos);
    }

    @Override
    public Optional<AddressUtxo> getUtxoById(UtxoKey utxoId) {
        String url = this.getBaseUrl() + "/utxos/" + utxoId.getTxHash() + "/" + utxoId.getOutputIndex();
        AddressUtxo utxo = (AddressUtxo)this.restTemplate.getForObject(url, AddressUtxo.class, new Object[0]);
        return Optional.ofNullable(utxo);
    }

    @Override
    public List<Utxo> getUtxoByAddress(String address, int page, int count) {
        String url = this.getBaseUrl() + "/addresses/" + address + "/utxos?page=" + page + "&count=" + count;
        Utxo[] utxos = (Utxo[])this.restTemplate.getForObject(url, Utxo[].class, new Object[0]);
        return Arrays.asList(utxos);
    }

    private String getBaseUrl() {
        if (this.utxoStoreBaseUrl == null) {
            this.utxoStoreBaseUrl = "http://localhost:" + this.serverPort + "/api/v1";
        }
        return this.utxoStoreBaseUrl;
    }
}

