/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.math.BigInteger;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Utxo {
    private String txHash;
    private int outputIndex;
    private String address;
    private List<Amount> amount;
    private String dataHash;
    private String inlineDatum;
    private String referenceScriptHash;

    public static UtxoBuilder builder() {
        return new UtxoBuilder();
    }

    public String getTxHash() {
        return this.txHash;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public String getAddress() {
        return this.address;
    }

    public List<Amount> getAmount() {
        return this.amount;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public String getInlineDatum() {
        return this.inlineDatum;
    }

    public String getReferenceScriptHash() {
        return this.referenceScriptHash;
    }

    public Utxo() {
    }

    public Utxo(String txHash, int outputIndex, String address, List<Amount> amount, String dataHash, String inlineDatum, String referenceScriptHash) {
        this.txHash = txHash;
        this.outputIndex = outputIndex;
        this.address = address;
        this.amount = amount;
        this.dataHash = dataHash;
        this.inlineDatum = inlineDatum;
        this.referenceScriptHash = referenceScriptHash;
    }

    public String toString() {
        return "Utxo(txHash=" + this.getTxHash() + ", outputIndex=" + this.getOutputIndex() + ", address=" + this.getAddress() + ", amount=" + this.getAmount() + ", dataHash=" + this.getDataHash() + ", inlineDatum=" + this.getInlineDatum() + ", referenceScriptHash=" + this.getReferenceScriptHash() + ")";
    }

    public static class UtxoBuilder {
        private String txHash;
        private int outputIndex;
        private String address;
        private List<Amount> amount;
        private String dataHash;
        private String inlineDatum;
        private String referenceScriptHash;

        UtxoBuilder() {
        }

        public UtxoBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public UtxoBuilder outputIndex(int outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        public UtxoBuilder address(String address) {
            this.address = address;
            return this;
        }

        public UtxoBuilder amount(List<Amount> amount) {
            this.amount = amount;
            return this;
        }

        public UtxoBuilder dataHash(String dataHash) {
            this.dataHash = dataHash;
            return this;
        }

        public UtxoBuilder inlineDatum(String inlineDatum) {
            this.inlineDatum = inlineDatum;
            return this;
        }

        public UtxoBuilder referenceScriptHash(String referenceScriptHash) {
            this.referenceScriptHash = referenceScriptHash;
            return this;
        }

        public Utxo build() {
            return new Utxo(this.txHash, this.outputIndex, this.address, this.amount, this.dataHash, this.inlineDatum, this.referenceScriptHash);
        }

        public String toString() {
            return "Utxo.UtxoBuilder(txHash=" + this.txHash + ", outputIndex=" + this.outputIndex + ", address=" + this.address + ", amount=" + this.amount + ", dataHash=" + this.dataHash + ", inlineDatum=" + this.inlineDatum + ", referenceScriptHash=" + this.referenceScriptHash + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Amount {
        private String unit;
        private BigInteger quantity;

        public static AmountBuilder builder() {
            return new AmountBuilder();
        }

        public String getUnit() {
            return this.unit;
        }

        public BigInteger getQuantity() {
            return this.quantity;
        }

        public Amount() {
        }

        public Amount(String unit, BigInteger quantity) {
            this.unit = unit;
            this.quantity = quantity;
        }

        public String toString() {
            return "Utxo.Amount(unit=" + this.getUnit() + ", quantity=" + this.getQuantity() + ")";
        }

        public static class AmountBuilder {
            private String unit;
            private BigInteger quantity;

            AmountBuilder() {
            }

            public AmountBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public AmountBuilder quantity(BigInteger quantity) {
                this.quantity = quantity;
                return this;
            }

            public Amount build() {
                return new Amount(this.unit, this.quantity);
            }

            public String toString() {
                return "Utxo.Amount.AmountBuilder(unit=" + this.unit + ", quantity=" + this.quantity + ")";
            }
        }
    }
}

