/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.util;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressType;
import com.bloxbean.cardano.client.exception.AddressRuntimeException;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.yaci.core.util.CborSerializationUtil;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static Optional<Redeemer> deserialize(String cbor) {
        try {
            DataItem di = CborSerializationUtil.deserializeOne((byte[])HexUtil.decodeHexString((String)cbor));
            return Optional.of(Redeemer.deserialize((Array)((Array)di)));
        }
        catch (Exception e) {
            log.error("Error deserializing redeemer : " + cbor);
            return Optional.empty();
        }
    }

    public static Optional<String> getPaymentKeyHash(Address address) {
        byte[] paymentKeyHash;
        AddressType addressType = address.getAddressType();
        byte[] addressBytes = address.getBytes();
        switch (addressType) {
            case Base: 
            case Enterprise: 
            case Ptr: {
                paymentKeyHash = new byte[28];
                System.arraycopy(addressBytes, 1, paymentKeyHash, 0, paymentKeyHash.length);
                break;
            }
            default: {
                log.error("Unsupported address type: " + addressType + ", address=" + address.toBech32());
                return Optional.empty();
            }
        }
        return Optional.of(HexUtil.encodeHexString((byte[])paymentKeyHash));
    }

    public static Optional<String> getStakeKeyHash(Address address) {
        byte[] stakeKeyHash;
        AddressType addressType = address.getAddressType();
        byte[] addressBytes = address.getBytes();
        switch (addressType) {
            case Base: {
                stakeKeyHash = new byte[28];
                System.arraycopy(addressBytes, 29, stakeKeyHash, 0, stakeKeyHash.length);
                break;
            }
            case Enterprise: {
                stakeKeyHash = null;
                break;
            }
            case Reward: {
                stakeKeyHash = new byte[28];
                System.arraycopy(addressBytes, 1, stakeKeyHash, 0, stakeKeyHash.length);
                break;
            }
            case Ptr: {
                stakeKeyHash = new byte[addressBytes.length - 1 - 28];
                System.arraycopy(addressBytes, 29, stakeKeyHash, 0, stakeKeyHash.length);
                break;
            }
            default: {
                throw new AddressRuntimeException("StakeKeyHash can't be found for address type : " + addressType);
            }
        }
        return stakeKeyHash != null ? Optional.of(HexUtil.encodeHexString((byte[])stakeKeyHash)) : Optional.empty();
    }
}

