/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.config;

public class StoreProperties {
    private Long eventPublisherId;
    private boolean syncAutoStart;
    private boolean primaryInstance;
    private String cardanoHost;
    private int cardanoPort;
    private long protocolMagic;
    private String n2cNodeSocketPath;
    private String n2cHost;
    private int n2cPort;
    private long shelleyStartSlot;
    private String shelleyStartBlockhash;
    private long shelleyStartBlock;
    private String submitApiUrl;
    private String ogmiosUrl;
    private String mempoolMonitoringEnabled;
    private long syncStartSlot;
    private String syncStartBlockhash;
    private long syncStartByronBlockNumber;
    private long syncStopSlot;
    private String syncStopBlockhash;
    private String byronGenesisFile;
    private String shelleyGenesisFile;
    private String alonzoGenesisFile;
    private String conwayGenesisFile;
    private int blockDiffToStartSyncProtocol;
    private int cursorNoOfBlocksToKeep;
    private int cursorCleanupInterval;
    private int keepAliveInterval = 10000;
    private String defaultGenesisHash = "Genesis";
    private boolean mainnet;
    private int blockProcessingThreads;
    private int eventProcessingThreads;
    private boolean enableParallelProcessing;
    private int blocksBatchSize;
    private int blocksPartitionSize;
    private boolean useVirtualThreadForBatchProcessing;
    private boolean useVirtualThreadForEventProcessing;
    private int dbBatchSize = 200;
    private boolean dbParallelInsert = true;
    private boolean mvstoreEnabled;
    private String mvstorePath;
    private int processingThreadsTimeout;
    private boolean parallelWrite;
    private int writeThreadDefaultBatchSize;
    private int jooqWriteBatchSize;
    private int writeThreadCount;

    private static int $default$blockDiffToStartSyncProtocol() {
        return 2000;
    }

    private static int $default$cursorNoOfBlocksToKeep() {
        return 2160;
    }

    private static int $default$cursorCleanupInterval() {
        return 3600;
    }

    private static int $default$blockProcessingThreads() {
        return 15;
    }

    private static int $default$eventProcessingThreads() {
        return 30;
    }

    private static int $default$blocksBatchSize() {
        return 100;
    }

    private static int $default$blocksPartitionSize() {
        return 15;
    }

    private static boolean $default$mvstoreEnabled() {
        return false;
    }

    private static String $default$mvstorePath() {
        return "./.mvstore";
    }

    private static int $default$processingThreadsTimeout() {
        return 5;
    }

    private static boolean $default$parallelWrite() {
        return false;
    }

    private static int $default$writeThreadDefaultBatchSize() {
        return 1000;
    }

    private static int $default$jooqWriteBatchSize() {
        return 3000;
    }

    private static int $default$writeThreadCount() {
        return 5;
    }

    public static StorePropertiesBuilder builder() {
        return new StorePropertiesBuilder();
    }

    public Long getEventPublisherId() {
        return this.eventPublisherId;
    }

    public boolean isSyncAutoStart() {
        return this.syncAutoStart;
    }

    public boolean isPrimaryInstance() {
        return this.primaryInstance;
    }

    public String getCardanoHost() {
        return this.cardanoHost;
    }

    public int getCardanoPort() {
        return this.cardanoPort;
    }

    public long getProtocolMagic() {
        return this.protocolMagic;
    }

    public String getN2cNodeSocketPath() {
        return this.n2cNodeSocketPath;
    }

    public String getN2cHost() {
        return this.n2cHost;
    }

    public int getN2cPort() {
        return this.n2cPort;
    }

    public long getShelleyStartSlot() {
        return this.shelleyStartSlot;
    }

    public String getShelleyStartBlockhash() {
        return this.shelleyStartBlockhash;
    }

    public long getShelleyStartBlock() {
        return this.shelleyStartBlock;
    }

    public String getSubmitApiUrl() {
        return this.submitApiUrl;
    }

    public String getOgmiosUrl() {
        return this.ogmiosUrl;
    }

    public String getMempoolMonitoringEnabled() {
        return this.mempoolMonitoringEnabled;
    }

    public long getSyncStartSlot() {
        return this.syncStartSlot;
    }

    public String getSyncStartBlockhash() {
        return this.syncStartBlockhash;
    }

    public long getSyncStartByronBlockNumber() {
        return this.syncStartByronBlockNumber;
    }

    public long getSyncStopSlot() {
        return this.syncStopSlot;
    }

    public String getSyncStopBlockhash() {
        return this.syncStopBlockhash;
    }

    public String getByronGenesisFile() {
        return this.byronGenesisFile;
    }

    public String getShelleyGenesisFile() {
        return this.shelleyGenesisFile;
    }

    public String getAlonzoGenesisFile() {
        return this.alonzoGenesisFile;
    }

    public String getConwayGenesisFile() {
        return this.conwayGenesisFile;
    }

    public int getBlockDiffToStartSyncProtocol() {
        return this.blockDiffToStartSyncProtocol;
    }

    public int getCursorNoOfBlocksToKeep() {
        return this.cursorNoOfBlocksToKeep;
    }

    public int getCursorCleanupInterval() {
        return this.cursorCleanupInterval;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getDefaultGenesisHash() {
        return this.defaultGenesisHash;
    }

    public boolean isMainnet() {
        return this.mainnet;
    }

    public int getBlockProcessingThreads() {
        return this.blockProcessingThreads;
    }

    public int getEventProcessingThreads() {
        return this.eventProcessingThreads;
    }

    public boolean isEnableParallelProcessing() {
        return this.enableParallelProcessing;
    }

    public int getBlocksBatchSize() {
        return this.blocksBatchSize;
    }

    public int getBlocksPartitionSize() {
        return this.blocksPartitionSize;
    }

    public boolean isUseVirtualThreadForBatchProcessing() {
        return this.useVirtualThreadForBatchProcessing;
    }

    public boolean isUseVirtualThreadForEventProcessing() {
        return this.useVirtualThreadForEventProcessing;
    }

    public int getDbBatchSize() {
        return this.dbBatchSize;
    }

    public boolean isDbParallelInsert() {
        return this.dbParallelInsert;
    }

    public boolean isMvstoreEnabled() {
        return this.mvstoreEnabled;
    }

    public String getMvstorePath() {
        return this.mvstorePath;
    }

    public int getProcessingThreadsTimeout() {
        return this.processingThreadsTimeout;
    }

    public boolean isParallelWrite() {
        return this.parallelWrite;
    }

    public int getWriteThreadDefaultBatchSize() {
        return this.writeThreadDefaultBatchSize;
    }

    public int getJooqWriteBatchSize() {
        return this.jooqWriteBatchSize;
    }

    public int getWriteThreadCount() {
        return this.writeThreadCount;
    }

    public void setEventPublisherId(Long eventPublisherId) {
        this.eventPublisherId = eventPublisherId;
    }

    public void setSyncAutoStart(boolean syncAutoStart) {
        this.syncAutoStart = syncAutoStart;
    }

    public void setPrimaryInstance(boolean primaryInstance) {
        this.primaryInstance = primaryInstance;
    }

    public void setCardanoHost(String cardanoHost) {
        this.cardanoHost = cardanoHost;
    }

    public void setCardanoPort(int cardanoPort) {
        this.cardanoPort = cardanoPort;
    }

    public void setProtocolMagic(long protocolMagic) {
        this.protocolMagic = protocolMagic;
    }

    public void setN2cNodeSocketPath(String n2cNodeSocketPath) {
        this.n2cNodeSocketPath = n2cNodeSocketPath;
    }

    public void setN2cHost(String n2cHost) {
        this.n2cHost = n2cHost;
    }

    public void setN2cPort(int n2cPort) {
        this.n2cPort = n2cPort;
    }

    public void setShelleyStartSlot(long shelleyStartSlot) {
        this.shelleyStartSlot = shelleyStartSlot;
    }

    public void setShelleyStartBlockhash(String shelleyStartBlockhash) {
        this.shelleyStartBlockhash = shelleyStartBlockhash;
    }

    public void setShelleyStartBlock(long shelleyStartBlock) {
        this.shelleyStartBlock = shelleyStartBlock;
    }

    public void setSubmitApiUrl(String submitApiUrl) {
        this.submitApiUrl = submitApiUrl;
    }

    public void setOgmiosUrl(String ogmiosUrl) {
        this.ogmiosUrl = ogmiosUrl;
    }

    public void setMempoolMonitoringEnabled(String mempoolMonitoringEnabled) {
        this.mempoolMonitoringEnabled = mempoolMonitoringEnabled;
    }

    public void setSyncStartSlot(long syncStartSlot) {
        this.syncStartSlot = syncStartSlot;
    }

    public void setSyncStartBlockhash(String syncStartBlockhash) {
        this.syncStartBlockhash = syncStartBlockhash;
    }

    public void setSyncStartByronBlockNumber(long syncStartByronBlockNumber) {
        this.syncStartByronBlockNumber = syncStartByronBlockNumber;
    }

    public void setSyncStopSlot(long syncStopSlot) {
        this.syncStopSlot = syncStopSlot;
    }

    public void setSyncStopBlockhash(String syncStopBlockhash) {
        this.syncStopBlockhash = syncStopBlockhash;
    }

    public void setByronGenesisFile(String byronGenesisFile) {
        this.byronGenesisFile = byronGenesisFile;
    }

    public void setShelleyGenesisFile(String shelleyGenesisFile) {
        this.shelleyGenesisFile = shelleyGenesisFile;
    }

    public void setAlonzoGenesisFile(String alonzoGenesisFile) {
        this.alonzoGenesisFile = alonzoGenesisFile;
    }

    public void setConwayGenesisFile(String conwayGenesisFile) {
        this.conwayGenesisFile = conwayGenesisFile;
    }

    public void setBlockDiffToStartSyncProtocol(int blockDiffToStartSyncProtocol) {
        this.blockDiffToStartSyncProtocol = blockDiffToStartSyncProtocol;
    }

    public void setCursorNoOfBlocksToKeep(int cursorNoOfBlocksToKeep) {
        this.cursorNoOfBlocksToKeep = cursorNoOfBlocksToKeep;
    }

    public void setCursorCleanupInterval(int cursorCleanupInterval) {
        this.cursorCleanupInterval = cursorCleanupInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public void setDefaultGenesisHash(String defaultGenesisHash) {
        this.defaultGenesisHash = defaultGenesisHash;
    }

    public void setMainnet(boolean mainnet) {
        this.mainnet = mainnet;
    }

    public void setBlockProcessingThreads(int blockProcessingThreads) {
        this.blockProcessingThreads = blockProcessingThreads;
    }

    public void setEventProcessingThreads(int eventProcessingThreads) {
        this.eventProcessingThreads = eventProcessingThreads;
    }

    public void setEnableParallelProcessing(boolean enableParallelProcessing) {
        this.enableParallelProcessing = enableParallelProcessing;
    }

    public void setBlocksBatchSize(int blocksBatchSize) {
        this.blocksBatchSize = blocksBatchSize;
    }

    public void setBlocksPartitionSize(int blocksPartitionSize) {
        this.blocksPartitionSize = blocksPartitionSize;
    }

    public void setUseVirtualThreadForBatchProcessing(boolean useVirtualThreadForBatchProcessing) {
        this.useVirtualThreadForBatchProcessing = useVirtualThreadForBatchProcessing;
    }

    public void setUseVirtualThreadForEventProcessing(boolean useVirtualThreadForEventProcessing) {
        this.useVirtualThreadForEventProcessing = useVirtualThreadForEventProcessing;
    }

    public void setDbBatchSize(int dbBatchSize) {
        this.dbBatchSize = dbBatchSize;
    }

    public void setDbParallelInsert(boolean dbParallelInsert) {
        this.dbParallelInsert = dbParallelInsert;
    }

    public void setMvstoreEnabled(boolean mvstoreEnabled) {
        this.mvstoreEnabled = mvstoreEnabled;
    }

    public void setMvstorePath(String mvstorePath) {
        this.mvstorePath = mvstorePath;
    }

    public void setProcessingThreadsTimeout(int processingThreadsTimeout) {
        this.processingThreadsTimeout = processingThreadsTimeout;
    }

    public void setParallelWrite(boolean parallelWrite) {
        this.parallelWrite = parallelWrite;
    }

    public void setWriteThreadDefaultBatchSize(int writeThreadDefaultBatchSize) {
        this.writeThreadDefaultBatchSize = writeThreadDefaultBatchSize;
    }

    public void setJooqWriteBatchSize(int jooqWriteBatchSize) {
        this.jooqWriteBatchSize = jooqWriteBatchSize;
    }

    public void setWriteThreadCount(int writeThreadCount) {
        this.writeThreadCount = writeThreadCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoreProperties)) {
            return false;
        }
        StoreProperties other = (StoreProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSyncAutoStart() != other.isSyncAutoStart()) {
            return false;
        }
        if (this.isPrimaryInstance() != other.isPrimaryInstance()) {
            return false;
        }
        if (this.getCardanoPort() != other.getCardanoPort()) {
            return false;
        }
        if (this.getProtocolMagic() != other.getProtocolMagic()) {
            return false;
        }
        if (this.getN2cPort() != other.getN2cPort()) {
            return false;
        }
        if (this.getShelleyStartSlot() != other.getShelleyStartSlot()) {
            return false;
        }
        if (this.getShelleyStartBlock() != other.getShelleyStartBlock()) {
            return false;
        }
        if (this.getSyncStartSlot() != other.getSyncStartSlot()) {
            return false;
        }
        if (this.getSyncStartByronBlockNumber() != other.getSyncStartByronBlockNumber()) {
            return false;
        }
        if (this.getSyncStopSlot() != other.getSyncStopSlot()) {
            return false;
        }
        if (this.getBlockDiffToStartSyncProtocol() != other.getBlockDiffToStartSyncProtocol()) {
            return false;
        }
        if (this.getCursorNoOfBlocksToKeep() != other.getCursorNoOfBlocksToKeep()) {
            return false;
        }
        if (this.getCursorCleanupInterval() != other.getCursorCleanupInterval()) {
            return false;
        }
        if (this.getKeepAliveInterval() != other.getKeepAliveInterval()) {
            return false;
        }
        if (this.isMainnet() != other.isMainnet()) {
            return false;
        }
        if (this.getBlockProcessingThreads() != other.getBlockProcessingThreads()) {
            return false;
        }
        if (this.getEventProcessingThreads() != other.getEventProcessingThreads()) {
            return false;
        }
        if (this.isEnableParallelProcessing() != other.isEnableParallelProcessing()) {
            return false;
        }
        if (this.getBlocksBatchSize() != other.getBlocksBatchSize()) {
            return false;
        }
        if (this.getBlocksPartitionSize() != other.getBlocksPartitionSize()) {
            return false;
        }
        if (this.isUseVirtualThreadForBatchProcessing() != other.isUseVirtualThreadForBatchProcessing()) {
            return false;
        }
        if (this.isUseVirtualThreadForEventProcessing() != other.isUseVirtualThreadForEventProcessing()) {
            return false;
        }
        if (this.getDbBatchSize() != other.getDbBatchSize()) {
            return false;
        }
        if (this.isDbParallelInsert() != other.isDbParallelInsert()) {
            return false;
        }
        if (this.isMvstoreEnabled() != other.isMvstoreEnabled()) {
            return false;
        }
        if (this.getProcessingThreadsTimeout() != other.getProcessingThreadsTimeout()) {
            return false;
        }
        if (this.isParallelWrite() != other.isParallelWrite()) {
            return false;
        }
        if (this.getWriteThreadDefaultBatchSize() != other.getWriteThreadDefaultBatchSize()) {
            return false;
        }
        if (this.getJooqWriteBatchSize() != other.getJooqWriteBatchSize()) {
            return false;
        }
        if (this.getWriteThreadCount() != other.getWriteThreadCount()) {
            return false;
        }
        Long this$eventPublisherId = this.getEventPublisherId();
        Long other$eventPublisherId = other.getEventPublisherId();
        if (this$eventPublisherId == null ? other$eventPublisherId != null : !((Object)this$eventPublisherId).equals(other$eventPublisherId)) {
            return false;
        }
        String this$cardanoHost = this.getCardanoHost();
        String other$cardanoHost = other.getCardanoHost();
        if (this$cardanoHost == null ? other$cardanoHost != null : !this$cardanoHost.equals(other$cardanoHost)) {
            return false;
        }
        String this$n2cNodeSocketPath = this.getN2cNodeSocketPath();
        String other$n2cNodeSocketPath = other.getN2cNodeSocketPath();
        if (this$n2cNodeSocketPath == null ? other$n2cNodeSocketPath != null : !this$n2cNodeSocketPath.equals(other$n2cNodeSocketPath)) {
            return false;
        }
        String this$n2cHost = this.getN2cHost();
        String other$n2cHost = other.getN2cHost();
        if (this$n2cHost == null ? other$n2cHost != null : !this$n2cHost.equals(other$n2cHost)) {
            return false;
        }
        String this$shelleyStartBlockhash = this.getShelleyStartBlockhash();
        String other$shelleyStartBlockhash = other.getShelleyStartBlockhash();
        if (this$shelleyStartBlockhash == null ? other$shelleyStartBlockhash != null : !this$shelleyStartBlockhash.equals(other$shelleyStartBlockhash)) {
            return false;
        }
        String this$submitApiUrl = this.getSubmitApiUrl();
        String other$submitApiUrl = other.getSubmitApiUrl();
        if (this$submitApiUrl == null ? other$submitApiUrl != null : !this$submitApiUrl.equals(other$submitApiUrl)) {
            return false;
        }
        String this$ogmiosUrl = this.getOgmiosUrl();
        String other$ogmiosUrl = other.getOgmiosUrl();
        if (this$ogmiosUrl == null ? other$ogmiosUrl != null : !this$ogmiosUrl.equals(other$ogmiosUrl)) {
            return false;
        }
        String this$mempoolMonitoringEnabled = this.getMempoolMonitoringEnabled();
        String other$mempoolMonitoringEnabled = other.getMempoolMonitoringEnabled();
        if (this$mempoolMonitoringEnabled == null ? other$mempoolMonitoringEnabled != null : !this$mempoolMonitoringEnabled.equals(other$mempoolMonitoringEnabled)) {
            return false;
        }
        String this$syncStartBlockhash = this.getSyncStartBlockhash();
        String other$syncStartBlockhash = other.getSyncStartBlockhash();
        if (this$syncStartBlockhash == null ? other$syncStartBlockhash != null : !this$syncStartBlockhash.equals(other$syncStartBlockhash)) {
            return false;
        }
        String this$syncStopBlockhash = this.getSyncStopBlockhash();
        String other$syncStopBlockhash = other.getSyncStopBlockhash();
        if (this$syncStopBlockhash == null ? other$syncStopBlockhash != null : !this$syncStopBlockhash.equals(other$syncStopBlockhash)) {
            return false;
        }
        String this$byronGenesisFile = this.getByronGenesisFile();
        String other$byronGenesisFile = other.getByronGenesisFile();
        if (this$byronGenesisFile == null ? other$byronGenesisFile != null : !this$byronGenesisFile.equals(other$byronGenesisFile)) {
            return false;
        }
        String this$shelleyGenesisFile = this.getShelleyGenesisFile();
        String other$shelleyGenesisFile = other.getShelleyGenesisFile();
        if (this$shelleyGenesisFile == null ? other$shelleyGenesisFile != null : !this$shelleyGenesisFile.equals(other$shelleyGenesisFile)) {
            return false;
        }
        String this$alonzoGenesisFile = this.getAlonzoGenesisFile();
        String other$alonzoGenesisFile = other.getAlonzoGenesisFile();
        if (this$alonzoGenesisFile == null ? other$alonzoGenesisFile != null : !this$alonzoGenesisFile.equals(other$alonzoGenesisFile)) {
            return false;
        }
        String this$conwayGenesisFile = this.getConwayGenesisFile();
        String other$conwayGenesisFile = other.getConwayGenesisFile();
        if (this$conwayGenesisFile == null ? other$conwayGenesisFile != null : !this$conwayGenesisFile.equals(other$conwayGenesisFile)) {
            return false;
        }
        String this$defaultGenesisHash = this.getDefaultGenesisHash();
        String other$defaultGenesisHash = other.getDefaultGenesisHash();
        if (this$defaultGenesisHash == null ? other$defaultGenesisHash != null : !this$defaultGenesisHash.equals(other$defaultGenesisHash)) {
            return false;
        }
        String this$mvstorePath = this.getMvstorePath();
        String other$mvstorePath = other.getMvstorePath();
        return !(this$mvstorePath == null ? other$mvstorePath != null : !this$mvstorePath.equals(other$mvstorePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoreProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSyncAutoStart() ? 79 : 97);
        result = result * 59 + (this.isPrimaryInstance() ? 79 : 97);
        result = result * 59 + this.getCardanoPort();
        long $protocolMagic = this.getProtocolMagic();
        result = result * 59 + (int)($protocolMagic >>> 32 ^ $protocolMagic);
        result = result * 59 + this.getN2cPort();
        long $shelleyStartSlot = this.getShelleyStartSlot();
        result = result * 59 + (int)($shelleyStartSlot >>> 32 ^ $shelleyStartSlot);
        long $shelleyStartBlock = this.getShelleyStartBlock();
        result = result * 59 + (int)($shelleyStartBlock >>> 32 ^ $shelleyStartBlock);
        long $syncStartSlot = this.getSyncStartSlot();
        result = result * 59 + (int)($syncStartSlot >>> 32 ^ $syncStartSlot);
        long $syncStartByronBlockNumber = this.getSyncStartByronBlockNumber();
        result = result * 59 + (int)($syncStartByronBlockNumber >>> 32 ^ $syncStartByronBlockNumber);
        long $syncStopSlot = this.getSyncStopSlot();
        result = result * 59 + (int)($syncStopSlot >>> 32 ^ $syncStopSlot);
        result = result * 59 + this.getBlockDiffToStartSyncProtocol();
        result = result * 59 + this.getCursorNoOfBlocksToKeep();
        result = result * 59 + this.getCursorCleanupInterval();
        result = result * 59 + this.getKeepAliveInterval();
        result = result * 59 + (this.isMainnet() ? 79 : 97);
        result = result * 59 + this.getBlockProcessingThreads();
        result = result * 59 + this.getEventProcessingThreads();
        result = result * 59 + (this.isEnableParallelProcessing() ? 79 : 97);
        result = result * 59 + this.getBlocksBatchSize();
        result = result * 59 + this.getBlocksPartitionSize();
        result = result * 59 + (this.isUseVirtualThreadForBatchProcessing() ? 79 : 97);
        result = result * 59 + (this.isUseVirtualThreadForEventProcessing() ? 79 : 97);
        result = result * 59 + this.getDbBatchSize();
        result = result * 59 + (this.isDbParallelInsert() ? 79 : 97);
        result = result * 59 + (this.isMvstoreEnabled() ? 79 : 97);
        result = result * 59 + this.getProcessingThreadsTimeout();
        result = result * 59 + (this.isParallelWrite() ? 79 : 97);
        result = result * 59 + this.getWriteThreadDefaultBatchSize();
        result = result * 59 + this.getJooqWriteBatchSize();
        result = result * 59 + this.getWriteThreadCount();
        Long $eventPublisherId = this.getEventPublisherId();
        result = result * 59 + ($eventPublisherId == null ? 43 : ((Object)$eventPublisherId).hashCode());
        String $cardanoHost = this.getCardanoHost();
        result = result * 59 + ($cardanoHost == null ? 43 : $cardanoHost.hashCode());
        String $n2cNodeSocketPath = this.getN2cNodeSocketPath();
        result = result * 59 + ($n2cNodeSocketPath == null ? 43 : $n2cNodeSocketPath.hashCode());
        String $n2cHost = this.getN2cHost();
        result = result * 59 + ($n2cHost == null ? 43 : $n2cHost.hashCode());
        String $shelleyStartBlockhash = this.getShelleyStartBlockhash();
        result = result * 59 + ($shelleyStartBlockhash == null ? 43 : $shelleyStartBlockhash.hashCode());
        String $submitApiUrl = this.getSubmitApiUrl();
        result = result * 59 + ($submitApiUrl == null ? 43 : $submitApiUrl.hashCode());
        String $ogmiosUrl = this.getOgmiosUrl();
        result = result * 59 + ($ogmiosUrl == null ? 43 : $ogmiosUrl.hashCode());
        String $mempoolMonitoringEnabled = this.getMempoolMonitoringEnabled();
        result = result * 59 + ($mempoolMonitoringEnabled == null ? 43 : $mempoolMonitoringEnabled.hashCode());
        String $syncStartBlockhash = this.getSyncStartBlockhash();
        result = result * 59 + ($syncStartBlockhash == null ? 43 : $syncStartBlockhash.hashCode());
        String $syncStopBlockhash = this.getSyncStopBlockhash();
        result = result * 59 + ($syncStopBlockhash == null ? 43 : $syncStopBlockhash.hashCode());
        String $byronGenesisFile = this.getByronGenesisFile();
        result = result * 59 + ($byronGenesisFile == null ? 43 : $byronGenesisFile.hashCode());
        String $shelleyGenesisFile = this.getShelleyGenesisFile();
        result = result * 59 + ($shelleyGenesisFile == null ? 43 : $shelleyGenesisFile.hashCode());
        String $alonzoGenesisFile = this.getAlonzoGenesisFile();
        result = result * 59 + ($alonzoGenesisFile == null ? 43 : $alonzoGenesisFile.hashCode());
        String $conwayGenesisFile = this.getConwayGenesisFile();
        result = result * 59 + ($conwayGenesisFile == null ? 43 : $conwayGenesisFile.hashCode());
        String $defaultGenesisHash = this.getDefaultGenesisHash();
        result = result * 59 + ($defaultGenesisHash == null ? 43 : $defaultGenesisHash.hashCode());
        String $mvstorePath = this.getMvstorePath();
        result = result * 59 + ($mvstorePath == null ? 43 : $mvstorePath.hashCode());
        return result;
    }

    public String toString() {
        return "StoreProperties(eventPublisherId=" + this.getEventPublisherId() + ", syncAutoStart=" + this.isSyncAutoStart() + ", primaryInstance=" + this.isPrimaryInstance() + ", cardanoHost=" + this.getCardanoHost() + ", cardanoPort=" + this.getCardanoPort() + ", protocolMagic=" + this.getProtocolMagic() + ", n2cNodeSocketPath=" + this.getN2cNodeSocketPath() + ", n2cHost=" + this.getN2cHost() + ", n2cPort=" + this.getN2cPort() + ", shelleyStartSlot=" + this.getShelleyStartSlot() + ", shelleyStartBlockhash=" + this.getShelleyStartBlockhash() + ", shelleyStartBlock=" + this.getShelleyStartBlock() + ", submitApiUrl=" + this.getSubmitApiUrl() + ", ogmiosUrl=" + this.getOgmiosUrl() + ", mempoolMonitoringEnabled=" + this.getMempoolMonitoringEnabled() + ", syncStartSlot=" + this.getSyncStartSlot() + ", syncStartBlockhash=" + this.getSyncStartBlockhash() + ", syncStartByronBlockNumber=" + this.getSyncStartByronBlockNumber() + ", syncStopSlot=" + this.getSyncStopSlot() + ", syncStopBlockhash=" + this.getSyncStopBlockhash() + ", byronGenesisFile=" + this.getByronGenesisFile() + ", shelleyGenesisFile=" + this.getShelleyGenesisFile() + ", alonzoGenesisFile=" + this.getAlonzoGenesisFile() + ", conwayGenesisFile=" + this.getConwayGenesisFile() + ", blockDiffToStartSyncProtocol=" + this.getBlockDiffToStartSyncProtocol() + ", cursorNoOfBlocksToKeep=" + this.getCursorNoOfBlocksToKeep() + ", cursorCleanupInterval=" + this.getCursorCleanupInterval() + ", keepAliveInterval=" + this.getKeepAliveInterval() + ", defaultGenesisHash=" + this.getDefaultGenesisHash() + ", mainnet=" + this.isMainnet() + ", blockProcessingThreads=" + this.getBlockProcessingThreads() + ", eventProcessingThreads=" + this.getEventProcessingThreads() + ", enableParallelProcessing=" + this.isEnableParallelProcessing() + ", blocksBatchSize=" + this.getBlocksBatchSize() + ", blocksPartitionSize=" + this.getBlocksPartitionSize() + ", useVirtualThreadForBatchProcessing=" + this.isUseVirtualThreadForBatchProcessing() + ", useVirtualThreadForEventProcessing=" + this.isUseVirtualThreadForEventProcessing() + ", dbBatchSize=" + this.getDbBatchSize() + ", dbParallelInsert=" + this.isDbParallelInsert() + ", mvstoreEnabled=" + this.isMvstoreEnabled() + ", mvstorePath=" + this.getMvstorePath() + ", processingThreadsTimeout=" + this.getProcessingThreadsTimeout() + ", parallelWrite=" + this.isParallelWrite() + ", writeThreadDefaultBatchSize=" + this.getWriteThreadDefaultBatchSize() + ", jooqWriteBatchSize=" + this.getJooqWriteBatchSize() + ", writeThreadCount=" + this.getWriteThreadCount() + ")";
    }

    public StoreProperties(Long eventPublisherId, boolean syncAutoStart, boolean primaryInstance, String cardanoHost, int cardanoPort, long protocolMagic, String n2cNodeSocketPath, String n2cHost, int n2cPort, long shelleyStartSlot, String shelleyStartBlockhash, long shelleyStartBlock, String submitApiUrl, String ogmiosUrl, String mempoolMonitoringEnabled, long syncStartSlot, String syncStartBlockhash, long syncStartByronBlockNumber, long syncStopSlot, String syncStopBlockhash, String byronGenesisFile, String shelleyGenesisFile, String alonzoGenesisFile, String conwayGenesisFile, int blockDiffToStartSyncProtocol, int cursorNoOfBlocksToKeep, int cursorCleanupInterval, int keepAliveInterval, String defaultGenesisHash, boolean mainnet, int blockProcessingThreads, int eventProcessingThreads, boolean enableParallelProcessing, int blocksBatchSize, int blocksPartitionSize, boolean useVirtualThreadForBatchProcessing, boolean useVirtualThreadForEventProcessing, int dbBatchSize, boolean dbParallelInsert, boolean mvstoreEnabled, String mvstorePath, int processingThreadsTimeout, boolean parallelWrite, int writeThreadDefaultBatchSize, int jooqWriteBatchSize, int writeThreadCount) {
        this.eventPublisherId = eventPublisherId;
        this.syncAutoStart = syncAutoStart;
        this.primaryInstance = primaryInstance;
        this.cardanoHost = cardanoHost;
        this.cardanoPort = cardanoPort;
        this.protocolMagic = protocolMagic;
        this.n2cNodeSocketPath = n2cNodeSocketPath;
        this.n2cHost = n2cHost;
        this.n2cPort = n2cPort;
        this.shelleyStartSlot = shelleyStartSlot;
        this.shelleyStartBlockhash = shelleyStartBlockhash;
        this.shelleyStartBlock = shelleyStartBlock;
        this.submitApiUrl = submitApiUrl;
        this.ogmiosUrl = ogmiosUrl;
        this.mempoolMonitoringEnabled = mempoolMonitoringEnabled;
        this.syncStartSlot = syncStartSlot;
        this.syncStartBlockhash = syncStartBlockhash;
        this.syncStartByronBlockNumber = syncStartByronBlockNumber;
        this.syncStopSlot = syncStopSlot;
        this.syncStopBlockhash = syncStopBlockhash;
        this.byronGenesisFile = byronGenesisFile;
        this.shelleyGenesisFile = shelleyGenesisFile;
        this.alonzoGenesisFile = alonzoGenesisFile;
        this.conwayGenesisFile = conwayGenesisFile;
        this.blockDiffToStartSyncProtocol = blockDiffToStartSyncProtocol;
        this.cursorNoOfBlocksToKeep = cursorNoOfBlocksToKeep;
        this.cursorCleanupInterval = cursorCleanupInterval;
        this.keepAliveInterval = keepAliveInterval;
        this.defaultGenesisHash = defaultGenesisHash;
        this.mainnet = mainnet;
        this.blockProcessingThreads = blockProcessingThreads;
        this.eventProcessingThreads = eventProcessingThreads;
        this.enableParallelProcessing = enableParallelProcessing;
        this.blocksBatchSize = blocksBatchSize;
        this.blocksPartitionSize = blocksPartitionSize;
        this.useVirtualThreadForBatchProcessing = useVirtualThreadForBatchProcessing;
        this.useVirtualThreadForEventProcessing = useVirtualThreadForEventProcessing;
        this.dbBatchSize = dbBatchSize;
        this.dbParallelInsert = dbParallelInsert;
        this.mvstoreEnabled = mvstoreEnabled;
        this.mvstorePath = mvstorePath;
        this.processingThreadsTimeout = processingThreadsTimeout;
        this.parallelWrite = parallelWrite;
        this.writeThreadDefaultBatchSize = writeThreadDefaultBatchSize;
        this.jooqWriteBatchSize = jooqWriteBatchSize;
        this.writeThreadCount = writeThreadCount;
    }

    public StoreProperties() {
        this.blockDiffToStartSyncProtocol = StoreProperties.$default$blockDiffToStartSyncProtocol();
        this.cursorNoOfBlocksToKeep = StoreProperties.$default$cursorNoOfBlocksToKeep();
        this.cursorCleanupInterval = StoreProperties.$default$cursorCleanupInterval();
        this.blockProcessingThreads = StoreProperties.$default$blockProcessingThreads();
        this.eventProcessingThreads = StoreProperties.$default$eventProcessingThreads();
        this.blocksBatchSize = StoreProperties.$default$blocksBatchSize();
        this.blocksPartitionSize = StoreProperties.$default$blocksPartitionSize();
        this.mvstoreEnabled = StoreProperties.$default$mvstoreEnabled();
        this.mvstorePath = StoreProperties.$default$mvstorePath();
        this.processingThreadsTimeout = StoreProperties.$default$processingThreadsTimeout();
        this.parallelWrite = StoreProperties.$default$parallelWrite();
        this.writeThreadDefaultBatchSize = StoreProperties.$default$writeThreadDefaultBatchSize();
        this.jooqWriteBatchSize = StoreProperties.$default$jooqWriteBatchSize();
        this.writeThreadCount = StoreProperties.$default$writeThreadCount();
    }

    public static class StorePropertiesBuilder {
        private Long eventPublisherId;
        private boolean syncAutoStart;
        private boolean primaryInstance;
        private String cardanoHost;
        private int cardanoPort;
        private long protocolMagic;
        private String n2cNodeSocketPath;
        private String n2cHost;
        private int n2cPort;
        private long shelleyStartSlot;
        private String shelleyStartBlockhash;
        private long shelleyStartBlock;
        private String submitApiUrl;
        private String ogmiosUrl;
        private String mempoolMonitoringEnabled;
        private long syncStartSlot;
        private String syncStartBlockhash;
        private long syncStartByronBlockNumber;
        private long syncStopSlot;
        private String syncStopBlockhash;
        private String byronGenesisFile;
        private String shelleyGenesisFile;
        private String alonzoGenesisFile;
        private String conwayGenesisFile;
        private boolean blockDiffToStartSyncProtocol$set;
        private int blockDiffToStartSyncProtocol$value;
        private boolean cursorNoOfBlocksToKeep$set;
        private int cursorNoOfBlocksToKeep$value;
        private boolean cursorCleanupInterval$set;
        private int cursorCleanupInterval$value;
        private int keepAliveInterval;
        private String defaultGenesisHash;
        private boolean mainnet;
        private boolean blockProcessingThreads$set;
        private int blockProcessingThreads$value;
        private boolean eventProcessingThreads$set;
        private int eventProcessingThreads$value;
        private boolean enableParallelProcessing;
        private boolean blocksBatchSize$set;
        private int blocksBatchSize$value;
        private boolean blocksPartitionSize$set;
        private int blocksPartitionSize$value;
        private boolean useVirtualThreadForBatchProcessing;
        private boolean useVirtualThreadForEventProcessing;
        private int dbBatchSize;
        private boolean dbParallelInsert;
        private boolean mvstoreEnabled$set;
        private boolean mvstoreEnabled$value;
        private boolean mvstorePath$set;
        private String mvstorePath$value;
        private boolean processingThreadsTimeout$set;
        private int processingThreadsTimeout$value;
        private boolean parallelWrite$set;
        private boolean parallelWrite$value;
        private boolean writeThreadDefaultBatchSize$set;
        private int writeThreadDefaultBatchSize$value;
        private boolean jooqWriteBatchSize$set;
        private int jooqWriteBatchSize$value;
        private boolean writeThreadCount$set;
        private int writeThreadCount$value;

        StorePropertiesBuilder() {
        }

        public StorePropertiesBuilder eventPublisherId(Long eventPublisherId) {
            this.eventPublisherId = eventPublisherId;
            return this;
        }

        public StorePropertiesBuilder syncAutoStart(boolean syncAutoStart) {
            this.syncAutoStart = syncAutoStart;
            return this;
        }

        public StorePropertiesBuilder primaryInstance(boolean primaryInstance) {
            this.primaryInstance = primaryInstance;
            return this;
        }

        public StorePropertiesBuilder cardanoHost(String cardanoHost) {
            this.cardanoHost = cardanoHost;
            return this;
        }

        public StorePropertiesBuilder cardanoPort(int cardanoPort) {
            this.cardanoPort = cardanoPort;
            return this;
        }

        public StorePropertiesBuilder protocolMagic(long protocolMagic) {
            this.protocolMagic = protocolMagic;
            return this;
        }

        public StorePropertiesBuilder n2cNodeSocketPath(String n2cNodeSocketPath) {
            this.n2cNodeSocketPath = n2cNodeSocketPath;
            return this;
        }

        public StorePropertiesBuilder n2cHost(String n2cHost) {
            this.n2cHost = n2cHost;
            return this;
        }

        public StorePropertiesBuilder n2cPort(int n2cPort) {
            this.n2cPort = n2cPort;
            return this;
        }

        public StorePropertiesBuilder shelleyStartSlot(long shelleyStartSlot) {
            this.shelleyStartSlot = shelleyStartSlot;
            return this;
        }

        public StorePropertiesBuilder shelleyStartBlockhash(String shelleyStartBlockhash) {
            this.shelleyStartBlockhash = shelleyStartBlockhash;
            return this;
        }

        public StorePropertiesBuilder shelleyStartBlock(long shelleyStartBlock) {
            this.shelleyStartBlock = shelleyStartBlock;
            return this;
        }

        public StorePropertiesBuilder submitApiUrl(String submitApiUrl) {
            this.submitApiUrl = submitApiUrl;
            return this;
        }

        public StorePropertiesBuilder ogmiosUrl(String ogmiosUrl) {
            this.ogmiosUrl = ogmiosUrl;
            return this;
        }

        public StorePropertiesBuilder mempoolMonitoringEnabled(String mempoolMonitoringEnabled) {
            this.mempoolMonitoringEnabled = mempoolMonitoringEnabled;
            return this;
        }

        public StorePropertiesBuilder syncStartSlot(long syncStartSlot) {
            this.syncStartSlot = syncStartSlot;
            return this;
        }

        public StorePropertiesBuilder syncStartBlockhash(String syncStartBlockhash) {
            this.syncStartBlockhash = syncStartBlockhash;
            return this;
        }

        public StorePropertiesBuilder syncStartByronBlockNumber(long syncStartByronBlockNumber) {
            this.syncStartByronBlockNumber = syncStartByronBlockNumber;
            return this;
        }

        public StorePropertiesBuilder syncStopSlot(long syncStopSlot) {
            this.syncStopSlot = syncStopSlot;
            return this;
        }

        public StorePropertiesBuilder syncStopBlockhash(String syncStopBlockhash) {
            this.syncStopBlockhash = syncStopBlockhash;
            return this;
        }

        public StorePropertiesBuilder byronGenesisFile(String byronGenesisFile) {
            this.byronGenesisFile = byronGenesisFile;
            return this;
        }

        public StorePropertiesBuilder shelleyGenesisFile(String shelleyGenesisFile) {
            this.shelleyGenesisFile = shelleyGenesisFile;
            return this;
        }

        public StorePropertiesBuilder alonzoGenesisFile(String alonzoGenesisFile) {
            this.alonzoGenesisFile = alonzoGenesisFile;
            return this;
        }

        public StorePropertiesBuilder conwayGenesisFile(String conwayGenesisFile) {
            this.conwayGenesisFile = conwayGenesisFile;
            return this;
        }

        public StorePropertiesBuilder blockDiffToStartSyncProtocol(int blockDiffToStartSyncProtocol) {
            this.blockDiffToStartSyncProtocol$value = blockDiffToStartSyncProtocol;
            this.blockDiffToStartSyncProtocol$set = true;
            return this;
        }

        public StorePropertiesBuilder cursorNoOfBlocksToKeep(int cursorNoOfBlocksToKeep) {
            this.cursorNoOfBlocksToKeep$value = cursorNoOfBlocksToKeep;
            this.cursorNoOfBlocksToKeep$set = true;
            return this;
        }

        public StorePropertiesBuilder cursorCleanupInterval(int cursorCleanupInterval) {
            this.cursorCleanupInterval$value = cursorCleanupInterval;
            this.cursorCleanupInterval$set = true;
            return this;
        }

        public StorePropertiesBuilder keepAliveInterval(int keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        public StorePropertiesBuilder defaultGenesisHash(String defaultGenesisHash) {
            this.defaultGenesisHash = defaultGenesisHash;
            return this;
        }

        public StorePropertiesBuilder mainnet(boolean mainnet) {
            this.mainnet = mainnet;
            return this;
        }

        public StorePropertiesBuilder blockProcessingThreads(int blockProcessingThreads) {
            this.blockProcessingThreads$value = blockProcessingThreads;
            this.blockProcessingThreads$set = true;
            return this;
        }

        public StorePropertiesBuilder eventProcessingThreads(int eventProcessingThreads) {
            this.eventProcessingThreads$value = eventProcessingThreads;
            this.eventProcessingThreads$set = true;
            return this;
        }

        public StorePropertiesBuilder enableParallelProcessing(boolean enableParallelProcessing) {
            this.enableParallelProcessing = enableParallelProcessing;
            return this;
        }

        public StorePropertiesBuilder blocksBatchSize(int blocksBatchSize) {
            this.blocksBatchSize$value = blocksBatchSize;
            this.blocksBatchSize$set = true;
            return this;
        }

        public StorePropertiesBuilder blocksPartitionSize(int blocksPartitionSize) {
            this.blocksPartitionSize$value = blocksPartitionSize;
            this.blocksPartitionSize$set = true;
            return this;
        }

        public StorePropertiesBuilder useVirtualThreadForBatchProcessing(boolean useVirtualThreadForBatchProcessing) {
            this.useVirtualThreadForBatchProcessing = useVirtualThreadForBatchProcessing;
            return this;
        }

        public StorePropertiesBuilder useVirtualThreadForEventProcessing(boolean useVirtualThreadForEventProcessing) {
            this.useVirtualThreadForEventProcessing = useVirtualThreadForEventProcessing;
            return this;
        }

        public StorePropertiesBuilder dbBatchSize(int dbBatchSize) {
            this.dbBatchSize = dbBatchSize;
            return this;
        }

        public StorePropertiesBuilder dbParallelInsert(boolean dbParallelInsert) {
            this.dbParallelInsert = dbParallelInsert;
            return this;
        }

        public StorePropertiesBuilder mvstoreEnabled(boolean mvstoreEnabled) {
            this.mvstoreEnabled$value = mvstoreEnabled;
            this.mvstoreEnabled$set = true;
            return this;
        }

        public StorePropertiesBuilder mvstorePath(String mvstorePath) {
            this.mvstorePath$value = mvstorePath;
            this.mvstorePath$set = true;
            return this;
        }

        public StorePropertiesBuilder processingThreadsTimeout(int processingThreadsTimeout) {
            this.processingThreadsTimeout$value = processingThreadsTimeout;
            this.processingThreadsTimeout$set = true;
            return this;
        }

        public StorePropertiesBuilder parallelWrite(boolean parallelWrite) {
            this.parallelWrite$value = parallelWrite;
            this.parallelWrite$set = true;
            return this;
        }

        public StorePropertiesBuilder writeThreadDefaultBatchSize(int writeThreadDefaultBatchSize) {
            this.writeThreadDefaultBatchSize$value = writeThreadDefaultBatchSize;
            this.writeThreadDefaultBatchSize$set = true;
            return this;
        }

        public StorePropertiesBuilder jooqWriteBatchSize(int jooqWriteBatchSize) {
            this.jooqWriteBatchSize$value = jooqWriteBatchSize;
            this.jooqWriteBatchSize$set = true;
            return this;
        }

        public StorePropertiesBuilder writeThreadCount(int writeThreadCount) {
            this.writeThreadCount$value = writeThreadCount;
            this.writeThreadCount$set = true;
            return this;
        }

        public StoreProperties build() {
            int blockDiffToStartSyncProtocol$value = this.blockDiffToStartSyncProtocol$value;
            if (!this.blockDiffToStartSyncProtocol$set) {
                blockDiffToStartSyncProtocol$value = StoreProperties.$default$blockDiffToStartSyncProtocol();
            }
            int cursorNoOfBlocksToKeep$value = this.cursorNoOfBlocksToKeep$value;
            if (!this.cursorNoOfBlocksToKeep$set) {
                cursorNoOfBlocksToKeep$value = StoreProperties.$default$cursorNoOfBlocksToKeep();
            }
            int cursorCleanupInterval$value = this.cursorCleanupInterval$value;
            if (!this.cursorCleanupInterval$set) {
                cursorCleanupInterval$value = StoreProperties.$default$cursorCleanupInterval();
            }
            int blockProcessingThreads$value = this.blockProcessingThreads$value;
            if (!this.blockProcessingThreads$set) {
                blockProcessingThreads$value = StoreProperties.$default$blockProcessingThreads();
            }
            int eventProcessingThreads$value = this.eventProcessingThreads$value;
            if (!this.eventProcessingThreads$set) {
                eventProcessingThreads$value = StoreProperties.$default$eventProcessingThreads();
            }
            int blocksBatchSize$value = this.blocksBatchSize$value;
            if (!this.blocksBatchSize$set) {
                blocksBatchSize$value = StoreProperties.$default$blocksBatchSize();
            }
            int blocksPartitionSize$value = this.blocksPartitionSize$value;
            if (!this.blocksPartitionSize$set) {
                blocksPartitionSize$value = StoreProperties.$default$blocksPartitionSize();
            }
            boolean mvstoreEnabled$value = this.mvstoreEnabled$value;
            if (!this.mvstoreEnabled$set) {
                mvstoreEnabled$value = StoreProperties.$default$mvstoreEnabled();
            }
            String mvstorePath$value = this.mvstorePath$value;
            if (!this.mvstorePath$set) {
                mvstorePath$value = StoreProperties.$default$mvstorePath();
            }
            int processingThreadsTimeout$value = this.processingThreadsTimeout$value;
            if (!this.processingThreadsTimeout$set) {
                processingThreadsTimeout$value = StoreProperties.$default$processingThreadsTimeout();
            }
            boolean parallelWrite$value = this.parallelWrite$value;
            if (!this.parallelWrite$set) {
                parallelWrite$value = StoreProperties.$default$parallelWrite();
            }
            int writeThreadDefaultBatchSize$value = this.writeThreadDefaultBatchSize$value;
            if (!this.writeThreadDefaultBatchSize$set) {
                writeThreadDefaultBatchSize$value = StoreProperties.$default$writeThreadDefaultBatchSize();
            }
            int jooqWriteBatchSize$value = this.jooqWriteBatchSize$value;
            if (!this.jooqWriteBatchSize$set) {
                jooqWriteBatchSize$value = StoreProperties.$default$jooqWriteBatchSize();
            }
            int writeThreadCount$value = this.writeThreadCount$value;
            if (!this.writeThreadCount$set) {
                writeThreadCount$value = StoreProperties.$default$writeThreadCount();
            }
            return new StoreProperties(this.eventPublisherId, this.syncAutoStart, this.primaryInstance, this.cardanoHost, this.cardanoPort, this.protocolMagic, this.n2cNodeSocketPath, this.n2cHost, this.n2cPort, this.shelleyStartSlot, this.shelleyStartBlockhash, this.shelleyStartBlock, this.submitApiUrl, this.ogmiosUrl, this.mempoolMonitoringEnabled, this.syncStartSlot, this.syncStartBlockhash, this.syncStartByronBlockNumber, this.syncStopSlot, this.syncStopBlockhash, this.byronGenesisFile, this.shelleyGenesisFile, this.alonzoGenesisFile, this.conwayGenesisFile, blockDiffToStartSyncProtocol$value, cursorNoOfBlocksToKeep$value, cursorCleanupInterval$value, this.keepAliveInterval, this.defaultGenesisHash, this.mainnet, blockProcessingThreads$value, eventProcessingThreads$value, this.enableParallelProcessing, blocksBatchSize$value, blocksPartitionSize$value, this.useVirtualThreadForBatchProcessing, this.useVirtualThreadForEventProcessing, this.dbBatchSize, this.dbParallelInsert, mvstoreEnabled$value, mvstorePath$value, processingThreadsTimeout$value, parallelWrite$value, writeThreadDefaultBatchSize$value, jooqWriteBatchSize$value, writeThreadCount$value);
        }

        public String toString() {
            return "StoreProperties.StorePropertiesBuilder(eventPublisherId=" + this.eventPublisherId + ", syncAutoStart=" + this.syncAutoStart + ", primaryInstance=" + this.primaryInstance + ", cardanoHost=" + this.cardanoHost + ", cardanoPort=" + this.cardanoPort + ", protocolMagic=" + this.protocolMagic + ", n2cNodeSocketPath=" + this.n2cNodeSocketPath + ", n2cHost=" + this.n2cHost + ", n2cPort=" + this.n2cPort + ", shelleyStartSlot=" + this.shelleyStartSlot + ", shelleyStartBlockhash=" + this.shelleyStartBlockhash + ", shelleyStartBlock=" + this.shelleyStartBlock + ", submitApiUrl=" + this.submitApiUrl + ", ogmiosUrl=" + this.ogmiosUrl + ", mempoolMonitoringEnabled=" + this.mempoolMonitoringEnabled + ", syncStartSlot=" + this.syncStartSlot + ", syncStartBlockhash=" + this.syncStartBlockhash + ", syncStartByronBlockNumber=" + this.syncStartByronBlockNumber + ", syncStopSlot=" + this.syncStopSlot + ", syncStopBlockhash=" + this.syncStopBlockhash + ", byronGenesisFile=" + this.byronGenesisFile + ", shelleyGenesisFile=" + this.shelleyGenesisFile + ", alonzoGenesisFile=" + this.alonzoGenesisFile + ", conwayGenesisFile=" + this.conwayGenesisFile + ", blockDiffToStartSyncProtocol$value=" + this.blockDiffToStartSyncProtocol$value + ", cursorNoOfBlocksToKeep$value=" + this.cursorNoOfBlocksToKeep$value + ", cursorCleanupInterval$value=" + this.cursorCleanupInterval$value + ", keepAliveInterval=" + this.keepAliveInterval + ", defaultGenesisHash=" + this.defaultGenesisHash + ", mainnet=" + this.mainnet + ", blockProcessingThreads$value=" + this.blockProcessingThreads$value + ", eventProcessingThreads$value=" + this.eventProcessingThreads$value + ", enableParallelProcessing=" + this.enableParallelProcessing + ", blocksBatchSize$value=" + this.blocksBatchSize$value + ", blocksPartitionSize$value=" + this.blocksPartitionSize$value + ", useVirtualThreadForBatchProcessing=" + this.useVirtualThreadForBatchProcessing + ", useVirtualThreadForEventProcessing=" + this.useVirtualThreadForEventProcessing + ", dbBatchSize=" + this.dbBatchSize + ", dbParallelInsert=" + this.dbParallelInsert + ", mvstoreEnabled$value=" + this.mvstoreEnabled$value + ", mvstorePath$value=" + this.mvstorePath$value + ", processingThreadsTimeout$value=" + this.processingThreadsTimeout$value + ", parallelWrite$value=" + this.parallelWrite$value + ", writeThreadDefaultBatchSize$value=" + this.writeThreadDefaultBatchSize$value + ", jooqWriteBatchSize$value=" + this.jooqWriteBatchSize$value + ", writeThreadCount$value=" + this.writeThreadCount$value + ")";
        }
    }
}

