/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.domain;

import com.bloxbean.cardano.yaci.core.model.Era;

public class Cursor {
    private Long slot;
    private String blockHash;
    private Long block;
    private String prevBlockHash;
    private Era era;

    public static CursorBuilder builder() {
        return new CursorBuilder();
    }

    public CursorBuilder toBuilder() {
        return new CursorBuilder().slot(this.slot).blockHash(this.blockHash).block(this.block).prevBlockHash(this.prevBlockHash).era(this.era);
    }

    public Long getSlot() {
        return this.slot;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public Long getBlock() {
        return this.block;
    }

    public String getPrevBlockHash() {
        return this.prevBlockHash;
    }

    public Era getEra() {
        return this.era;
    }

    public Cursor() {
    }

    public Cursor(Long slot, String blockHash, Long block, String prevBlockHash, Era era) {
        this.slot = slot;
        this.blockHash = blockHash;
        this.block = block;
        this.prevBlockHash = prevBlockHash;
        this.era = era;
    }

    public String toString() {
        return "Cursor(slot=" + this.getSlot() + ", blockHash=" + this.getBlockHash() + ", block=" + this.getBlock() + ", prevBlockHash=" + this.getPrevBlockHash() + ", era=" + String.valueOf(this.getEra()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cursor)) {
            return false;
        }
        Cursor other = (Cursor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$slot = this.getSlot();
        Long other$slot = other.getSlot();
        if (this$slot == null ? other$slot != null : !((Object)this$slot).equals(other$slot)) {
            return false;
        }
        Long this$block = this.getBlock();
        Long other$block = other.getBlock();
        if (this$block == null ? other$block != null : !((Object)this$block).equals(other$block)) {
            return false;
        }
        String this$blockHash = this.getBlockHash();
        String other$blockHash = other.getBlockHash();
        if (this$blockHash == null ? other$blockHash != null : !this$blockHash.equals(other$blockHash)) {
            return false;
        }
        String this$prevBlockHash = this.getPrevBlockHash();
        String other$prevBlockHash = other.getPrevBlockHash();
        if (this$prevBlockHash == null ? other$prevBlockHash != null : !this$prevBlockHash.equals(other$prevBlockHash)) {
            return false;
        }
        Era this$era = this.getEra();
        Era other$era = other.getEra();
        return !(this$era == null ? other$era != null : !this$era.equals(other$era));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cursor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : ((Object)$slot).hashCode());
        Long $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : ((Object)$block).hashCode());
        String $blockHash = this.getBlockHash();
        result = result * 59 + ($blockHash == null ? 43 : $blockHash.hashCode());
        String $prevBlockHash = this.getPrevBlockHash();
        result = result * 59 + ($prevBlockHash == null ? 43 : $prevBlockHash.hashCode());
        Era $era = this.getEra();
        result = result * 59 + ($era == null ? 43 : $era.hashCode());
        return result;
    }

    public static class CursorBuilder {
        private Long slot;
        private String blockHash;
        private Long block;
        private String prevBlockHash;
        private Era era;

        CursorBuilder() {
        }

        public CursorBuilder slot(Long slot) {
            this.slot = slot;
            return this;
        }

        public CursorBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public CursorBuilder block(Long block) {
            this.block = block;
            return this;
        }

        public CursorBuilder prevBlockHash(String prevBlockHash) {
            this.prevBlockHash = prevBlockHash;
            return this;
        }

        public CursorBuilder era(Era era) {
            this.era = era;
            return this;
        }

        public Cursor build() {
            return new Cursor(this.slot, this.blockHash, this.block, this.prevBlockHash, this.era);
        }

        public String toString() {
            return "Cursor.CursorBuilder(slot=" + this.slot + ", blockHash=" + this.blockHash + ", block=" + this.block + ", prevBlockHash=" + this.prevBlockHash + ", era=" + String.valueOf(this.era) + ")";
        }
    }
}

