/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.domain;

import com.bloxbean.cardano.yaci.store.common.domain.DrepVoteThresholds;
import com.bloxbean.cardano.yaci.store.common.domain.PoolVotingThresholds;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ProtocolParams {
    private Integer minFeeA;
    private Integer minFeeB;
    private Integer maxBlockSize;
    private Integer maxTxSize;
    private Integer maxBlockHeaderSize;
    private BigInteger keyDeposit;
    private BigInteger poolDeposit;
    private Integer maxEpoch;
    @JsonProperty(value="nopt")
    private Integer nOpt;
    private BigDecimal poolPledgeInfluence;
    private BigDecimal expansionRate;
    private BigDecimal treasuryGrowthRate;
    private BigDecimal decentralisationParam;
    private String extraEntropy;
    private Integer protocolMajorVer;
    private Integer protocolMinorVer;
    private BigInteger minUtxo;
    private BigInteger minPoolCost;
    private BigInteger adaPerUtxoByte;
    private Map<String, long[]> costModels;
    private String costModelsHash;
    private BigDecimal priceMem;
    private BigDecimal priceStep;
    private BigInteger maxTxExMem;
    private BigInteger maxTxExSteps;
    private BigInteger maxBlockExMem;
    private BigInteger maxBlockExSteps;
    private Long maxValSize;
    private Integer collateralPercent;
    private Integer maxCollateralInputs;
    private PoolVotingThresholds poolVotingThresholds;
    private DrepVoteThresholds drepVotingThresholds;
    private Integer committeeMinSize;
    private Integer committeeMaxTermLength;
    private Integer govActionLifetime;
    private BigInteger govActionDeposit;
    private BigInteger drepDeposit;
    private Integer drepActivity;
    private BigDecimal minFeeRefScriptCostPerByte;

    public void merge(ProtocolParams other) {
        if (other.minFeeA != null) {
            this.minFeeA = other.minFeeA;
        }
        if (other.minFeeB != null) {
            this.minFeeB = other.minFeeB;
        }
        if (other.maxBlockSize != null) {
            this.maxBlockSize = other.maxBlockSize;
        }
        if (other.maxTxSize != null) {
            this.maxTxSize = other.maxTxSize;
        }
        if (other.maxBlockHeaderSize != null) {
            this.maxBlockHeaderSize = other.maxBlockHeaderSize;
        }
        if (other.keyDeposit != null) {
            this.keyDeposit = other.keyDeposit;
        }
        if (other.poolDeposit != null) {
            this.poolDeposit = other.poolDeposit;
        }
        if (other.maxEpoch != null) {
            this.maxEpoch = other.maxEpoch;
        }
        if (other.nOpt != null) {
            this.nOpt = other.nOpt;
        }
        if (other.poolPledgeInfluence != null) {
            this.poolPledgeInfluence = other.poolPledgeInfluence;
        }
        if (other.expansionRate != null) {
            this.expansionRate = other.expansionRate;
        }
        if (other.treasuryGrowthRate != null) {
            this.treasuryGrowthRate = other.treasuryGrowthRate;
        }
        if (other.decentralisationParam != null) {
            this.decentralisationParam = other.decentralisationParam;
        }
        if (other.extraEntropy != null) {
            this.extraEntropy = other.extraEntropy;
        }
        if (other.protocolMajorVer != null) {
            this.protocolMajorVer = other.protocolMajorVer;
        }
        if (other.protocolMinorVer != null) {
            this.protocolMinorVer = other.protocolMinorVer;
        }
        if (other.minUtxo != null) {
            this.minUtxo = other.minUtxo;
        }
        if (other.minPoolCost != null) {
            this.minPoolCost = other.minPoolCost;
        }
        if (other.adaPerUtxoByte != null) {
            this.adaPerUtxoByte = other.adaPerUtxoByte;
        }
        if (other.costModels != null) {
            if (this.costModels == null) {
                this.costModels = other.getCostModels();
            } else {
                Set<String> keys = other.getCostModels().keySet();
                keys.forEach(key -> this.costModels.put((String)key, other.costModels.get(key)));
            }
        }
        if (other.costModelsHash != null) {
            this.costModelsHash = other.costModelsHash;
        }
        if (other.priceMem != null) {
            this.priceMem = other.priceMem;
        }
        if (other.priceStep != null) {
            this.priceStep = other.priceStep;
        }
        if (other.maxTxExMem != null) {
            this.maxTxExMem = other.maxTxExMem;
        }
        if (other.maxTxExSteps != null) {
            this.maxTxExSteps = other.maxTxExSteps;
        }
        if (other.maxBlockExMem != null) {
            this.maxBlockExMem = other.maxBlockExMem;
        }
        if (other.maxBlockExSteps != null) {
            this.maxBlockExSteps = other.maxBlockExSteps;
        }
        if (other.maxValSize != null) {
            this.maxValSize = other.maxValSize;
        }
        if (other.collateralPercent != null) {
            this.collateralPercent = other.collateralPercent;
        }
        if (other.maxCollateralInputs != null) {
            this.maxCollateralInputs = other.maxCollateralInputs;
        }
        if (other.poolVotingThresholds != null) {
            this.poolVotingThresholds = other.poolVotingThresholds;
        }
        if (other.drepVotingThresholds != null) {
            this.drepVotingThresholds = other.drepVotingThresholds;
        }
        if (other.committeeMinSize != null) {
            this.committeeMinSize = other.committeeMinSize;
        }
        if (other.committeeMaxTermLength != null) {
            this.committeeMaxTermLength = other.committeeMaxTermLength;
        }
        if (other.govActionLifetime != null) {
            this.govActionLifetime = other.govActionLifetime;
        }
        if (other.govActionDeposit != null) {
            this.govActionDeposit = other.govActionDeposit;
        }
        if (other.drepDeposit != null) {
            this.drepDeposit = other.drepDeposit;
        }
        if (other.drepActivity != null) {
            this.drepActivity = other.drepActivity;
        }
        if (other.minFeeRefScriptCostPerByte != null) {
            this.minFeeRefScriptCostPerByte = other.minFeeRefScriptCostPerByte;
        }
    }

    public static ProtocolParamsBuilder builder() {
        return new ProtocolParamsBuilder();
    }

    public Integer getMinFeeA() {
        return this.minFeeA;
    }

    public Integer getMinFeeB() {
        return this.minFeeB;
    }

    public Integer getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public Integer getMaxTxSize() {
        return this.maxTxSize;
    }

    public Integer getMaxBlockHeaderSize() {
        return this.maxBlockHeaderSize;
    }

    public BigInteger getKeyDeposit() {
        return this.keyDeposit;
    }

    public BigInteger getPoolDeposit() {
        return this.poolDeposit;
    }

    public Integer getMaxEpoch() {
        return this.maxEpoch;
    }

    public Integer getNOpt() {
        return this.nOpt;
    }

    public BigDecimal getPoolPledgeInfluence() {
        return this.poolPledgeInfluence;
    }

    public BigDecimal getExpansionRate() {
        return this.expansionRate;
    }

    public BigDecimal getTreasuryGrowthRate() {
        return this.treasuryGrowthRate;
    }

    public BigDecimal getDecentralisationParam() {
        return this.decentralisationParam;
    }

    public String getExtraEntropy() {
        return this.extraEntropy;
    }

    public Integer getProtocolMajorVer() {
        return this.protocolMajorVer;
    }

    public Integer getProtocolMinorVer() {
        return this.protocolMinorVer;
    }

    public BigInteger getMinUtxo() {
        return this.minUtxo;
    }

    public BigInteger getMinPoolCost() {
        return this.minPoolCost;
    }

    public BigInteger getAdaPerUtxoByte() {
        return this.adaPerUtxoByte;
    }

    public Map<String, long[]> getCostModels() {
        return this.costModels;
    }

    public String getCostModelsHash() {
        return this.costModelsHash;
    }

    public BigDecimal getPriceMem() {
        return this.priceMem;
    }

    public BigDecimal getPriceStep() {
        return this.priceStep;
    }

    public BigInteger getMaxTxExMem() {
        return this.maxTxExMem;
    }

    public BigInteger getMaxTxExSteps() {
        return this.maxTxExSteps;
    }

    public BigInteger getMaxBlockExMem() {
        return this.maxBlockExMem;
    }

    public BigInteger getMaxBlockExSteps() {
        return this.maxBlockExSteps;
    }

    public Long getMaxValSize() {
        return this.maxValSize;
    }

    public Integer getCollateralPercent() {
        return this.collateralPercent;
    }

    public Integer getMaxCollateralInputs() {
        return this.maxCollateralInputs;
    }

    public PoolVotingThresholds getPoolVotingThresholds() {
        return this.poolVotingThresholds;
    }

    public DrepVoteThresholds getDrepVotingThresholds() {
        return this.drepVotingThresholds;
    }

    public Integer getCommitteeMinSize() {
        return this.committeeMinSize;
    }

    public Integer getCommitteeMaxTermLength() {
        return this.committeeMaxTermLength;
    }

    public Integer getGovActionLifetime() {
        return this.govActionLifetime;
    }

    public BigInteger getGovActionDeposit() {
        return this.govActionDeposit;
    }

    public BigInteger getDrepDeposit() {
        return this.drepDeposit;
    }

    public Integer getDrepActivity() {
        return this.drepActivity;
    }

    public BigDecimal getMinFeeRefScriptCostPerByte() {
        return this.minFeeRefScriptCostPerByte;
    }

    public void setMinFeeA(Integer minFeeA) {
        this.minFeeA = minFeeA;
    }

    public void setMinFeeB(Integer minFeeB) {
        this.minFeeB = minFeeB;
    }

    public void setMaxBlockSize(Integer maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public void setMaxTxSize(Integer maxTxSize) {
        this.maxTxSize = maxTxSize;
    }

    public void setMaxBlockHeaderSize(Integer maxBlockHeaderSize) {
        this.maxBlockHeaderSize = maxBlockHeaderSize;
    }

    public void setKeyDeposit(BigInteger keyDeposit) {
        this.keyDeposit = keyDeposit;
    }

    public void setPoolDeposit(BigInteger poolDeposit) {
        this.poolDeposit = poolDeposit;
    }

    public void setMaxEpoch(Integer maxEpoch) {
        this.maxEpoch = maxEpoch;
    }

    @JsonProperty(value="nopt")
    public void setNOpt(Integer nOpt) {
        this.nOpt = nOpt;
    }

    public void setPoolPledgeInfluence(BigDecimal poolPledgeInfluence) {
        this.poolPledgeInfluence = poolPledgeInfluence;
    }

    public void setExpansionRate(BigDecimal expansionRate) {
        this.expansionRate = expansionRate;
    }

    public void setTreasuryGrowthRate(BigDecimal treasuryGrowthRate) {
        this.treasuryGrowthRate = treasuryGrowthRate;
    }

    public void setDecentralisationParam(BigDecimal decentralisationParam) {
        this.decentralisationParam = decentralisationParam;
    }

    public void setExtraEntropy(String extraEntropy) {
        this.extraEntropy = extraEntropy;
    }

    public void setProtocolMajorVer(Integer protocolMajorVer) {
        this.protocolMajorVer = protocolMajorVer;
    }

    public void setProtocolMinorVer(Integer protocolMinorVer) {
        this.protocolMinorVer = protocolMinorVer;
    }

    public void setMinUtxo(BigInteger minUtxo) {
        this.minUtxo = minUtxo;
    }

    public void setMinPoolCost(BigInteger minPoolCost) {
        this.minPoolCost = minPoolCost;
    }

    public void setAdaPerUtxoByte(BigInteger adaPerUtxoByte) {
        this.adaPerUtxoByte = adaPerUtxoByte;
    }

    public void setCostModels(Map<String, long[]> costModels) {
        this.costModels = costModels;
    }

    public void setCostModelsHash(String costModelsHash) {
        this.costModelsHash = costModelsHash;
    }

    public void setPriceMem(BigDecimal priceMem) {
        this.priceMem = priceMem;
    }

    public void setPriceStep(BigDecimal priceStep) {
        this.priceStep = priceStep;
    }

    public void setMaxTxExMem(BigInteger maxTxExMem) {
        this.maxTxExMem = maxTxExMem;
    }

    public void setMaxTxExSteps(BigInteger maxTxExSteps) {
        this.maxTxExSteps = maxTxExSteps;
    }

    public void setMaxBlockExMem(BigInteger maxBlockExMem) {
        this.maxBlockExMem = maxBlockExMem;
    }

    public void setMaxBlockExSteps(BigInteger maxBlockExSteps) {
        this.maxBlockExSteps = maxBlockExSteps;
    }

    public void setMaxValSize(Long maxValSize) {
        this.maxValSize = maxValSize;
    }

    public void setCollateralPercent(Integer collateralPercent) {
        this.collateralPercent = collateralPercent;
    }

    public void setMaxCollateralInputs(Integer maxCollateralInputs) {
        this.maxCollateralInputs = maxCollateralInputs;
    }

    public void setPoolVotingThresholds(PoolVotingThresholds poolVotingThresholds) {
        this.poolVotingThresholds = poolVotingThresholds;
    }

    public void setDrepVotingThresholds(DrepVoteThresholds drepVotingThresholds) {
        this.drepVotingThresholds = drepVotingThresholds;
    }

    public void setCommitteeMinSize(Integer committeeMinSize) {
        this.committeeMinSize = committeeMinSize;
    }

    public void setCommitteeMaxTermLength(Integer committeeMaxTermLength) {
        this.committeeMaxTermLength = committeeMaxTermLength;
    }

    public void setGovActionLifetime(Integer govActionLifetime) {
        this.govActionLifetime = govActionLifetime;
    }

    public void setGovActionDeposit(BigInteger govActionDeposit) {
        this.govActionDeposit = govActionDeposit;
    }

    public void setDrepDeposit(BigInteger drepDeposit) {
        this.drepDeposit = drepDeposit;
    }

    public void setDrepActivity(Integer drepActivity) {
        this.drepActivity = drepActivity;
    }

    public void setMinFeeRefScriptCostPerByte(BigDecimal minFeeRefScriptCostPerByte) {
        this.minFeeRefScriptCostPerByte = minFeeRefScriptCostPerByte;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocolParams)) {
            return false;
        }
        ProtocolParams other = (ProtocolParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minFeeA = this.getMinFeeA();
        Integer other$minFeeA = other.getMinFeeA();
        if (this$minFeeA == null ? other$minFeeA != null : !((Object)this$minFeeA).equals(other$minFeeA)) {
            return false;
        }
        Integer this$minFeeB = this.getMinFeeB();
        Integer other$minFeeB = other.getMinFeeB();
        if (this$minFeeB == null ? other$minFeeB != null : !((Object)this$minFeeB).equals(other$minFeeB)) {
            return false;
        }
        Integer this$maxBlockSize = this.getMaxBlockSize();
        Integer other$maxBlockSize = other.getMaxBlockSize();
        if (this$maxBlockSize == null ? other$maxBlockSize != null : !((Object)this$maxBlockSize).equals(other$maxBlockSize)) {
            return false;
        }
        Integer this$maxTxSize = this.getMaxTxSize();
        Integer other$maxTxSize = other.getMaxTxSize();
        if (this$maxTxSize == null ? other$maxTxSize != null : !((Object)this$maxTxSize).equals(other$maxTxSize)) {
            return false;
        }
        Integer this$maxBlockHeaderSize = this.getMaxBlockHeaderSize();
        Integer other$maxBlockHeaderSize = other.getMaxBlockHeaderSize();
        if (this$maxBlockHeaderSize == null ? other$maxBlockHeaderSize != null : !((Object)this$maxBlockHeaderSize).equals(other$maxBlockHeaderSize)) {
            return false;
        }
        Integer this$maxEpoch = this.getMaxEpoch();
        Integer other$maxEpoch = other.getMaxEpoch();
        if (this$maxEpoch == null ? other$maxEpoch != null : !((Object)this$maxEpoch).equals(other$maxEpoch)) {
            return false;
        }
        Integer this$nOpt = this.getNOpt();
        Integer other$nOpt = other.getNOpt();
        if (this$nOpt == null ? other$nOpt != null : !((Object)this$nOpt).equals(other$nOpt)) {
            return false;
        }
        Integer this$protocolMajorVer = this.getProtocolMajorVer();
        Integer other$protocolMajorVer = other.getProtocolMajorVer();
        if (this$protocolMajorVer == null ? other$protocolMajorVer != null : !((Object)this$protocolMajorVer).equals(other$protocolMajorVer)) {
            return false;
        }
        Integer this$protocolMinorVer = this.getProtocolMinorVer();
        Integer other$protocolMinorVer = other.getProtocolMinorVer();
        if (this$protocolMinorVer == null ? other$protocolMinorVer != null : !((Object)this$protocolMinorVer).equals(other$protocolMinorVer)) {
            return false;
        }
        Long this$maxValSize = this.getMaxValSize();
        Long other$maxValSize = other.getMaxValSize();
        if (this$maxValSize == null ? other$maxValSize != null : !((Object)this$maxValSize).equals(other$maxValSize)) {
            return false;
        }
        Integer this$collateralPercent = this.getCollateralPercent();
        Integer other$collateralPercent = other.getCollateralPercent();
        if (this$collateralPercent == null ? other$collateralPercent != null : !((Object)this$collateralPercent).equals(other$collateralPercent)) {
            return false;
        }
        Integer this$maxCollateralInputs = this.getMaxCollateralInputs();
        Integer other$maxCollateralInputs = other.getMaxCollateralInputs();
        if (this$maxCollateralInputs == null ? other$maxCollateralInputs != null : !((Object)this$maxCollateralInputs).equals(other$maxCollateralInputs)) {
            return false;
        }
        Integer this$committeeMinSize = this.getCommitteeMinSize();
        Integer other$committeeMinSize = other.getCommitteeMinSize();
        if (this$committeeMinSize == null ? other$committeeMinSize != null : !((Object)this$committeeMinSize).equals(other$committeeMinSize)) {
            return false;
        }
        Integer this$committeeMaxTermLength = this.getCommitteeMaxTermLength();
        Integer other$committeeMaxTermLength = other.getCommitteeMaxTermLength();
        if (this$committeeMaxTermLength == null ? other$committeeMaxTermLength != null : !((Object)this$committeeMaxTermLength).equals(other$committeeMaxTermLength)) {
            return false;
        }
        Integer this$govActionLifetime = this.getGovActionLifetime();
        Integer other$govActionLifetime = other.getGovActionLifetime();
        if (this$govActionLifetime == null ? other$govActionLifetime != null : !((Object)this$govActionLifetime).equals(other$govActionLifetime)) {
            return false;
        }
        Integer this$drepActivity = this.getDrepActivity();
        Integer other$drepActivity = other.getDrepActivity();
        if (this$drepActivity == null ? other$drepActivity != null : !((Object)this$drepActivity).equals(other$drepActivity)) {
            return false;
        }
        BigInteger this$keyDeposit = this.getKeyDeposit();
        BigInteger other$keyDeposit = other.getKeyDeposit();
        if (this$keyDeposit == null ? other$keyDeposit != null : !((Object)this$keyDeposit).equals(other$keyDeposit)) {
            return false;
        }
        BigInteger this$poolDeposit = this.getPoolDeposit();
        BigInteger other$poolDeposit = other.getPoolDeposit();
        if (this$poolDeposit == null ? other$poolDeposit != null : !((Object)this$poolDeposit).equals(other$poolDeposit)) {
            return false;
        }
        BigDecimal this$poolPledgeInfluence = this.getPoolPledgeInfluence();
        BigDecimal other$poolPledgeInfluence = other.getPoolPledgeInfluence();
        if (this$poolPledgeInfluence == null ? other$poolPledgeInfluence != null : !((Object)this$poolPledgeInfluence).equals(other$poolPledgeInfluence)) {
            return false;
        }
        BigDecimal this$expansionRate = this.getExpansionRate();
        BigDecimal other$expansionRate = other.getExpansionRate();
        if (this$expansionRate == null ? other$expansionRate != null : !((Object)this$expansionRate).equals(other$expansionRate)) {
            return false;
        }
        BigDecimal this$treasuryGrowthRate = this.getTreasuryGrowthRate();
        BigDecimal other$treasuryGrowthRate = other.getTreasuryGrowthRate();
        if (this$treasuryGrowthRate == null ? other$treasuryGrowthRate != null : !((Object)this$treasuryGrowthRate).equals(other$treasuryGrowthRate)) {
            return false;
        }
        BigDecimal this$decentralisationParam = this.getDecentralisationParam();
        BigDecimal other$decentralisationParam = other.getDecentralisationParam();
        if (this$decentralisationParam == null ? other$decentralisationParam != null : !((Object)this$decentralisationParam).equals(other$decentralisationParam)) {
            return false;
        }
        String this$extraEntropy = this.getExtraEntropy();
        String other$extraEntropy = other.getExtraEntropy();
        if (this$extraEntropy == null ? other$extraEntropy != null : !this$extraEntropy.equals(other$extraEntropy)) {
            return false;
        }
        BigInteger this$minUtxo = this.getMinUtxo();
        BigInteger other$minUtxo = other.getMinUtxo();
        if (this$minUtxo == null ? other$minUtxo != null : !((Object)this$minUtxo).equals(other$minUtxo)) {
            return false;
        }
        BigInteger this$minPoolCost = this.getMinPoolCost();
        BigInteger other$minPoolCost = other.getMinPoolCost();
        if (this$minPoolCost == null ? other$minPoolCost != null : !((Object)this$minPoolCost).equals(other$minPoolCost)) {
            return false;
        }
        BigInteger this$adaPerUtxoByte = this.getAdaPerUtxoByte();
        BigInteger other$adaPerUtxoByte = other.getAdaPerUtxoByte();
        if (this$adaPerUtxoByte == null ? other$adaPerUtxoByte != null : !((Object)this$adaPerUtxoByte).equals(other$adaPerUtxoByte)) {
            return false;
        }
        Map<String, long[]> this$costModels = this.getCostModels();
        Map<String, long[]> other$costModels = other.getCostModels();
        if (this$costModels == null ? other$costModels != null : !((Object)this$costModels).equals(other$costModels)) {
            return false;
        }
        String this$costModelsHash = this.getCostModelsHash();
        String other$costModelsHash = other.getCostModelsHash();
        if (this$costModelsHash == null ? other$costModelsHash != null : !this$costModelsHash.equals(other$costModelsHash)) {
            return false;
        }
        BigDecimal this$priceMem = this.getPriceMem();
        BigDecimal other$priceMem = other.getPriceMem();
        if (this$priceMem == null ? other$priceMem != null : !((Object)this$priceMem).equals(other$priceMem)) {
            return false;
        }
        BigDecimal this$priceStep = this.getPriceStep();
        BigDecimal other$priceStep = other.getPriceStep();
        if (this$priceStep == null ? other$priceStep != null : !((Object)this$priceStep).equals(other$priceStep)) {
            return false;
        }
        BigInteger this$maxTxExMem = this.getMaxTxExMem();
        BigInteger other$maxTxExMem = other.getMaxTxExMem();
        if (this$maxTxExMem == null ? other$maxTxExMem != null : !((Object)this$maxTxExMem).equals(other$maxTxExMem)) {
            return false;
        }
        BigInteger this$maxTxExSteps = this.getMaxTxExSteps();
        BigInteger other$maxTxExSteps = other.getMaxTxExSteps();
        if (this$maxTxExSteps == null ? other$maxTxExSteps != null : !((Object)this$maxTxExSteps).equals(other$maxTxExSteps)) {
            return false;
        }
        BigInteger this$maxBlockExMem = this.getMaxBlockExMem();
        BigInteger other$maxBlockExMem = other.getMaxBlockExMem();
        if (this$maxBlockExMem == null ? other$maxBlockExMem != null : !((Object)this$maxBlockExMem).equals(other$maxBlockExMem)) {
            return false;
        }
        BigInteger this$maxBlockExSteps = this.getMaxBlockExSteps();
        BigInteger other$maxBlockExSteps = other.getMaxBlockExSteps();
        if (this$maxBlockExSteps == null ? other$maxBlockExSteps != null : !((Object)this$maxBlockExSteps).equals(other$maxBlockExSteps)) {
            return false;
        }
        PoolVotingThresholds this$poolVotingThresholds = this.getPoolVotingThresholds();
        PoolVotingThresholds other$poolVotingThresholds = other.getPoolVotingThresholds();
        if (this$poolVotingThresholds == null ? other$poolVotingThresholds != null : !((Object)this$poolVotingThresholds).equals(other$poolVotingThresholds)) {
            return false;
        }
        DrepVoteThresholds this$drepVotingThresholds = this.getDrepVotingThresholds();
        DrepVoteThresholds other$drepVotingThresholds = other.getDrepVotingThresholds();
        if (this$drepVotingThresholds == null ? other$drepVotingThresholds != null : !((Object)this$drepVotingThresholds).equals(other$drepVotingThresholds)) {
            return false;
        }
        BigInteger this$govActionDeposit = this.getGovActionDeposit();
        BigInteger other$govActionDeposit = other.getGovActionDeposit();
        if (this$govActionDeposit == null ? other$govActionDeposit != null : !((Object)this$govActionDeposit).equals(other$govActionDeposit)) {
            return false;
        }
        BigInteger this$drepDeposit = this.getDrepDeposit();
        BigInteger other$drepDeposit = other.getDrepDeposit();
        if (this$drepDeposit == null ? other$drepDeposit != null : !((Object)this$drepDeposit).equals(other$drepDeposit)) {
            return false;
        }
        BigDecimal this$minFeeRefScriptCostPerByte = this.getMinFeeRefScriptCostPerByte();
        BigDecimal other$minFeeRefScriptCostPerByte = other.getMinFeeRefScriptCostPerByte();
        return !(this$minFeeRefScriptCostPerByte == null ? other$minFeeRefScriptCostPerByte != null : !((Object)this$minFeeRefScriptCostPerByte).equals(other$minFeeRefScriptCostPerByte));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtocolParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minFeeA = this.getMinFeeA();
        result = result * 59 + ($minFeeA == null ? 43 : ((Object)$minFeeA).hashCode());
        Integer $minFeeB = this.getMinFeeB();
        result = result * 59 + ($minFeeB == null ? 43 : ((Object)$minFeeB).hashCode());
        Integer $maxBlockSize = this.getMaxBlockSize();
        result = result * 59 + ($maxBlockSize == null ? 43 : ((Object)$maxBlockSize).hashCode());
        Integer $maxTxSize = this.getMaxTxSize();
        result = result * 59 + ($maxTxSize == null ? 43 : ((Object)$maxTxSize).hashCode());
        Integer $maxBlockHeaderSize = this.getMaxBlockHeaderSize();
        result = result * 59 + ($maxBlockHeaderSize == null ? 43 : ((Object)$maxBlockHeaderSize).hashCode());
        Integer $maxEpoch = this.getMaxEpoch();
        result = result * 59 + ($maxEpoch == null ? 43 : ((Object)$maxEpoch).hashCode());
        Integer $nOpt = this.getNOpt();
        result = result * 59 + ($nOpt == null ? 43 : ((Object)$nOpt).hashCode());
        Integer $protocolMajorVer = this.getProtocolMajorVer();
        result = result * 59 + ($protocolMajorVer == null ? 43 : ((Object)$protocolMajorVer).hashCode());
        Integer $protocolMinorVer = this.getProtocolMinorVer();
        result = result * 59 + ($protocolMinorVer == null ? 43 : ((Object)$protocolMinorVer).hashCode());
        Long $maxValSize = this.getMaxValSize();
        result = result * 59 + ($maxValSize == null ? 43 : ((Object)$maxValSize).hashCode());
        Integer $collateralPercent = this.getCollateralPercent();
        result = result * 59 + ($collateralPercent == null ? 43 : ((Object)$collateralPercent).hashCode());
        Integer $maxCollateralInputs = this.getMaxCollateralInputs();
        result = result * 59 + ($maxCollateralInputs == null ? 43 : ((Object)$maxCollateralInputs).hashCode());
        Integer $committeeMinSize = this.getCommitteeMinSize();
        result = result * 59 + ($committeeMinSize == null ? 43 : ((Object)$committeeMinSize).hashCode());
        Integer $committeeMaxTermLength = this.getCommitteeMaxTermLength();
        result = result * 59 + ($committeeMaxTermLength == null ? 43 : ((Object)$committeeMaxTermLength).hashCode());
        Integer $govActionLifetime = this.getGovActionLifetime();
        result = result * 59 + ($govActionLifetime == null ? 43 : ((Object)$govActionLifetime).hashCode());
        Integer $drepActivity = this.getDrepActivity();
        result = result * 59 + ($drepActivity == null ? 43 : ((Object)$drepActivity).hashCode());
        BigInteger $keyDeposit = this.getKeyDeposit();
        result = result * 59 + ($keyDeposit == null ? 43 : ((Object)$keyDeposit).hashCode());
        BigInteger $poolDeposit = this.getPoolDeposit();
        result = result * 59 + ($poolDeposit == null ? 43 : ((Object)$poolDeposit).hashCode());
        BigDecimal $poolPledgeInfluence = this.getPoolPledgeInfluence();
        result = result * 59 + ($poolPledgeInfluence == null ? 43 : ((Object)$poolPledgeInfluence).hashCode());
        BigDecimal $expansionRate = this.getExpansionRate();
        result = result * 59 + ($expansionRate == null ? 43 : ((Object)$expansionRate).hashCode());
        BigDecimal $treasuryGrowthRate = this.getTreasuryGrowthRate();
        result = result * 59 + ($treasuryGrowthRate == null ? 43 : ((Object)$treasuryGrowthRate).hashCode());
        BigDecimal $decentralisationParam = this.getDecentralisationParam();
        result = result * 59 + ($decentralisationParam == null ? 43 : ((Object)$decentralisationParam).hashCode());
        String $extraEntropy = this.getExtraEntropy();
        result = result * 59 + ($extraEntropy == null ? 43 : $extraEntropy.hashCode());
        BigInteger $minUtxo = this.getMinUtxo();
        result = result * 59 + ($minUtxo == null ? 43 : ((Object)$minUtxo).hashCode());
        BigInteger $minPoolCost = this.getMinPoolCost();
        result = result * 59 + ($minPoolCost == null ? 43 : ((Object)$minPoolCost).hashCode());
        BigInteger $adaPerUtxoByte = this.getAdaPerUtxoByte();
        result = result * 59 + ($adaPerUtxoByte == null ? 43 : ((Object)$adaPerUtxoByte).hashCode());
        Map<String, long[]> $costModels = this.getCostModels();
        result = result * 59 + ($costModels == null ? 43 : ((Object)$costModels).hashCode());
        String $costModelsHash = this.getCostModelsHash();
        result = result * 59 + ($costModelsHash == null ? 43 : $costModelsHash.hashCode());
        BigDecimal $priceMem = this.getPriceMem();
        result = result * 59 + ($priceMem == null ? 43 : ((Object)$priceMem).hashCode());
        BigDecimal $priceStep = this.getPriceStep();
        result = result * 59 + ($priceStep == null ? 43 : ((Object)$priceStep).hashCode());
        BigInteger $maxTxExMem = this.getMaxTxExMem();
        result = result * 59 + ($maxTxExMem == null ? 43 : ((Object)$maxTxExMem).hashCode());
        BigInteger $maxTxExSteps = this.getMaxTxExSteps();
        result = result * 59 + ($maxTxExSteps == null ? 43 : ((Object)$maxTxExSteps).hashCode());
        BigInteger $maxBlockExMem = this.getMaxBlockExMem();
        result = result * 59 + ($maxBlockExMem == null ? 43 : ((Object)$maxBlockExMem).hashCode());
        BigInteger $maxBlockExSteps = this.getMaxBlockExSteps();
        result = result * 59 + ($maxBlockExSteps == null ? 43 : ((Object)$maxBlockExSteps).hashCode());
        PoolVotingThresholds $poolVotingThresholds = this.getPoolVotingThresholds();
        result = result * 59 + ($poolVotingThresholds == null ? 43 : ((Object)$poolVotingThresholds).hashCode());
        DrepVoteThresholds $drepVotingThresholds = this.getDrepVotingThresholds();
        result = result * 59 + ($drepVotingThresholds == null ? 43 : ((Object)$drepVotingThresholds).hashCode());
        BigInteger $govActionDeposit = this.getGovActionDeposit();
        result = result * 59 + ($govActionDeposit == null ? 43 : ((Object)$govActionDeposit).hashCode());
        BigInteger $drepDeposit = this.getDrepDeposit();
        result = result * 59 + ($drepDeposit == null ? 43 : ((Object)$drepDeposit).hashCode());
        BigDecimal $minFeeRefScriptCostPerByte = this.getMinFeeRefScriptCostPerByte();
        result = result * 59 + ($minFeeRefScriptCostPerByte == null ? 43 : ((Object)$minFeeRefScriptCostPerByte).hashCode());
        return result;
    }

    public String toString() {
        return "ProtocolParams(minFeeA=" + this.getMinFeeA() + ", minFeeB=" + this.getMinFeeB() + ", maxBlockSize=" + this.getMaxBlockSize() + ", maxTxSize=" + this.getMaxTxSize() + ", maxBlockHeaderSize=" + this.getMaxBlockHeaderSize() + ", keyDeposit=" + String.valueOf(this.getKeyDeposit()) + ", poolDeposit=" + String.valueOf(this.getPoolDeposit()) + ", maxEpoch=" + this.getMaxEpoch() + ", nOpt=" + this.getNOpt() + ", poolPledgeInfluence=" + String.valueOf(this.getPoolPledgeInfluence()) + ", expansionRate=" + String.valueOf(this.getExpansionRate()) + ", treasuryGrowthRate=" + String.valueOf(this.getTreasuryGrowthRate()) + ", decentralisationParam=" + String.valueOf(this.getDecentralisationParam()) + ", extraEntropy=" + this.getExtraEntropy() + ", protocolMajorVer=" + this.getProtocolMajorVer() + ", protocolMinorVer=" + this.getProtocolMinorVer() + ", minUtxo=" + String.valueOf(this.getMinUtxo()) + ", minPoolCost=" + String.valueOf(this.getMinPoolCost()) + ", adaPerUtxoByte=" + String.valueOf(this.getAdaPerUtxoByte()) + ", costModels=" + String.valueOf(this.getCostModels()) + ", costModelsHash=" + this.getCostModelsHash() + ", priceMem=" + String.valueOf(this.getPriceMem()) + ", priceStep=" + String.valueOf(this.getPriceStep()) + ", maxTxExMem=" + String.valueOf(this.getMaxTxExMem()) + ", maxTxExSteps=" + String.valueOf(this.getMaxTxExSteps()) + ", maxBlockExMem=" + String.valueOf(this.getMaxBlockExMem()) + ", maxBlockExSteps=" + String.valueOf(this.getMaxBlockExSteps()) + ", maxValSize=" + this.getMaxValSize() + ", collateralPercent=" + this.getCollateralPercent() + ", maxCollateralInputs=" + this.getMaxCollateralInputs() + ", poolVotingThresholds=" + String.valueOf(this.getPoolVotingThresholds()) + ", drepVotingThresholds=" + String.valueOf(this.getDrepVotingThresholds()) + ", committeeMinSize=" + this.getCommitteeMinSize() + ", committeeMaxTermLength=" + this.getCommitteeMaxTermLength() + ", govActionLifetime=" + this.getGovActionLifetime() + ", govActionDeposit=" + String.valueOf(this.getGovActionDeposit()) + ", drepDeposit=" + String.valueOf(this.getDrepDeposit()) + ", drepActivity=" + this.getDrepActivity() + ", minFeeRefScriptCostPerByte=" + String.valueOf(this.getMinFeeRefScriptCostPerByte()) + ")";
    }

    public ProtocolParams() {
    }

    public ProtocolParams(Integer minFeeA, Integer minFeeB, Integer maxBlockSize, Integer maxTxSize, Integer maxBlockHeaderSize, BigInteger keyDeposit, BigInteger poolDeposit, Integer maxEpoch, Integer nOpt, BigDecimal poolPledgeInfluence, BigDecimal expansionRate, BigDecimal treasuryGrowthRate, BigDecimal decentralisationParam, String extraEntropy, Integer protocolMajorVer, Integer protocolMinorVer, BigInteger minUtxo, BigInteger minPoolCost, BigInteger adaPerUtxoByte, Map<String, long[]> costModels, String costModelsHash, BigDecimal priceMem, BigDecimal priceStep, BigInteger maxTxExMem, BigInteger maxTxExSteps, BigInteger maxBlockExMem, BigInteger maxBlockExSteps, Long maxValSize, Integer collateralPercent, Integer maxCollateralInputs, PoolVotingThresholds poolVotingThresholds, DrepVoteThresholds drepVotingThresholds, Integer committeeMinSize, Integer committeeMaxTermLength, Integer govActionLifetime, BigInteger govActionDeposit, BigInteger drepDeposit, Integer drepActivity, BigDecimal minFeeRefScriptCostPerByte) {
        this.minFeeA = minFeeA;
        this.minFeeB = minFeeB;
        this.maxBlockSize = maxBlockSize;
        this.maxTxSize = maxTxSize;
        this.maxBlockHeaderSize = maxBlockHeaderSize;
        this.keyDeposit = keyDeposit;
        this.poolDeposit = poolDeposit;
        this.maxEpoch = maxEpoch;
        this.nOpt = nOpt;
        this.poolPledgeInfluence = poolPledgeInfluence;
        this.expansionRate = expansionRate;
        this.treasuryGrowthRate = treasuryGrowthRate;
        this.decentralisationParam = decentralisationParam;
        this.extraEntropy = extraEntropy;
        this.protocolMajorVer = protocolMajorVer;
        this.protocolMinorVer = protocolMinorVer;
        this.minUtxo = minUtxo;
        this.minPoolCost = minPoolCost;
        this.adaPerUtxoByte = adaPerUtxoByte;
        this.costModels = costModels;
        this.costModelsHash = costModelsHash;
        this.priceMem = priceMem;
        this.priceStep = priceStep;
        this.maxTxExMem = maxTxExMem;
        this.maxTxExSteps = maxTxExSteps;
        this.maxBlockExMem = maxBlockExMem;
        this.maxBlockExSteps = maxBlockExSteps;
        this.maxValSize = maxValSize;
        this.collateralPercent = collateralPercent;
        this.maxCollateralInputs = maxCollateralInputs;
        this.poolVotingThresholds = poolVotingThresholds;
        this.drepVotingThresholds = drepVotingThresholds;
        this.committeeMinSize = committeeMinSize;
        this.committeeMaxTermLength = committeeMaxTermLength;
        this.govActionLifetime = govActionLifetime;
        this.govActionDeposit = govActionDeposit;
        this.drepDeposit = drepDeposit;
        this.drepActivity = drepActivity;
        this.minFeeRefScriptCostPerByte = minFeeRefScriptCostPerByte;
    }

    public static class ProtocolParamsBuilder {
        private Integer minFeeA;
        private Integer minFeeB;
        private Integer maxBlockSize;
        private Integer maxTxSize;
        private Integer maxBlockHeaderSize;
        private BigInteger keyDeposit;
        private BigInteger poolDeposit;
        private Integer maxEpoch;
        private Integer nOpt;
        private BigDecimal poolPledgeInfluence;
        private BigDecimal expansionRate;
        private BigDecimal treasuryGrowthRate;
        private BigDecimal decentralisationParam;
        private String extraEntropy;
        private Integer protocolMajorVer;
        private Integer protocolMinorVer;
        private BigInteger minUtxo;
        private BigInteger minPoolCost;
        private BigInteger adaPerUtxoByte;
        private Map<String, long[]> costModels;
        private String costModelsHash;
        private BigDecimal priceMem;
        private BigDecimal priceStep;
        private BigInteger maxTxExMem;
        private BigInteger maxTxExSteps;
        private BigInteger maxBlockExMem;
        private BigInteger maxBlockExSteps;
        private Long maxValSize;
        private Integer collateralPercent;
        private Integer maxCollateralInputs;
        private PoolVotingThresholds poolVotingThresholds;
        private DrepVoteThresholds drepVotingThresholds;
        private Integer committeeMinSize;
        private Integer committeeMaxTermLength;
        private Integer govActionLifetime;
        private BigInteger govActionDeposit;
        private BigInteger drepDeposit;
        private Integer drepActivity;
        private BigDecimal minFeeRefScriptCostPerByte;

        ProtocolParamsBuilder() {
        }

        public ProtocolParamsBuilder minFeeA(Integer minFeeA) {
            this.minFeeA = minFeeA;
            return this;
        }

        public ProtocolParamsBuilder minFeeB(Integer minFeeB) {
            this.minFeeB = minFeeB;
            return this;
        }

        public ProtocolParamsBuilder maxBlockSize(Integer maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public ProtocolParamsBuilder maxTxSize(Integer maxTxSize) {
            this.maxTxSize = maxTxSize;
            return this;
        }

        public ProtocolParamsBuilder maxBlockHeaderSize(Integer maxBlockHeaderSize) {
            this.maxBlockHeaderSize = maxBlockHeaderSize;
            return this;
        }

        public ProtocolParamsBuilder keyDeposit(BigInteger keyDeposit) {
            this.keyDeposit = keyDeposit;
            return this;
        }

        public ProtocolParamsBuilder poolDeposit(BigInteger poolDeposit) {
            this.poolDeposit = poolDeposit;
            return this;
        }

        public ProtocolParamsBuilder maxEpoch(Integer maxEpoch) {
            this.maxEpoch = maxEpoch;
            return this;
        }

        @JsonProperty(value="nopt")
        public ProtocolParamsBuilder nOpt(Integer nOpt) {
            this.nOpt = nOpt;
            return this;
        }

        public ProtocolParamsBuilder poolPledgeInfluence(BigDecimal poolPledgeInfluence) {
            this.poolPledgeInfluence = poolPledgeInfluence;
            return this;
        }

        public ProtocolParamsBuilder expansionRate(BigDecimal expansionRate) {
            this.expansionRate = expansionRate;
            return this;
        }

        public ProtocolParamsBuilder treasuryGrowthRate(BigDecimal treasuryGrowthRate) {
            this.treasuryGrowthRate = treasuryGrowthRate;
            return this;
        }

        public ProtocolParamsBuilder decentralisationParam(BigDecimal decentralisationParam) {
            this.decentralisationParam = decentralisationParam;
            return this;
        }

        public ProtocolParamsBuilder extraEntropy(String extraEntropy) {
            this.extraEntropy = extraEntropy;
            return this;
        }

        public ProtocolParamsBuilder protocolMajorVer(Integer protocolMajorVer) {
            this.protocolMajorVer = protocolMajorVer;
            return this;
        }

        public ProtocolParamsBuilder protocolMinorVer(Integer protocolMinorVer) {
            this.protocolMinorVer = protocolMinorVer;
            return this;
        }

        public ProtocolParamsBuilder minUtxo(BigInteger minUtxo) {
            this.minUtxo = minUtxo;
            return this;
        }

        public ProtocolParamsBuilder minPoolCost(BigInteger minPoolCost) {
            this.minPoolCost = minPoolCost;
            return this;
        }

        public ProtocolParamsBuilder adaPerUtxoByte(BigInteger adaPerUtxoByte) {
            this.adaPerUtxoByte = adaPerUtxoByte;
            return this;
        }

        public ProtocolParamsBuilder costModels(Map<String, long[]> costModels) {
            this.costModels = costModels;
            return this;
        }

        public ProtocolParamsBuilder costModelsHash(String costModelsHash) {
            this.costModelsHash = costModelsHash;
            return this;
        }

        public ProtocolParamsBuilder priceMem(BigDecimal priceMem) {
            this.priceMem = priceMem;
            return this;
        }

        public ProtocolParamsBuilder priceStep(BigDecimal priceStep) {
            this.priceStep = priceStep;
            return this;
        }

        public ProtocolParamsBuilder maxTxExMem(BigInteger maxTxExMem) {
            this.maxTxExMem = maxTxExMem;
            return this;
        }

        public ProtocolParamsBuilder maxTxExSteps(BigInteger maxTxExSteps) {
            this.maxTxExSteps = maxTxExSteps;
            return this;
        }

        public ProtocolParamsBuilder maxBlockExMem(BigInteger maxBlockExMem) {
            this.maxBlockExMem = maxBlockExMem;
            return this;
        }

        public ProtocolParamsBuilder maxBlockExSteps(BigInteger maxBlockExSteps) {
            this.maxBlockExSteps = maxBlockExSteps;
            return this;
        }

        public ProtocolParamsBuilder maxValSize(Long maxValSize) {
            this.maxValSize = maxValSize;
            return this;
        }

        public ProtocolParamsBuilder collateralPercent(Integer collateralPercent) {
            this.collateralPercent = collateralPercent;
            return this;
        }

        public ProtocolParamsBuilder maxCollateralInputs(Integer maxCollateralInputs) {
            this.maxCollateralInputs = maxCollateralInputs;
            return this;
        }

        public ProtocolParamsBuilder poolVotingThresholds(PoolVotingThresholds poolVotingThresholds) {
            this.poolVotingThresholds = poolVotingThresholds;
            return this;
        }

        public ProtocolParamsBuilder drepVotingThresholds(DrepVoteThresholds drepVotingThresholds) {
            this.drepVotingThresholds = drepVotingThresholds;
            return this;
        }

        public ProtocolParamsBuilder committeeMinSize(Integer committeeMinSize) {
            this.committeeMinSize = committeeMinSize;
            return this;
        }

        public ProtocolParamsBuilder committeeMaxTermLength(Integer committeeMaxTermLength) {
            this.committeeMaxTermLength = committeeMaxTermLength;
            return this;
        }

        public ProtocolParamsBuilder govActionLifetime(Integer govActionLifetime) {
            this.govActionLifetime = govActionLifetime;
            return this;
        }

        public ProtocolParamsBuilder govActionDeposit(BigInteger govActionDeposit) {
            this.govActionDeposit = govActionDeposit;
            return this;
        }

        public ProtocolParamsBuilder drepDeposit(BigInteger drepDeposit) {
            this.drepDeposit = drepDeposit;
            return this;
        }

        public ProtocolParamsBuilder drepActivity(Integer drepActivity) {
            this.drepActivity = drepActivity;
            return this;
        }

        public ProtocolParamsBuilder minFeeRefScriptCostPerByte(BigDecimal minFeeRefScriptCostPerByte) {
            this.minFeeRefScriptCostPerByte = minFeeRefScriptCostPerByte;
            return this;
        }

        public ProtocolParams build() {
            return new ProtocolParams(this.minFeeA, this.minFeeB, this.maxBlockSize, this.maxTxSize, this.maxBlockHeaderSize, this.keyDeposit, this.poolDeposit, this.maxEpoch, this.nOpt, this.poolPledgeInfluence, this.expansionRate, this.treasuryGrowthRate, this.decentralisationParam, this.extraEntropy, this.protocolMajorVer, this.protocolMinorVer, this.minUtxo, this.minPoolCost, this.adaPerUtxoByte, this.costModels, this.costModelsHash, this.priceMem, this.priceStep, this.maxTxExMem, this.maxTxExSteps, this.maxBlockExMem, this.maxBlockExSteps, this.maxValSize, this.collateralPercent, this.maxCollateralInputs, this.poolVotingThresholds, this.drepVotingThresholds, this.committeeMinSize, this.committeeMaxTermLength, this.govActionLifetime, this.govActionDeposit, this.drepDeposit, this.drepActivity, this.minFeeRefScriptCostPerByte);
        }

        public String toString() {
            return "ProtocolParams.ProtocolParamsBuilder(minFeeA=" + this.minFeeA + ", minFeeB=" + this.minFeeB + ", maxBlockSize=" + this.maxBlockSize + ", maxTxSize=" + this.maxTxSize + ", maxBlockHeaderSize=" + this.maxBlockHeaderSize + ", keyDeposit=" + String.valueOf(this.keyDeposit) + ", poolDeposit=" + String.valueOf(this.poolDeposit) + ", maxEpoch=" + this.maxEpoch + ", nOpt=" + this.nOpt + ", poolPledgeInfluence=" + String.valueOf(this.poolPledgeInfluence) + ", expansionRate=" + String.valueOf(this.expansionRate) + ", treasuryGrowthRate=" + String.valueOf(this.treasuryGrowthRate) + ", decentralisationParam=" + String.valueOf(this.decentralisationParam) + ", extraEntropy=" + this.extraEntropy + ", protocolMajorVer=" + this.protocolMajorVer + ", protocolMinorVer=" + this.protocolMinorVer + ", minUtxo=" + String.valueOf(this.minUtxo) + ", minPoolCost=" + String.valueOf(this.minPoolCost) + ", adaPerUtxoByte=" + String.valueOf(this.adaPerUtxoByte) + ", costModels=" + String.valueOf(this.costModels) + ", costModelsHash=" + this.costModelsHash + ", priceMem=" + String.valueOf(this.priceMem) + ", priceStep=" + String.valueOf(this.priceStep) + ", maxTxExMem=" + String.valueOf(this.maxTxExMem) + ", maxTxExSteps=" + String.valueOf(this.maxTxExSteps) + ", maxBlockExMem=" + String.valueOf(this.maxBlockExMem) + ", maxBlockExSteps=" + String.valueOf(this.maxBlockExSteps) + ", maxValSize=" + this.maxValSize + ", collateralPercent=" + this.collateralPercent + ", maxCollateralInputs=" + this.maxCollateralInputs + ", poolVotingThresholds=" + String.valueOf(this.poolVotingThresholds) + ", drepVotingThresholds=" + String.valueOf(this.drepVotingThresholds) + ", committeeMinSize=" + this.committeeMinSize + ", committeeMaxTermLength=" + this.committeeMaxTermLength + ", govActionLifetime=" + this.govActionLifetime + ", govActionDeposit=" + String.valueOf(this.govActionDeposit) + ", drepDeposit=" + String.valueOf(this.drepDeposit) + ", drepActivity=" + this.drepActivity + ", minFeeRefScriptCostPerByte=" + String.valueOf(this.minFeeRefScriptCostPerByte) + ")";
        }
    }
}

