/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.math.BigInteger;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Utxo {
    private String txHash;
    private int outputIndex;
    private String address;
    private List<Amount> amount;
    private String dataHash;
    private String inlineDatum;
    private String referenceScriptHash;
    private Integer epoch;
    private Long blockNumber;
    private Long blockTime;

    public static UtxoBuilder builder() {
        return new UtxoBuilder();
    }

    public String getTxHash() {
        return this.txHash;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public String getAddress() {
        return this.address;
    }

    public List<Amount> getAmount() {
        return this.amount;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public String getInlineDatum() {
        return this.inlineDatum;
    }

    public String getReferenceScriptHash() {
        return this.referenceScriptHash;
    }

    public Integer getEpoch() {
        return this.epoch;
    }

    public Long getBlockNumber() {
        return this.blockNumber;
    }

    public Long getBlockTime() {
        return this.blockTime;
    }

    public String toString() {
        return "Utxo(txHash=" + this.getTxHash() + ", outputIndex=" + this.getOutputIndex() + ", address=" + this.getAddress() + ", amount=" + String.valueOf(this.getAmount()) + ", dataHash=" + this.getDataHash() + ", inlineDatum=" + this.getInlineDatum() + ", referenceScriptHash=" + this.getReferenceScriptHash() + ", epoch=" + this.getEpoch() + ", blockNumber=" + this.getBlockNumber() + ", blockTime=" + this.getBlockTime() + ")";
    }

    public Utxo() {
    }

    public Utxo(String txHash, int outputIndex, String address, List<Amount> amount, String dataHash, String inlineDatum, String referenceScriptHash, Integer epoch, Long blockNumber, Long blockTime) {
        this.txHash = txHash;
        this.outputIndex = outputIndex;
        this.address = address;
        this.amount = amount;
        this.dataHash = dataHash;
        this.inlineDatum = inlineDatum;
        this.referenceScriptHash = referenceScriptHash;
        this.epoch = epoch;
        this.blockNumber = blockNumber;
        this.blockTime = blockTime;
    }

    public static class UtxoBuilder {
        private String txHash;
        private int outputIndex;
        private String address;
        private List<Amount> amount;
        private String dataHash;
        private String inlineDatum;
        private String referenceScriptHash;
        private Integer epoch;
        private Long blockNumber;
        private Long blockTime;

        UtxoBuilder() {
        }

        public UtxoBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public UtxoBuilder outputIndex(int outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        public UtxoBuilder address(String address) {
            this.address = address;
            return this;
        }

        public UtxoBuilder amount(List<Amount> amount) {
            this.amount = amount;
            return this;
        }

        public UtxoBuilder dataHash(String dataHash) {
            this.dataHash = dataHash;
            return this;
        }

        public UtxoBuilder inlineDatum(String inlineDatum) {
            this.inlineDatum = inlineDatum;
            return this;
        }

        public UtxoBuilder referenceScriptHash(String referenceScriptHash) {
            this.referenceScriptHash = referenceScriptHash;
            return this;
        }

        public UtxoBuilder epoch(Integer epoch) {
            this.epoch = epoch;
            return this;
        }

        public UtxoBuilder blockNumber(Long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public UtxoBuilder blockTime(Long blockTime) {
            this.blockTime = blockTime;
            return this;
        }

        public Utxo build() {
            return new Utxo(this.txHash, this.outputIndex, this.address, this.amount, this.dataHash, this.inlineDatum, this.referenceScriptHash, this.epoch, this.blockNumber, this.blockTime);
        }

        public String toString() {
            return "Utxo.UtxoBuilder(txHash=" + this.txHash + ", outputIndex=" + this.outputIndex + ", address=" + this.address + ", amount=" + String.valueOf(this.amount) + ", dataHash=" + this.dataHash + ", inlineDatum=" + this.inlineDatum + ", referenceScriptHash=" + this.referenceScriptHash + ", epoch=" + this.epoch + ", blockNumber=" + this.blockNumber + ", blockTime=" + this.blockTime + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Amount {
        private String unit;
        @JsonSerialize(using=ToStringSerializer.class)
        private BigInteger quantity;

        public static AmountBuilder builder() {
            return new AmountBuilder();
        }

        public String getUnit() {
            return this.unit;
        }

        public BigInteger getQuantity() {
            return this.quantity;
        }

        public String toString() {
            return "Utxo.Amount(unit=" + this.getUnit() + ", quantity=" + String.valueOf(this.getQuantity()) + ")";
        }

        public Amount() {
        }

        public Amount(String unit, BigInteger quantity) {
            this.unit = unit;
            this.quantity = quantity;
        }

        public static class AmountBuilder {
            private String unit;
            private BigInteger quantity;

            AmountBuilder() {
            }

            public AmountBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public AmountBuilder quantity(BigInteger quantity) {
                this.quantity = quantity;
                return this;
            }

            public Amount build() {
                return new Amount(this.unit, this.quantity);
            }

            public String toString() {
                return "Utxo.Amount.AmountBuilder(unit=" + this.unit + ", quantity=" + String.valueOf(this.quantity) + ")";
            }
        }
    }
}

