/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.executor;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class ParallelExecutor {
    private Executor virtualThreadExecutor = Executors.newVirtualThreadPerTaskExecutor();

    public Executor getVirtualThreadExecutor() {
        return this.virtualThreadExecutor;
    }

    public void executesInParallel(Runnable ... runnable) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Runnable r : runnable) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(r, this.virtualThreadExecutor);
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
    }

    public void setVirtualThreadExecutor(Executor virtualThreadExecutor) {
        this.virtualThreadExecutor = virtualThreadExecutor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParallelExecutor)) {
            return false;
        }
        ParallelExecutor other = (ParallelExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Executor this$virtualThreadExecutor = this.getVirtualThreadExecutor();
        Executor other$virtualThreadExecutor = other.getVirtualThreadExecutor();
        return !(this$virtualThreadExecutor == null ? other$virtualThreadExecutor != null : !this$virtualThreadExecutor.equals(other$virtualThreadExecutor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParallelExecutor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Executor $virtualThreadExecutor = this.getVirtualThreadExecutor();
        result = result * 59 + ($virtualThreadExecutor == null ? 43 : $virtualThreadExecutor.hashCode());
        return result;
    }

    public String toString() {
        return "ParallelExecutor(virtualThreadExecutor=" + String.valueOf(this.getVirtualThreadExecutor()) + ")";
    }
}

