/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.genesis;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Base58;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvvmAddressConverter {
    private static final Logger log = LoggerFactory.getLogger(AvvmAddressConverter.class);

    public static Optional<String> convertAvvmToByronAddress(String avvmAddress) {
        try {
            String avvm = avvmAddress.replace("-", "+").replace("_", "/");
            byte[] ed25519PubKey = Base64.getDecoder().decode(avvm);
            Array byronAddrSpendingDataArr = new Array();
            byronAddrSpendingDataArr.add((DataItem)new UnsignedInteger(2L));
            byronAddrSpendingDataArr.add((DataItem)new ByteString(ed25519PubKey));
            Array addrRoot = new Array();
            int byronAddrType = 2;
            addrRoot.add((DataItem)new UnsignedInteger((long)byronAddrType));
            addrRoot.add((DataItem)byronAddrSpendingDataArr);
            Map byronAddrAttributes = new Map();
            addrRoot.add((DataItem)byronAddrAttributes);
            byte[] addrRootBytes = CborSerializationUtil.serialize((DataItem)addrRoot);
            byte[] sha3256Bytes = AvvmAddressConverter.sha3256Bytes(addrRootBytes);
            byte[] byronAddrRootDoubleHash = Blake2bUtil.blake2bHash224((byte[])sha3256Bytes);
            Array byronAddrPayload = new Array();
            byronAddrPayload.add((DataItem)new ByteString(byronAddrRootDoubleHash));
            byronAddrPayload.add((DataItem)new Map());
            byronAddrPayload.add((DataItem)new UnsignedInteger(2L));
            byte[] addressPayloadCbor = CborSerializationUtil.serialize((DataItem)byronAddrPayload);
            CRC32 crc32 = new CRC32();
            crc32.update(addressPayloadCbor);
            Array byronAddressArr = new Array();
            ByteString payloadBytes = new ByteString(addressPayloadCbor);
            payloadBytes.setTag(24L);
            byronAddressArr.add((DataItem)payloadBytes);
            byronAddressArr.add((DataItem)new UnsignedInteger(crc32.getValue()));
            byte[] byronAddressCbor = CborSerializationUtil.serialize((DataItem)byronAddressArr);
            String base58Address = Base58.encode((byte[])byronAddressCbor);
            return Optional.of(base58Address);
        }
        catch (Exception e) {
            log.error("Error converting avvm address to Byron address", (Throwable)e);
            return Optional.empty();
        }
    }

    private static byte[] sha3256Bytes(byte[] addrRootBytes) throws NoSuchAlgorithmException {
        MessageDigest crypt = MessageDigest.getInstance("SHA3-256");
        crypt.update(addrRootBytes);
        byte[] sha3256Bytes = crypt.digest();
        return sha3256Bytes;
    }
}

